/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;

public class RestRequestMetrics {
    static final String NIO_REQUEST_PROCESSING_TIME_SUFFIX = "NioRequestProcessingTimeInMs";
    static final String NIO_RESPONSE_PROCESSING_TIME_SUFFIX = "NioResponseProcessingTimeInMs";
    static final String NIO_ROUND_TRIP_TIME_SUFFIX = "NioRoundTripTimeInMs";
    static final String NIO_TIME_TO_FIRST_BYTE_SUFFIX = "NioTimeToFirstByteInMs";
    static final String SC_REQUEST_PROCESSING_TIME_SUFFIX = "ScRequestProcessingTimeInMs";
    static final String SC_REQUEST_PROCESSING_WAIT_TIME_SUFFIX = "ScRequestProcessingWaitTimeInMs";
    static final String SC_RESPONSE_PROCESSING_TIME_SUFFIX = "ScResponseProcessingTimeInMs";
    static final String SC_RESPONSE_PROCESSING_WAIT_TIME_SUFFIX = "ScResponseProcessingWaitTimeInMs";
    static final String SC_ROUND_TRIP_TIME_SUFFIX = "ScRoundTripTimeInMs";
    static final String OPERATION_RATE_SUFFIX = "Rate";
    static final String OPERATION_ERROR_SUFFIX = "Error";
    static final String OPERATION_COUNT_SUFFIX = "Count";
    static final String UNSATISFIED_REQUEST_COUNT_SUFFIX = "UnsatisfiedRequestCount";
    static final String SATISFIED_REQUEST_COUNT_SUFFIX = "SatisfiedRequestCount";
    final Histogram nioRequestProcessingTimeInMs;
    final Histogram nioResponseProcessingTimeInMs;
    final Histogram nioRoundTripTimeInMs;
    final Histogram nioTimeToFirstByteInMs;
    final Histogram scRequestProcessingTimeInMs;
    final Histogram scRequestProcessingWaitTimeInMs;
    final Histogram scResponseProcessingTimeInMs;
    final Histogram scResponseProcessingWaitTimeInMs;
    final Histogram scRoundTripTimeInMs;
    final Meter operationRate;
    final Counter operationError;
    final Counter operationCount;
    final Counter unsatisfiedRequestCount;
    final Counter satisfiedRequestCount;

    public RestRequestMetrics(Class ownerClass, String requestType, MetricRegistry metricRegistry) {
        if (ownerClass == null || requestType == null || metricRegistry == null) {
            throw new IllegalArgumentException("Null arg(s) during instantiation. Owner class - [" + ownerClass + "]. Request type - [" + requestType + "]. Metric registry - [" + metricRegistry + "]");
        }
        this.nioRequestProcessingTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + NIO_REQUEST_PROCESSING_TIME_SUFFIX}));
        this.nioResponseProcessingTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + NIO_RESPONSE_PROCESSING_TIME_SUFFIX}));
        this.nioRoundTripTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + NIO_ROUND_TRIP_TIME_SUFFIX}));
        this.nioTimeToFirstByteInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + NIO_TIME_TO_FIRST_BYTE_SUFFIX}));
        this.scRequestProcessingTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SC_REQUEST_PROCESSING_TIME_SUFFIX}));
        this.scRequestProcessingWaitTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SC_REQUEST_PROCESSING_WAIT_TIME_SUFFIX}));
        this.scResponseProcessingTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SC_RESPONSE_PROCESSING_TIME_SUFFIX}));
        this.scResponseProcessingWaitTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SC_RESPONSE_PROCESSING_WAIT_TIME_SUFFIX}));
        this.scRoundTripTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SC_ROUND_TRIP_TIME_SUFFIX}));
        this.operationRate = metricRegistry.meter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + OPERATION_RATE_SUFFIX}));
        this.operationError = metricRegistry.counter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + OPERATION_ERROR_SUFFIX}));
        this.operationCount = metricRegistry.counter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + OPERATION_COUNT_SUFFIX}));
        this.unsatisfiedRequestCount = metricRegistry.counter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + UNSATISFIED_REQUEST_COUNT_SUFFIX}));
        this.satisfiedRequestCount = metricRegistry.counter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{requestType + SATISFIED_REQUEST_COUNT_SUFFIX}));
    }
}

