/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.github.ambry.rest.RestRequest;
import com.github.ambry.rest.RestServiceErrorCode;
import com.github.ambry.rest.RestServiceException;
import com.github.ambry.rest.RestUtils;
import com.github.ambry.router.GetBlobOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RequestPath {
    private final String prefix;
    private final String clusterName;
    private final String operationOrBlobId;
    private final RestUtils.SubResource subResource;
    private final int blobSegmentIdx;
    private final String pathAfterPrefixes;
    private String operationOrBlobIdWithoutLeadingSlash = null;
    private static char PATH_SEPARATOR_CHAR = (char)47;
    private static String PATH_SEPARATOR_STRING = String.valueOf(PATH_SEPARATOR_CHAR);
    private static String SEGMENT = RestUtils.SubResource.Segment.toString();

    public static RequestPath parse(RestRequest restRequest, List<String> prefixesToRemove, String clusterName) throws RestServiceException {
        String blobIdHeader = RestUtils.getHeader(restRequest.getArgs(), "x-ambry-blob-id", false);
        if (blobIdHeader != null) {
            String blobIdStr = RequestPath.parse(blobIdHeader, Collections.emptyMap(), prefixesToRemove, clusterName).getOperationOrBlobId(false);
            restRequest.setArg("x-ambry-blob-id", blobIdStr);
        }
        return RequestPath.parse(restRequest.getPath(), restRequest.getArgs(), prefixesToRemove, clusterName);
    }

    public static RequestPath parse(String path, Map<String, Object> args, List<String> prefixesToRemove, String clusterName) throws RestServiceException {
        String operationOrBlobId;
        int blobSegmentIdx;
        int lastSlashOffset;
        RestUtils.SubResource subResource;
        String pathAfterPrefixes;
        String clusterNameFound;
        String prefixFound;
        int offset;
        block9: {
            int nextPathSegmentOffset;
            offset = 0;
            prefixFound = "";
            if (prefixesToRemove != null) {
                for (String prefix : prefixesToRemove) {
                    int nextPathSegmentOffset2 = RequestPath.matchPathSegments(path, offset, prefix, false);
                    if (nextPathSegmentOffset2 < 0) continue;
                    prefixFound = prefix;
                    offset = nextPathSegmentOffset2;
                    break;
                }
            }
            clusterNameFound = "";
            if (clusterName != null && (nextPathSegmentOffset = RequestPath.matchPathSegments(path, offset, clusterName, true)) >= 0) {
                clusterNameFound = clusterName;
                offset = nextPathSegmentOffset;
            }
            pathAfterPrefixes = path.substring(offset);
            subResource = null;
            lastSlashOffset = path.lastIndexOf(PATH_SEPARATOR_CHAR);
            blobSegmentIdx = GetBlobOptions.NO_BLOB_SEGMENT_IDX_SPECIFIED;
            boolean isSegment = false;
            if (lastSlashOffset > offset) {
                try {
                    String[] fields = path.split(PATH_SEPARATOR_STRING);
                    if (SEGMENT.equals(fields[fields.length - 2])) {
                        isSegment = true;
                        subResource = RestUtils.SubResource.Segment;
                        blobSegmentIdx = Integer.valueOf(fields[fields.length - 1]);
                        lastSlashOffset = path.lastIndexOf(PATH_SEPARATOR_CHAR, lastSlashOffset - 1);
                    } else {
                        subResource = RestUtils.SubResource.valueOf(path.substring(lastSlashOffset + 1));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!isSegment) break block9;
                    throw new RestServiceException("Segment index given is not an integer", RestServiceErrorCode.BadRequest);
                }
            }
        }
        if (((operationOrBlobId = path.substring(offset, subResource == null ? path.length() : lastSlashOffset)).isEmpty() || operationOrBlobId.equals(PATH_SEPARATOR_STRING)) && args.containsKey("x-ambry-blob-id")) {
            operationOrBlobId = args.get("x-ambry-blob-id").toString();
        }
        return new RequestPath(prefixFound, clusterNameFound, pathAfterPrefixes, operationOrBlobId, subResource, blobSegmentIdx);
    }

    RequestPath(String prefix, String clusterName, String pathAfterPrefixes, String operationOrBlobId, RestUtils.SubResource subResource, int blobSegmentIdx) {
        this.prefix = prefix;
        this.clusterName = clusterName;
        this.pathAfterPrefixes = pathAfterPrefixes;
        this.operationOrBlobId = operationOrBlobId;
        this.subResource = subResource;
        this.blobSegmentIdx = blobSegmentIdx;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPathAfterPrefixes() {
        return this.pathAfterPrefixes;
    }

    public String getOperationOrBlobId(boolean stripLeadingSlash) {
        if (stripLeadingSlash) {
            if (this.operationOrBlobIdWithoutLeadingSlash == null) {
                this.operationOrBlobIdWithoutLeadingSlash = this.operationOrBlobId.startsWith(PATH_SEPARATOR_STRING) ? this.operationOrBlobId.substring(1) : this.operationOrBlobId;
            }
            return this.operationOrBlobIdWithoutLeadingSlash;
        }
        return this.operationOrBlobId;
    }

    public RestUtils.SubResource getSubResource() {
        return this.subResource;
    }

    public int getBlobSegmentIdx() {
        return this.blobSegmentIdx;
    }

    public boolean matchesOperation(String operation) {
        return RequestPath.matchPathSegments(this.operationOrBlobId, 0, operation, true) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPath that = (RequestPath)o;
        return this.prefix.equals(that.prefix) && this.clusterName.equals(that.clusterName) && this.operationOrBlobId.equals(that.operationOrBlobId) && this.subResource == that.subResource && this.blobSegmentIdx == that.blobSegmentIdx;
    }

    public String toString() {
        return "RequestPath{prefix='" + this.prefix + '\'' + ", clusterName='" + this.clusterName + '\'' + ", operationOrBlobId='" + this.operationOrBlobId + '\'' + ", subResource=" + (Object)((Object)this.subResource) + ", blobSegmentIdx=" + this.blobSegmentIdx + '}';
    }

    private static int matchPathSegments(String path, int pathOffset, String pathSegments, boolean ignoreCase) {
        int nextCharOffset;
        pathOffset += path.startsWith("/", pathOffset) ? 1 : 0;
        int pathSegmentsStartOffset = pathSegments.startsWith(PATH_SEPARATOR_STRING) ? 1 : 0;
        int pathSegmentsLength = Math.max(pathSegments.length() - pathSegmentsStartOffset - (pathSegments.endsWith(PATH_SEPARATOR_STRING) ? 1 : 0), 0);
        int nextPathSegmentOffset = -1;
        if (path.regionMatches(ignoreCase, pathOffset, pathSegments, pathSegmentsStartOffset, pathSegmentsLength) && ((nextCharOffset = pathOffset + pathSegmentsLength) == path.length() || path.charAt(nextCharOffset) == PATH_SEPARATOR_CHAR)) {
            nextPathSegmentOffset = nextCharOffset;
        }
        return nextPathSegmentOffset;
    }
}

