/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.network;

import com.github.ambry.network.Send;
import com.github.ambry.network.ServerNetworkResponseMetrics;
import com.github.ambry.utils.Time;

public class NetworkSend {
    private final String connectionId;
    private final Send payload;
    private final long sendCreateTimeInMs;
    private long sendStartTimeInMs = -1L;
    private final Time time;
    private final ServerNetworkResponseMetrics metrics;

    public NetworkSend(String connectionId, Send payload, ServerNetworkResponseMetrics metrics, Time time) {
        this.connectionId = connectionId;
        this.payload = payload;
        this.sendCreateTimeInMs = time.milliseconds();
        this.time = time;
        this.metrics = metrics;
    }

    public long getSendCreateTimeInMs() {
        return this.sendCreateTimeInMs;
    }

    public boolean maySetSendStartTimeInMs() {
        if (this.sendStartTimeInMs == -1L) {
            this.sendStartTimeInMs = this.time.milliseconds();
            return true;
        }
        return false;
    }

    public long getSendStartTimeInMs() {
        return this.sendStartTimeInMs;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Send getPayload() {
        return this.payload;
    }

    public void updateServerResponseMetrics() {
        if (this.metrics != null) {
            this.metrics.updateSendTime(this.time.milliseconds() - this.sendStartTimeInMs);
        }
    }
}

