/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.network;

import com.github.ambry.network.Send;
import com.github.ambry.utils.ByteBufferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class BoundedByteBufferSend
implements Send {
    private final ByteBuffer buffer;

    public BoundedByteBufferSend(Send request) throws IOException {
        if (request.sizeInBytes() > 0x7FFFFFFBL) {
            throw new IllegalStateException("Maximum allowable size for a bounded buffer is 2147483643.");
        }
        int size = (int)request.sizeInBytes();
        this.buffer = ByteBuffer.allocate(size + 4);
        this.buffer.putInt(size);
        WritableByteChannel channel = Channels.newChannel((OutputStream)new ByteBufferOutputStream(this.buffer));
        request.writeTo(channel);
        this.buffer.rewind();
    }

    public BoundedByteBufferSend(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Input buffer cannot be null for BoundedByteBufferSend");
        }
        this.buffer = buffer;
    }

    @Override
    public long writeTo(WritableByteChannel channel) throws IOException {
        return this.isSendComplete() ? 0L : (long)channel.write(this.buffer);
    }

    @Override
    public boolean isSendComplete() {
        return this.buffer.remaining() == 0;
    }

    @Override
    public long sizeInBytes() {
        return this.buffer.limit();
    }

    public BoundedByteBufferSend duplicate() {
        return new BoundedByteBufferSend(this.buffer.duplicate());
    }
}

