/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class RestServerConfig {
    @Config(value={"rest.server.rest.request.service.factory"})
    public final String restServerRestRequestServiceFactory;
    @Config(value={"rest.server.nio.server.factory"})
    @Default(value="com.github.ambry.rest.FrontendNettyFactory")
    public final String restServerNioServerFactory;
    @Config(value={"rest.server.request.handler.scaling.unit.count"})
    @Default(value="5")
    public final int restServerRequestHandlerScalingUnitCount;
    @Config(value={"rest.server.request.response.handler.factory"})
    @Default(value="com.github.ambry.rest.AsyncRequestResponseHandlerFactory")
    public final String restServerRequestResponseHandlerFactory;
    @Config(value={"rest.server.response.handler.scaling.unit.count"})
    @Default(value="5")
    public final int restServerResponseHandlerScalingUnitCount;
    @Config(value={"rest.server.account.service.factory"})
    @Default(value="com.github.ambry.account.InMemoryUnknownAccountServiceFactory")
    public final String restServerAccountServiceFactory;
    @Config(value={"rest.server.router.factory"})
    @Default(value="com.github.ambry.router.NonBlockingRouterFactory")
    public final String restServerRouterFactory;
    @Config(value={"rest.server.public.access.log.request.headers"})
    @Default(value="Host,Referer,User-Agent,Content-Length,x-ambry-content-type,x-ambry-owner-id,x-ambry-ttl,x-ambry-private,x-ambry-service-id,X-Forwarded-For")
    public final String restServerPublicAccessLogRequestHeaders;
    @Config(value={"rest.server.public.access.log.response.headers"})
    @Default(value="Location,x-ambry-blob-size")
    public final String restServerPublicAccessLogResponseHeaders;
    @Config(value={"rest.server.health.check.uri"})
    @Default(value="/healthCheck")
    public final String restServerHealthCheckUri;

    public RestServerConfig(VerifiableProperties verifiableProperties) {
        this.restServerRestRequestServiceFactory = verifiableProperties.getString("rest.server.rest.request.service.factory");
        this.restServerNioServerFactory = verifiableProperties.getString("rest.server.nio.server.factory", "com.github.ambry.rest.FrontendNettyFactory");
        this.restServerRequestHandlerScalingUnitCount = verifiableProperties.getIntInRange("rest.server.request.handler.scaling.unit.count", 5, 0, Integer.MAX_VALUE);
        this.restServerRequestResponseHandlerFactory = verifiableProperties.getString("rest.server.request.response.handler.factory", "com.github.ambry.rest.AsyncRequestResponseHandlerFactory");
        this.restServerResponseHandlerScalingUnitCount = verifiableProperties.getIntInRange("rest.server.response.handler.scaling.unit.count", 5, 0, Integer.MAX_VALUE);
        this.restServerAccountServiceFactory = verifiableProperties.getString("rest.server.account.service.factory", "com.github.ambry.account.InMemoryUnknownAccountServiceFactory");
        this.restServerRouterFactory = verifiableProperties.getString("rest.server.router.factory", "com.github.ambry.router.NonBlockingRouterFactory");
        this.restServerPublicAccessLogRequestHeaders = verifiableProperties.getString("rest.server.public.access.log.request.headers", "Host,Referer,User-Agent,Content-Length,x-ambry-content-type,x-ambry-owner-id,x-ambry-ttl,x-ambry-private,x-ambry-service-id,X-Forwarded-For");
        this.restServerPublicAccessLogResponseHeaders = verifiableProperties.getString("rest.server.public.access.log.response.headers", "Location,x-ambry-blob-size");
        this.restServerHealthCheckUri = verifiableProperties.getString("rest.server.health.check.uri", "/healthCheck");
    }
}

