/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.utils.Utils;
import java.util.HashSet;
import java.util.Set;

public class ReplicationConfig {
    public static final String REPLICATION_CLOUD_TOKEN_FACTORY = "replication.cloud.token.factory";
    @Config(value={"replication.token.factory"})
    @Default(value="com.github.ambry.store.StoreFindTokenFactory")
    public final String replicationStoreTokenFactory;
    @Config(value={"replication.cloud.token.factory"})
    @Default(value="com.github.ambry.cloud.azure.CosmosUpdateTimeFindTokenFactory")
    public final String replicationCloudTokenFactory;
    @Config(value={"replication.no.of.intra.dc.replica.threads"})
    @Default(value="1")
    public final int replicationNumOfIntraDCReplicaThreads;
    @Config(value={"replication.no.of.inter.dc.replica.threads"})
    @Default(value="1")
    public final int replicationNumOfInterDCReplicaThreads;
    @Config(value={"replication.connection.pool.checkout.timeout.ms"})
    @Default(value="5000")
    public final int replicationConnectionPoolCheckoutTimeoutMs;
    @Config(value={"replication.token.flush.interval.seconds"})
    @Default(value="300")
    public final int replicationTokenFlushIntervalSeconds;
    @Config(value={"replication.token.flush.delay.seconds"})
    @Default(value="5")
    public final int replicationTokenFlushDelaySeconds;
    @Config(value={"replication.intra.replica.thread.throttle.sleep.duration.ms"})
    @Default(value="0")
    public final long replicationIntraReplicaThreadThrottleSleepDurationMs;
    @Config(value={"replication.inter.replica.thread.throttle.sleep.duration.ms"})
    @Default(value="0")
    public final long replicationInterReplicaThreadThrottleSleepDurationMs;
    @Config(value={"replication.replica.thread.idle.sleep.duration.ms"})
    @Default(value="0")
    public final long replicationReplicaThreadIdleSleepDurationMs;
    @Config(value={"replication.synced.replica.backoff.duration.ms"})
    @Default(value="0")
    public final long replicationSyncedReplicaBackoffDurationMs;
    @Config(value={"replication.fetch.size.in.bytes"})
    @Default(value="1048576")
    public final long replicationFetchSizeInBytes;
    @Config(value={"replication.include.all"})
    @Default(value="true")
    public final boolean replicationIncludeAll;
    @Config(value={"replication.persist.token.on.shutdown.or.replica.remove"})
    @Default(value="true")
    public final boolean replicationPersistTokenOnShutdownOrReplicaRemove;
    @Config(value={"replication.track.per.partition.lag.from.remote"})
    @Default(value="false")
    public final boolean replicationTrackPerPartitionLagFromRemote;
    @Config(value={"replication.metadata.request.version"})
    @Default(value="1")
    public final short replicaMetadataRequestVersion;
    @Config(value={"replication.enabled.with.vcr.cluster"})
    @Default(value="false")
    public final boolean replicationEnabledWithVcrCluster;
    @Config(value={"replication.vcr.recovery.partitions"})
    @Default(value="")
    public final Set<String> replicationVcrRecoveryPartitions;

    public ReplicationConfig(VerifiableProperties verifiableProperties) {
        this.replicationStoreTokenFactory = verifiableProperties.getString("replication.token.factory", "com.github.ambry.store.StoreFindTokenFactory");
        this.replicationCloudTokenFactory = verifiableProperties.getString(REPLICATION_CLOUD_TOKEN_FACTORY, "com.github.ambry.cloud.azure.CosmosChangeFeedFindTokenFactory");
        this.replicationNumOfIntraDCReplicaThreads = verifiableProperties.getInt("replication.no.of.intra.dc.replica.threads", 1);
        this.replicationNumOfInterDCReplicaThreads = verifiableProperties.getInt("replication.no.of.inter.dc.replica.threads", 1);
        this.replicationConnectionPoolCheckoutTimeoutMs = verifiableProperties.getIntInRange("replication.connection.pool.checkout.timeout.ms", 5000, 1000, 10000);
        this.replicationTokenFlushIntervalSeconds = verifiableProperties.getIntInRange("replication.token.flush.interval.seconds", 300, 5, Integer.MAX_VALUE);
        this.replicationTokenFlushDelaySeconds = verifiableProperties.getIntInRange("replication.token.flush.delay.seconds", 5, 1, Integer.MAX_VALUE);
        this.replicationIntraReplicaThreadThrottleSleepDurationMs = verifiableProperties.getLongInRange("replication.intra.replica.thread.throttle.sleep.duration.ms", 0L, 0L, Long.MAX_VALUE);
        this.replicationInterReplicaThreadThrottleSleepDurationMs = verifiableProperties.getLongInRange("replication.inter.replica.thread.throttle.sleep.duration.ms", 0L, 0L, Long.MAX_VALUE);
        this.replicationReplicaThreadIdleSleepDurationMs = verifiableProperties.getLongInRange("replication.replica.thread.idle.sleep.duration.ms", 0L, 0L, Long.MAX_VALUE);
        this.replicationSyncedReplicaBackoffDurationMs = verifiableProperties.getLongInRange("replication.synced.replica.backoff.duration.ms", 0L, 0L, Long.MAX_VALUE);
        this.replicationFetchSizeInBytes = verifiableProperties.getLongInRange("replication.fetch.size.in.bytes", 0x100000L, 1L, Long.MAX_VALUE);
        this.replicationIncludeAll = verifiableProperties.getBoolean("replication.include.all", true);
        this.replicationPersistTokenOnShutdownOrReplicaRemove = verifiableProperties.getBoolean("replication.persist.token.on.shutdown.or.replica.remove", true);
        this.replicationTrackPerPartitionLagFromRemote = verifiableProperties.getBoolean("replication.track.per.partition.lag.from.remote", false);
        this.replicaMetadataRequestVersion = verifiableProperties.getShortInRange("replication.metadata.request.version", (short)1, (short)1, (short)2);
        this.replicationEnabledWithVcrCluster = verifiableProperties.getBoolean("replication.enabled.with.vcr.cluster", false);
        String vcrRecoveryPartitions = verifiableProperties.getString("replication.vcr.recovery.partitions", "");
        this.replicationVcrRecoveryPartitions = (Set)Utils.splitString((String)vcrRecoveryPartitions, (String)",", HashSet::new);
    }
}

