/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.commons.Criteria;
import com.github.ambry.commons.PerformanceIndex;
import com.github.ambry.commons.Thresholds;
import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.rest.RestMethod;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import org.json.JSONObject;

public class PerformanceConfig {
    public static final String NON_SUCCESS_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR = "performance.non.success.rest.request.total.time.threshold";
    public static final String SUCCESS_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR = "performance.success.rest.request.total.time.threshold";
    private static final String DEFAULT_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR = "{\"PUT\": 9223372036854775807,\"GET\": 9223372036854775807,\"POST\": 9223372036854775807,\"HEAD\": 9223372036854775807,\"DELETE\": 9223372036854775807}";
    @Config(value={"performance.non.success.rest.request.total.time.threshold"})
    @Default(value="{\"PUT\": 9223372036854775807,\"GET\": 9223372036854775807,\"POST\": 9223372036854775807,\"HEAD\": 9223372036854775807,\"DELETE\": 9223372036854775807}")
    private final String nonSuccessRestRequestTotalTimeThresholds;
    @Config(value={"performance.success.rest.request.total.time.threshold"})
    @Default(value="{\"PUT\": 9223372036854775807,\"GET\": 9223372036854775807,\"POST\": 9223372036854775807,\"HEAD\": 9223372036854775807,\"DELETE\": 9223372036854775807}")
    private final String successRestRequestTotalTimeThresholds;
    @Config(value={"performance.success.get.time.to.first.byte.threshold"})
    @Default(value="Long.MAX_VALUE")
    public final long successGetTimeToFirstByteThreshold;
    @Config(value={"performance.success.get.average.bandwidth.threshold"})
    @Default(value="0")
    public final long successGetAverageBandwidthThreshold;
    @Config(value={"performance.success.post.average.bandwidth.threshold"})
    @Default(value="0")
    public final long successPostAverageBandwidthThreshold;
    public final EnumMap<RestMethod, Thresholds> successRequestThresholds = new EnumMap(RestMethod.class);
    public final EnumMap<RestMethod, Thresholds> nonSuccessRequestThresholds = new EnumMap(RestMethod.class);

    public PerformanceConfig(VerifiableProperties verifiableProperties) {
        this.successGetTimeToFirstByteThreshold = verifiableProperties.getLong("performance.success.get.time.to.first.byte.threshold", Long.MAX_VALUE);
        this.successGetAverageBandwidthThreshold = verifiableProperties.getLong("performance.success.get.average.bandwidth.threshold", 0L);
        this.successPostAverageBandwidthThreshold = verifiableProperties.getLong("performance.success.post.average.bandwidth.threshold", 0L);
        this.nonSuccessRestRequestTotalTimeThresholds = verifiableProperties.getString(NON_SUCCESS_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR, DEFAULT_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR);
        this.successRestRequestTotalTimeThresholds = verifiableProperties.getString(SUCCESS_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR, DEFAULT_REST_REQUEST_TOTAL_TIME_THRESHOLD_STR);
        JSONObject successThresholdObject = new JSONObject(this.successRestRequestTotalTimeThresholds);
        JSONObject nonSuccessThresholdObject = new JSONObject(this.nonSuccessRestRequestTotalTimeThresholds);
        for (RestMethod method : EnumSet.of(RestMethod.GET, RestMethod.POST, RestMethod.DELETE, RestMethod.HEAD, RestMethod.PUT)) {
            HashMap<PerformanceIndex, Criteria> successPerfIndexMap = new HashMap<PerformanceIndex, Criteria>();
            HashMap<PerformanceIndex, Criteria> nonSuccessPerfIndexMap = new HashMap<PerformanceIndex, Criteria>();
            if (method == RestMethod.GET) {
                successPerfIndexMap.put(PerformanceIndex.AverageBandwidth, new Criteria(this.successGetAverageBandwidthThreshold, Criteria.BoundType.LowerBound));
                successPerfIndexMap.put(PerformanceIndex.TimeToFirstByte, new Criteria(this.successGetTimeToFirstByteThreshold, Criteria.BoundType.UpperBound));
            } else if (method == RestMethod.POST) {
                successPerfIndexMap.put(PerformanceIndex.AverageBandwidth, new Criteria(this.successPostAverageBandwidthThreshold, Criteria.BoundType.LowerBound));
            } else {
                successPerfIndexMap.put(PerformanceIndex.RoundTripTime, new Criteria(successThresholdObject.optLong(method.name(), Long.MAX_VALUE), Criteria.BoundType.UpperBound));
            }
            nonSuccessPerfIndexMap.put(PerformanceIndex.RoundTripTime, new Criteria(nonSuccessThresholdObject.optLong(method.name(), Long.MAX_VALUE), Criteria.BoundType.UpperBound));
            this.successRequestThresholds.put(method, new Thresholds(successPerfIndexMap));
            this.nonSuccessRequestThresholds.put(method, new Thresholds(nonSuccessPerfIndexMap));
        }
    }
}

