/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class NetworkConfig {
    public static final String NUM_IO_THREADS = "num.io.threads";
    public static final String QUEUED_MAX_REQUESTS = "queued.max.requests";
    public static final String PORT = "port";
    public static final String HOST_NAME = "host.name";
    public static final String SOCKET_SEND_BUFFER_BYTES = "socket.send.buffer.bytes";
    public static final String SOCKET_RECEIVE_BUFFER_BYTES = "socket.receive.buffer.bytes";
    public static final String SOCKET_REQUEST_MAX_BYTES = "socket.request.max.bytes";
    public static final String NETWORK_CLIENT_ENABLE_CONNECTION_REPLENISHMENT = "network.client.enable.connection.replenishment";
    public static final String NETWORK_CLIENT_MAX_REPLENISHMENT_PER_HOST_PER_SECOND = "network.client.max.replenishment.per.host.per.second";
    public static final String SELECTOR_EXECUTOR_POOL_SIZE = "selector.executor.pool.size";
    public static final String SELECTOR_MAX_KEY_TO_PROCESS = "selector.max.key.to.process";
    public static final String SELECTOR_USE_DIRECT_BUFFERS = "selector.use.direct.buffers";
    @Config(value={"num.io.threads"})
    @Default(value="8")
    public final int numIoThreads;
    @Config(value={"queued.max.requests"})
    @Default(value="500")
    public final int queuedMaxRequests;
    @Config(value={"port"})
    @Default(value="6667")
    public final int port;
    @Config(value={"host.name"})
    @Default(value="localhost")
    public final String hostName;
    @Config(value={"socket.send.buffer.bytes"})
    @Default(value="1048576")
    public final int socketSendBufferBytes;
    @Config(value={"socket.receive.buffer.bytes"})
    @Default(value="1048576")
    public final int socketReceiveBufferBytes;
    @Config(value={"socket.request.max.bytes"})
    @Default(value="104857600")
    public final int socketRequestMaxBytes;
    @Config(value={"network.client.enable.connection.replenishment"})
    @Default(value="false")
    public final boolean networkClientEnableConnectionReplenishment;
    @Config(value={"network.client.max.replenishment.per.host.per.second"})
    @Default(value="1")
    public final int networkClientMaxReplenishmentPerHostPerSecond;
    @Config(value={"selector.executor.pool.size"})
    @Default(value="4")
    public final int selectorExecutorPoolSize;
    @Config(value={"selector.max.key.to.process"})
    @Default(value="-1")
    public final int selectorMaxKeyToProcess;
    @Config(value={"selector.use.direct.buffers"})
    @Default(value="false")
    public final boolean selectorUseDirectBuffers;

    public NetworkConfig(VerifiableProperties verifiableProperties) {
        this.numIoThreads = verifiableProperties.getIntInRange(NUM_IO_THREADS, 8, 1, Integer.MAX_VALUE);
        this.queuedMaxRequests = verifiableProperties.getIntInRange(QUEUED_MAX_REQUESTS, 500, 1, Integer.MAX_VALUE);
        this.port = verifiableProperties.getInt(PORT, 6667);
        this.hostName = verifiableProperties.getString(HOST_NAME, "localhost");
        this.socketSendBufferBytes = verifiableProperties.getInt(SOCKET_SEND_BUFFER_BYTES, 0x100000);
        this.socketReceiveBufferBytes = verifiableProperties.getInt(SOCKET_RECEIVE_BUFFER_BYTES, 0x100000);
        this.socketRequestMaxBytes = verifiableProperties.getIntInRange(SOCKET_REQUEST_MAX_BYTES, 0x6400000, 1, Integer.MAX_VALUE);
        this.networkClientEnableConnectionReplenishment = verifiableProperties.getBoolean(NETWORK_CLIENT_ENABLE_CONNECTION_REPLENISHMENT, false);
        this.networkClientMaxReplenishmentPerHostPerSecond = verifiableProperties.getIntInRange(NETWORK_CLIENT_MAX_REPLENISHMENT_PER_HOST_PER_SECOND, 1, 1, Integer.MAX_VALUE);
        this.selectorExecutorPoolSize = verifiableProperties.getIntInRange(SELECTOR_EXECUTOR_POOL_SIZE, 4, 0, Integer.MAX_VALUE);
        this.selectorMaxKeyToProcess = verifiableProperties.getIntInRange(SELECTOR_MAX_KEY_TO_PROCESS, -1, -1, Integer.MAX_VALUE);
        this.selectorUseDirectBuffers = verifiableProperties.getBoolean(SELECTOR_USE_DIRECT_BUFFERS, false);
    }
}

