/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NettyConfig {
    public static final String NETTY_SERVER_BOSS_THREAD_COUNT = "netty.server.boss.thread.count";
    public static final String NETTY_SERVER_IDLE_TIME_SECONDS = "netty.server.idle.time.seconds";
    public static final String NETTY_SERVER_PORT = "netty.server.port";
    public static final String NETTY_SERVER_SSL_PORT = "netty.server.ssl.port";
    public static final String NETTY_SERVER_ENABLE_SSL = "netty.server.enable.ssl";
    public static final String NETTY_SERVER_SO_BACKLOG = "netty.server.so.backlog";
    public static final String NETTY_SERVER_WORKER_THREAD_COUNT = "netty.server.worker.thread.count";
    public static final String NETTY_SERVER_MAX_INITIAL_LINE_LENGTH = "netty.server.max.initial.line.length";
    public static final String NETTY_SERVER_MAX_HEADER_SIZE = "netty.server.max.header.size";
    public static final String NETTY_SERVER_MAX_CHUNK_SIZE = "netty.server.max.chunk.size";
    public static final String NETTY_SERVER_REQUEST_BUFFER_WATERMARK = "netty.server.request.buffer.watermark";
    public static final String NETTY_SERVER_BLACKLISTED_QUERY_PARAMS = "netty.server.blacklisted.query.params";
    public static final String NETTY_MULTIPART_POST_MAX_SIZE_BYTES = "netty.multipart.post.max.size.bytes";
    public static final String SSL_FACTORY_KEY = "netty.server.ssl.factory";
    public static final String NETTY_METRICS_REFRESH_INTERVAL_SECONDS = "netty.metrics.refresh.interval.seconds";
    public static final String NETTY_METRICS_STOP_WAIT_TIMEOUT_SECONDS = "netty.metrics.stop.wait.timeout.seconds";
    @Config(value={"netty.server.boss.thread.count"})
    @Default(value="1")
    public final int nettyServerBossThreadCount;
    @Config(value={"netty.server.idle.time.seconds"})
    @Default(value="60")
    public final int nettyServerIdleTimeSeconds;
    @Config(value={"netty.server.port"})
    @Default(value="1174")
    public final int nettyServerPort;
    @Config(value={"netty.server.ssl.port"})
    @Default(value="1175")
    public final int nettyServerSSLPort;
    @Config(value={"netty.server.enable.ssl"})
    @Default(value="false")
    public final boolean nettyServerEnableSSL;
    @Config(value={"netty.server.so.backlog"})
    @Default(value="100")
    public final int nettyServerSoBacklog;
    @Config(value={"netty.server.worker.thread.count"})
    @Default(value="1")
    public final int nettyServerWorkerThreadCount;
    @Config(value={"netty.server.max.initial.line.length"})
    @Default(value="4096")
    public final int nettyServerMaxInitialLineLength;
    @Config(value={"netty.server.max.header.size"})
    @Default(value="8192")
    public final int nettyServerMaxHeaderSize;
    @Config(value={"netty.server.max.chunk.size"})
    @Default(value="8192")
    public final int nettyServerMaxChunkSize;
    @Config(value={"netty.server.request.buffer.watermark"})
    @Default(value="32 * 1024 * 1024")
    public final int nettyServerRequestBufferWatermark;
    @Config(value={"netty.server.blacklisted.query.params"})
    @Default(value="")
    public final Set<String> nettyBlacklistedQueryParams;
    @Config(value={"netty.multipart.post.max.size.bytes"})
    @Default(value="20 * 1024 * 1024")
    public final long nettyMultipartPostMaxSizeBytes;
    @Config(value={"netty.server.ssl.factory"})
    @Default(value="")
    public final String nettyServerSslFactory;
    @Config(value={"netty.metrics.refresh.interval.seconds"})
    @Default(value="30")
    public final int nettyMetricsRefreshIntervalSeconds;
    @Config(value={"netty.metrics.stop.wait.timeout.seconds"})
    @Default(value="1")
    public final int nettyMetricsStopWaitTimeoutSeconds;

    public NettyConfig(VerifiableProperties verifiableProperties) {
        this.nettyServerBossThreadCount = verifiableProperties.getInt(NETTY_SERVER_BOSS_THREAD_COUNT, 1);
        this.nettyServerIdleTimeSeconds = verifiableProperties.getInt(NETTY_SERVER_IDLE_TIME_SECONDS, 60);
        this.nettyServerPort = verifiableProperties.getInt(NETTY_SERVER_PORT, 1174);
        this.nettyServerSSLPort = verifiableProperties.getInt(NETTY_SERVER_SSL_PORT, 1175);
        this.nettyServerEnableSSL = verifiableProperties.getBoolean(NETTY_SERVER_ENABLE_SSL, false);
        this.nettyServerSoBacklog = verifiableProperties.getInt(NETTY_SERVER_SO_BACKLOG, 100);
        this.nettyServerWorkerThreadCount = verifiableProperties.getInt(NETTY_SERVER_WORKER_THREAD_COUNT, 1);
        this.nettyServerMaxInitialLineLength = verifiableProperties.getInt(NETTY_SERVER_MAX_INITIAL_LINE_LENGTH, 4096);
        this.nettyServerMaxHeaderSize = verifiableProperties.getInt(NETTY_SERVER_MAX_HEADER_SIZE, 8192);
        this.nettyServerMaxChunkSize = verifiableProperties.getInt(NETTY_SERVER_MAX_CHUNK_SIZE, 8192);
        this.nettyServerRequestBufferWatermark = verifiableProperties.getIntInRange(NETTY_SERVER_REQUEST_BUFFER_WATERMARK, 0x2000000, 1, Integer.MAX_VALUE);
        this.nettyBlacklistedQueryParams = new HashSet<String>(Arrays.asList(verifiableProperties.getString(NETTY_SERVER_BLACKLISTED_QUERY_PARAMS, "").split(",")));
        this.nettyMultipartPostMaxSizeBytes = verifiableProperties.getLongInRange(NETTY_MULTIPART_POST_MAX_SIZE_BYTES, 0x1400000L, 0L, Long.MAX_VALUE);
        this.nettyServerSslFactory = verifiableProperties.getString(SSL_FACTORY_KEY, "");
        this.nettyMetricsRefreshIntervalSeconds = verifiableProperties.getIntInRange(NETTY_METRICS_REFRESH_INTERVAL_SECONDS, 30, 0, Integer.MAX_VALUE);
        this.nettyMetricsStopWaitTimeoutSeconds = verifiableProperties.getIntInRange(NETTY_METRICS_STOP_WAIT_TIMEOUT_SECONDS, 1, 0, Integer.MAX_VALUE);
    }
}

