/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class JsonAccountConfig {
    public static final String JSON_ACCOUNT_PREFIX = "json.account.";
    public static final String UPDATER_POLLING_INTERVAL_MS = "json.account.updater.polling.interval.ms";
    public static final String FILE_PATH = "json.account.file.path";
    public static final String FILE_PATH_DEFAULT = "/tmp/accounts.json";
    @Config(value={"json.account.file.path"})
    @Default(value="/tmp/accounts.json")
    public final String jsonAccountFilePath;
    @Config(value={"json.account.updater.polling.interval.ms"})
    @Default(value="60 * 1000")
    public final int updaterPollingIntervalMs;

    public JsonAccountConfig(VerifiableProperties verifiableProperties) {
        this.jsonAccountFilePath = verifiableProperties.getString(FILE_PATH, FILE_PATH_DEFAULT);
        this.updaterPollingIntervalMs = verifiableProperties.getIntInRange(UPDATER_POLLING_INTERVAL_MS, 60000, 0, Integer.MAX_VALUE);
    }
}

