/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class Http2ClientConfig {
    public static final String HTTP2_MIN_CONNECTION_PER_PORT = "http2.min.connection.per.port";
    public static final String HTTP2_MAX_CONCURRENT_STREAMS_PER_CONNECTION = "http2.max.concurrent.streams.per.connection";
    public static final String HTTP2_NETTY_EVENT_LOOP_GROUP_THREADS = "http2.netty.event.loop.group.threads";
    public static final String HTTP2_IDLE_CONNECTION_TIMEOUT_MS = "http2.idle.connection.timeout.ms";
    @Config(value={"http2.idle.connection.timeout.ms"})
    @Default(value="-1")
    public final Long idleConnectionTimeoutMs;
    @Config(value={"http2.min.connection.per.port"})
    @Default(value="4")
    public final int http2MinConnectionPerPort;
    @Config(value={"http2.max.concurrent.streams.per.connection"})
    @Default(value="Integer.MAX_VALUE")
    public final int http2MaxConcurrentStreamsPerConnection;
    @Config(value={"http2.netty.event.loop.group.threads"})
    @Default(value="0")
    public final int http2NettyEventLoopGroupThreads;

    public Http2ClientConfig(VerifiableProperties verifiableProperties) {
        this.idleConnectionTimeoutMs = verifiableProperties.getLong(HTTP2_IDLE_CONNECTION_TIMEOUT_MS, -1L);
        this.http2MinConnectionPerPort = verifiableProperties.getInt(HTTP2_MIN_CONNECTION_PER_PORT, 4);
        this.http2MaxConcurrentStreamsPerConnection = verifiableProperties.getIntInRange(HTTP2_MAX_CONCURRENT_STREAMS_PER_CONNECTION, Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.http2NettyEventLoopGroupThreads = verifiableProperties.getInt(HTTP2_NETTY_EVENT_LOOP_GROUP_THREADS, 0);
    }
}

