/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class HelixPropertyStoreConfig {
    public static final String HELIX_PROPERTY_STORE_PREFIX = "helix.property.store.";
    public static final String HELIX_ZK_CLIENT_CONNECTION_TIMEOUT_MS = "helix.property.store.zk.client.connection.timeout.ms";
    public static final String HELIX_ZK_CLIENT_SESSION_TIMEOUT_MS = "helix.property.store.zk.client.session.timeout.ms";
    public static final String HELIX_ROOT_PATH = "helix.property.store.root.path";
    @Config(value={"helix.property.store.zk.client.connection.timeout.ms"})
    @Default(value="20 * 1000")
    public final int zkClientConnectionTimeoutMs;
    @Config(value={"helix.property.store.zk.client.session.timeout.ms"})
    @Default(value="20 * 1000")
    public final int zkClientSessionTimeoutMs;
    @Config(value={"helix.property.store.root.path"})
    @Default(value="/ambry/defaultCluster/helixPropertyStore")
    public final String rootPath;

    public HelixPropertyStoreConfig(VerifiableProperties verifiableProperties) {
        this.zkClientConnectionTimeoutMs = verifiableProperties.getIntInRange(HELIX_ZK_CLIENT_CONNECTION_TIMEOUT_MS, 20000, 1, Integer.MAX_VALUE);
        this.zkClientSessionTimeoutMs = verifiableProperties.getIntInRange(HELIX_ZK_CLIENT_SESSION_TIMEOUT_MS, 20000, 1, Integer.MAX_VALUE);
        this.rootPath = verifiableProperties.getString(HELIX_ROOT_PATH, "/ambry/defaultCluster/helixPropertyStore");
    }
}

