/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.protocol.GetOption;
import com.github.ambry.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FrontendConfig {
    private static final String PREFIX = "frontend.";
    public static final String URL_SIGNER_ENDPOINTS = "frontend.url.signer.endpoints";
    public static final String CHUNK_UPLOAD_INITIAL_CHUNK_TTL_SECS_KEY = "frontend.chunk.upload.initial.chunk.ttl.secs";
    public static final String FAIL_IF_TTL_REQUIRED_BUT_NOT_PROVIDED_KEY = "frontend.fail.if.ttl.required.but.not.provided";
    public static final String MAX_ACCEPTABLE_TTL_SECS_IF_TTL_REQUIRED_KEY = "frontend.max.acceptable.ttl.secs.if.ttl.required";
    public static final String MAX_JSON_REQUEST_SIZE_BYTES_KEY = "frontend.max.json.request.size.bytes";
    private static final String DEFAULT_ENDPOINT = "http://localhost:1174";
    private static final String DEFAULT_ENDPOINTS_STRING = "{\"POST\": \"http://localhost:1174\", \"GET\": \"http://localhost:1174\"}";
    public static final String REST_REQUEST_QUOTA_STRING = "frontend.rest.request.quota";
    private static final String DEFAULT_REST_REQUEST_QUOTA_STRING = "{\"PUT\": \"-1\",\"GET\": \"-1\",\"POST\": \"-1\",\"HEAD\": \"-1\",\"OPTIONS\": \"-1\",\"UNKNOWN\": \"-1\",\"DELETE\": \"-1\"}";
    @Config(value={"frontend.cache.validity.seconds"})
    @Default(value="365 * 24 * 60 * 60")
    public final long cacheValiditySeconds;
    @Config(value={"frontend.options.validity.seconds"})
    @Default(value="24 * 60 * 60")
    public final long optionsValiditySeconds;
    @Config(value={"frontend.options.allow.methods"})
    @Default(value="POST, GET, OPTIONS, HEAD, DELETE")
    public final String optionsAllowMethods;
    @Config(value={"frontend.id.converter.factory"})
    @Default(value="com.github.ambry.frontend.AmbryIdConverterFactory")
    public final String idConverterFactory;
    @Config(value={"frontend.security.service.factory"})
    @Default(value="com.github.ambry.frontend.AmbrySecurityServiceFactory")
    public final String securityServiceFactory;
    @Config(value={"frontend.url.signing.service.factory"})
    @Default(value="com.github.ambry.frontend.AmbryUrlSigningServiceFactory")
    public final String urlSigningServiceFactory;
    private static final String ID_SIGNING_SERVICE_FACTORY_KEY = "frontend.id.signing.service.factory";
    @Config(value={"frontend.id.signing.service.factory"})
    @Default(value="com.github.ambry.frontend.AmbryIdSigningServiceFactory")
    public final String idSigningServiceFactory;
    @Config(value={"frontend.path.prefixes.to.remove"})
    @Default(value="")
    public final List<String> pathPrefixesToRemove;
    @Config(value={"frontend.secure.path.prefix"})
    @Default(value="")
    public final String securePathPrefix;
    @Config(value={"frontend.chunked.get.response.threshold.in.bytes"})
    @Default(value="8192")
    public final Integer chunkedGetResponseThresholdInBytes;
    @Config(value={"frontend.allow.service.id.based.post.request"})
    @Default(value="true")
    public final boolean allowServiceIdBasedPostRequest;
    @Config(value={"frontend.attach.tracking.info"})
    @Default(value="true")
    public final boolean attachTrackingInfo;
    @Config(value={"frontend.url.signer.endpoints"})
    @Default(value="{\"POST\": \"http://localhost:1174\", \"GET\": \"http://localhost:1174\"}")
    public final String urlSignerEndpoints;
    @Config(value={"frontend.rest.request.quota"})
    @Default(value="{\"PUT\": \"-1\",\"GET\": \"-1\",\"POST\": \"-1\",\"HEAD\": \"-1\",\"OPTIONS\": \"-1\",\"UNKNOWN\": \"-1\",\"DELETE\": \"-1\"}")
    public final String restRequestQuota;
    @Config(value={"frontend.url.signer.default.max.upload.size.bytes"})
    @Default(value="100 * 1024 * 1024")
    public final long urlSignerDefaultMaxUploadSizeBytes;
    @Config(value={"frontend.url.signer.max.url.ttl.secs"})
    @Default(value="60 * 60")
    public final long urlSignerMaxUrlTtlSecs;
    @Config(value={"frontend.url.signer.default.url.ttl.secs"})
    @Default(value="5 * 60")
    public final long urlSignerDefaultUrlTtlSecs;
    @Config(value={"frontend.default.router.get.option"})
    @Default(value="GetOption.None")
    public final GetOption defaultRouterGetOption;
    @Config(value={"frontend.chunk.upload.initial.chunk.ttl.secs"})
    @Default(value="28 * 24 * 60 * 60")
    public final long chunkUploadInitialChunkTtlSecs;
    @Config(value={"frontend.fail.if.ttl.required.but.not.provided"})
    @Default(value="false")
    public final boolean failIfTtlRequiredButNotProvided;
    @Config(value={"frontend.max.acceptable.ttl.secs.if.ttl.required"})
    @Default(value="30 * 24 * 60 * 60")
    public final int maxAcceptableTtlSecsIfTtlRequired;
    @Config(value={"frontend.max.json.request.size.bytes"})
    @Default(value="20 * 1024 * 1024")
    public final int maxJsonRequestSizeBytes;

    public FrontendConfig(VerifiableProperties verifiableProperties) {
        this.cacheValiditySeconds = verifiableProperties.getLong("frontend.cache.validity.seconds", 31536000L);
        this.optionsValiditySeconds = verifiableProperties.getLong("frontend.options.validity.seconds", 86400L);
        this.optionsAllowMethods = verifiableProperties.getString("frontend.options.allow.methods", "POST, GET, OPTIONS, HEAD, DELETE");
        this.idConverterFactory = verifiableProperties.getString("frontend.id.converter.factory", "com.github.ambry.frontend.AmbryIdConverterFactory");
        this.securityServiceFactory = verifiableProperties.getString("frontend.security.service.factory", "com.github.ambry.frontend.AmbrySecurityServiceFactory");
        this.urlSigningServiceFactory = verifiableProperties.getString("frontend.url.signing.service.factory", "com.github.ambry.frontend.AmbryUrlSigningServiceFactory");
        this.idSigningServiceFactory = verifiableProperties.getString(ID_SIGNING_SERVICE_FACTORY_KEY, "com.github.ambry.frontend.AmbryIdSigningServiceFactory");
        this.securePathPrefix = verifiableProperties.getString("frontend.secure.path.prefix", "");
        ArrayList pathPrefixesFromConfig = Utils.splitString((String)verifiableProperties.getString("frontend.path.prefixes.to.remove", ""), (String)",");
        if (!this.securePathPrefix.isEmpty()) {
            pathPrefixesFromConfig.add(this.securePathPrefix);
        }
        this.pathPrefixesToRemove = Collections.unmodifiableList(pathPrefixesFromConfig.stream().map(this::stripLeadingAndTrailingSlash).collect(Collectors.toList()));
        this.chunkedGetResponseThresholdInBytes = verifiableProperties.getInt("frontend.chunked.get.response.threshold.in.bytes", 8192);
        this.allowServiceIdBasedPostRequest = verifiableProperties.getBoolean("frontend.allow.service.id.based.post.request", true);
        this.attachTrackingInfo = verifiableProperties.getBoolean("frontend.attach.tracking.info", true);
        this.restRequestQuota = verifiableProperties.getString(REST_REQUEST_QUOTA_STRING, DEFAULT_REST_REQUEST_QUOTA_STRING);
        this.urlSignerEndpoints = verifiableProperties.getString(URL_SIGNER_ENDPOINTS, DEFAULT_ENDPOINTS_STRING);
        this.urlSignerDefaultMaxUploadSizeBytes = verifiableProperties.getLongInRange("frontend.url.signer.default.max.upload.size.bytes", 0x6400000L, 0L, Long.MAX_VALUE);
        this.urlSignerMaxUrlTtlSecs = verifiableProperties.getLongInRange("frontend.url.signer.max.url.ttl.secs", 3600L, 0L, Long.MAX_VALUE);
        this.urlSignerDefaultUrlTtlSecs = verifiableProperties.getLongInRange("frontend.url.signer.default.url.ttl.secs", 300L, 0L, this.urlSignerMaxUrlTtlSecs);
        this.defaultRouterGetOption = GetOption.valueOf(verifiableProperties.getString("frontend.default.router.get.option", GetOption.None.name()));
        this.chunkUploadInitialChunkTtlSecs = verifiableProperties.getLong(CHUNK_UPLOAD_INITIAL_CHUNK_TTL_SECS_KEY, TimeUnit.DAYS.toSeconds(28L));
        this.failIfTtlRequiredButNotProvided = verifiableProperties.getBoolean(FAIL_IF_TTL_REQUIRED_BUT_NOT_PROVIDED_KEY, false);
        this.maxAcceptableTtlSecsIfTtlRequired = verifiableProperties.getIntInRange(MAX_ACCEPTABLE_TTL_SECS_IF_TTL_REQUIRED_KEY, (int)TimeUnit.DAYS.toSeconds(30L), 0, Integer.MAX_VALUE);
        this.maxJsonRequestSizeBytes = verifiableProperties.getIntInRange(MAX_JSON_REQUEST_SIZE_BYTES_KEY, 0x1400000, 0, Integer.MAX_VALUE);
    }

    private String stripLeadingAndTrailingSlash(String string) {
        return string.replaceAll("^/|/$", "");
    }
}

