/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class ConnectionPoolConfig {
    @Config(value={"connectionpool.read.buffer.size.bytes"})
    @Default(value="1048576")
    public final int connectionPoolReadBufferSizeBytes;
    @Config(value={"connectionpool.write.buffer.size.bytes"})
    @Default(value="1048576")
    public final int connectionPoolWriteBufferSizeBytes;
    @Config(value={"connectionpool.read.timeout.ms"})
    @Default(value="1500")
    public final int connectionPoolReadTimeoutMs;
    @Config(value={"connectionpool.connect.timeout.ms"})
    @Default(value="800")
    public final int connectionPoolConnectTimeoutMs;
    @Config(value={"connectionpool.max.connections.per.port.plain.text"})
    @Default(value="5")
    public final int connectionPoolMaxConnectionsPerPortPlainText;
    @Config(value={"connectionpool.max.connections.per.port.ssl"})
    @Default(value="2")
    public final int connectionPoolMaxConnectionsPerPortSSL;
    @Config(value={"connectionpool.socket.reset.on.error"})
    @Default(value="true")
    public final boolean connectionPoolSocketResetOnError;
    @Config(value={"connectionpool.socket.enable.tcp.no.delay"})
    @Default(value="true")
    public final boolean connectionPoolSocketEnableTcpNoDelay;

    public ConnectionPoolConfig(VerifiableProperties verifiableProperties) {
        this.connectionPoolReadBufferSizeBytes = verifiableProperties.getIntInRange("connectionpool.read.buffer.size.bytes", 0x100000, 1, 0x40000000);
        this.connectionPoolWriteBufferSizeBytes = verifiableProperties.getIntInRange("connectionpool.write.buffer.size.bytes", 0x100000, 1, 0x40000000);
        this.connectionPoolReadTimeoutMs = verifiableProperties.getIntInRange("connectionpool.read.timeout.ms", 1500, 1, 100000);
        this.connectionPoolConnectTimeoutMs = verifiableProperties.getIntInRange("connectionpool.connect.timeout.ms", 800, 1, 100000);
        this.connectionPoolMaxConnectionsPerPortPlainText = verifiableProperties.getIntInRange("connectionpool.max.connections.per.port.plain.text", 5, 1, 20);
        this.connectionPoolMaxConnectionsPerPortSSL = verifiableProperties.getIntInRange("connectionpool.max.connections.per.port.ssl", 2, 1, 20);
        this.connectionPoolSocketResetOnError = verifiableProperties.getBoolean("connectionpool.socket.reset.on.error", true);
        this.connectionPoolSocketEnableTcpNoDelay = verifiableProperties.getBoolean("connectionpool.socket.enable.tcp.no.delay", true);
    }
}

