/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import org.json.JSONObject;

public class ClusterMapConfig {
    public static final String AMBRY_STATE_MODEL_DEF = "AmbryLeaderStandby";
    public static final String OLD_STATE_MODEL_DEF = "LeaderStandby";
    public static final String DEFAULT_STATE_MODEL_DEF = "AmbryLeaderStandby";
    private static final String MAX_REPLICAS_ALL_DATACENTERS = "max-replicas-all-datacenters";
    @Config(value={"clustermap.resourcestatepolicy.factory"})
    @Default(value="com.github.ambry.clustermap.FixedBackoffResourceStatePolicyFactory")
    public final String clusterMapResourceStatePolicyFactory;
    @Config(value={"clustermap.fixedtimeout.datanode.error.threshold"})
    @Default(value="6")
    public final int clusterMapFixedTimeoutDatanodeErrorThreshold;
    @Config(value={"clustermap.fixedtimeout.datanode.retry.backoff.ms"})
    @Default(value="5 * 60 * 1000")
    public final int clusterMapFixedTimeoutDataNodeRetryBackoffMs;
    @Config(value={"clustermap.fixedtimeout.disk.error.threshold"})
    @Default(value="1")
    public final int clusterMapFixedTimeoutDiskErrorThreshold;
    @Config(value={"clustermap.fixedtimeout.disk.retry.backoff.ms"})
    @Default(value="10 * 60 * 1000")
    public final int clusterMapFixedTimeoutDiskRetryBackoffMs;
    @Config(value={"clustermap.fixedtimeout.replica.error.threshold"})
    @Default(value="1")
    public final int clusterMapFixedTimeoutReplicaErrorThreshold;
    @Config(value={"clustermap.fixedtimeout.replica.retry.backoff.ms"})
    @Default(value="10 * 60 * 1000")
    public final int clusterMapFixedTimeoutReplicaRetryBackoffMs;
    @Config(value={"clustermap.http2.network.client.enabled"})
    @Default(value="false")
    public final boolean clusterMapHttp2NetworkClientEnabled;
    @Config(value={"clustermap.ssl.enabled.datacenters"})
    @Default(value="")
    public final String clusterMapSslEnabledDatacenters;
    @Config(value={"clustermap.clusteragents.factory"})
    @Default(value="com.github.ambry.clustermap.StaticClusterAgentsFactory")
    public final String clusterMapClusterAgentsFactory;
    @Config(value={"clustermap.cluster.change.handler.type"})
    @Default(value="SimpleClusterChangeHandler")
    public final String clusterMapClusterChangeHandlerType;
    @Config(value={"clustermap.dcs.zk.connect.strings"})
    @Default(value="")
    public final String clusterMapDcsZkConnectStrings;
    @Config(value={"clustermap.cluster.name"})
    public final String clusterMapClusterName;
    @Config(value={"clustermap.datacenter.name"})
    public final String clusterMapDatacenterName;
    @Config(value={"clustermap.host.name"})
    public final String clusterMapHostName;
    @Config(value={"clustermap.port"})
    @Default(value="null")
    public final Integer clusterMapPort;
    @Config(value={"clustermap.resolve.hostnames"})
    @Default(value="true")
    public final boolean clusterMapResolveHostnames;
    @Config(value={"clustermap.default.partition.class"})
    @Default(value="max-replicas-all-datacenters")
    public final String clusterMapDefaultPartitionClass;
    @Config(value={"clustermap.current.xid"})
    @Default(value="Long.MAX_VALUE")
    public final Long clustermapCurrentXid;
    @Config(value={"clustermap.enable.partition.override"})
    @Default(value="false")
    public final boolean clusterMapEnablePartitionOverride;
    @Config(value={"clustermap.listen.cross.colo"})
    @Default(value="true")
    public final boolean clustermapListenCrossColo;
    @Config(value={"clustermap.vcr.datacenter.name"})
    public final String clustermapVcrDatacenterName;
    @Config(value={"clustermap.state.model.definition"})
    @Default(value="AmbryLeaderStandby")
    public final String clustermapStateModelDefinition;
    @Config(value={"clustermap.enable.state.model.listener"})
    @Default(value="false")
    public final boolean clustermapEnableStateModelListener;
    @Config(value={"clustermap.replica.catchup.acceptable.lag.bytes"})
    public final long clustermapReplicaCatchupAcceptableLagBytes;
    @Config(value={"clustermap.replica.catchup.target"})
    public final int clustermapReplicaCatchupTarget;
    @Config(value={"clustermap.writable.partition.min.replica.count"})
    public final int clustermapWritablePartitionMinReplicaCount;
    @Config(value={"clustermap.update.datanode.info"})
    @Default(value="false")
    public final boolean clustermapUpdateDatanodeInfo;
    @Config(value={"clustermap.recovery.test.partition.layout"})
    @Default(value="{}")
    public final JSONObject clustermapRecoveryTestPartitionLayout;
    @Config(value={"clustermap.recovery.test.hardware.layout"})
    @Default(value="{}")
    public final JSONObject clustermapRecoveryTestHardwareLayout;

    public ClusterMapConfig(VerifiableProperties verifiableProperties) {
        this.clusterMapFixedTimeoutDatanodeErrorThreshold = verifiableProperties.getIntInRange("clustermap.fixedtimeout.datanode.error.threshold", 3, 1, 100);
        this.clusterMapResourceStatePolicyFactory = verifiableProperties.getString("clustermap.resourcestatepolicy.factory", "com.github.ambry.clustermap.FixedBackoffResourceStatePolicyFactory");
        this.clusterMapFixedTimeoutDataNodeRetryBackoffMs = verifiableProperties.getIntInRange("clustermap.fixedtimeout.datanode.retry.backoff.ms", 300000, 1, 1200000);
        this.clusterMapFixedTimeoutDiskErrorThreshold = verifiableProperties.getIntInRange("clustermap.fixedtimeout.disk.error.threshold", 1, 1, 100);
        this.clusterMapFixedTimeoutDiskRetryBackoffMs = verifiableProperties.getIntInRange("clustermap.fixedtimeout.disk.retry.backoff.ms", 600000, 1, 1800000);
        this.clusterMapFixedTimeoutReplicaErrorThreshold = verifiableProperties.getIntInRange("clustermap.fixedtimeout.replica.error.threshold", 1, 1, Integer.MAX_VALUE);
        this.clusterMapFixedTimeoutReplicaRetryBackoffMs = verifiableProperties.getIntInRange("clustermap.fixedtimeout.replica.retry.backoff.ms", 600000, 1, 1800000);
        this.clusterMapHttp2NetworkClientEnabled = verifiableProperties.getBoolean("clustermap.http2.network.client.enabled", false);
        this.clusterMapSslEnabledDatacenters = verifiableProperties.getString("clustermap.ssl.enabled.datacenters", "");
        this.clusterMapClusterAgentsFactory = verifiableProperties.getString("clustermap.clusteragents.factory", "com.github.ambry.clustermap.StaticClusterAgentsFactory");
        this.clusterMapClusterChangeHandlerType = verifiableProperties.getString("clustermap.cluster.change.handler.type", "SimpleClusterChangeHandler");
        this.clusterMapDcsZkConnectStrings = verifiableProperties.getString("clustermap.dcs.zk.connect.strings", "");
        this.clusterMapClusterName = verifiableProperties.getString("clustermap.cluster.name");
        this.clusterMapDatacenterName = verifiableProperties.getString("clustermap.datacenter.name");
        this.clusterMapHostName = verifiableProperties.getString("clustermap.host.name");
        this.clusterMapPort = verifiableProperties.getInteger("clustermap.port", null);
        this.clusterMapResolveHostnames = verifiableProperties.getBoolean("clustermap.resolve.hostnames", true);
        this.clusterMapDefaultPartitionClass = verifiableProperties.getString("clustermap.default.partition.class", MAX_REPLICAS_ALL_DATACENTERS);
        this.clustermapCurrentXid = verifiableProperties.getLong("clustermap.current.xid", Long.MAX_VALUE);
        this.clusterMapEnablePartitionOverride = verifiableProperties.getBoolean("clustermap.enable.partition.override", false);
        this.clustermapListenCrossColo = verifiableProperties.getBoolean("clustermap.listen.cross.colo", true);
        this.clustermapStateModelDefinition = verifiableProperties.getString("clustermap.state.model.definition", "AmbryLeaderStandby");
        this.clustermapVcrDatacenterName = verifiableProperties.getString("clustermap.vcr.datacenter.name", null);
        if (!this.clustermapStateModelDefinition.equals("AmbryLeaderStandby") && !this.clustermapStateModelDefinition.equals(OLD_STATE_MODEL_DEF)) {
            throw new IllegalArgumentException("Unsupported state model definition: " + this.clustermapStateModelDefinition);
        }
        this.clustermapEnableStateModelListener = verifiableProperties.getBoolean("clustermap.enable.state.model.listener", false);
        this.clustermapReplicaCatchupAcceptableLagBytes = verifiableProperties.getLongInRange("clustermap.replica.catchup.acceptable.lag.bytes", 0L, 0L, Long.MAX_VALUE);
        this.clustermapReplicaCatchupTarget = verifiableProperties.getIntInRange("clustermap.replica.catchup.target", 0, 0, Integer.MAX_VALUE);
        this.clustermapWritablePartitionMinReplicaCount = verifiableProperties.getIntInRange("clustermap.writable.partition.min.replica.count", 3, 0, Integer.MAX_VALUE);
        this.clustermapUpdateDatanodeInfo = verifiableProperties.getBoolean("clustermap.update.datanode.info", false);
        this.clustermapRecoveryTestHardwareLayout = new JSONObject(verifiableProperties.getString("clustermap.recovery.test.hardware.layout", "{}"));
        this.clustermapRecoveryTestPartitionLayout = new JSONObject(verifiableProperties.getString("clustermap.recovery.test.partition.layout", "{}"));
    }
}

