/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.account;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Container {
    static final String JSON_VERSION_KEY = "version";
    static final String CONTAINER_NAME_KEY = "containerName";
    static final String CONTAINER_ID_KEY = "containerId";
    static final String STATUS_KEY = "status";
    static final String DESCRIPTION_KEY = "description";
    static final String IS_PRIVATE_KEY = "isPrivate";
    static final String BACKUP_ENABLED_KEY = "backupEnabled";
    static final String ENCRYPTED_KEY = "encrypted";
    static final String PREVIOUSLY_ENCRYPTED_KEY = "previouslyEncrypted";
    static final String CACHEABLE_KEY = "cacheable";
    static final String MEDIA_SCAN_DISABLED_KEY = "mediaScanDisabled";
    static final String REPLICATION_POLICY_KEY = "replicationPolicy";
    static final String TTL_REQUIRED_KEY = "ttlRequired";
    static final String SECURE_PATH_REQUIRED_KEY = "securePathRequired";
    static final String CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD = "contentTypeWhitelistForFilenamesOnDownload";
    static final String PARENT_ACCOUNT_ID_KEY = "parentAccountId";
    static final boolean BACKUP_ENABLED_DEFAULT_VALUE = false;
    static final boolean ENCRYPTED_DEFAULT_VALUE = false;
    static final boolean PREVIOUSLY_ENCRYPTED_DEFAULT_VALUE = false;
    static final boolean MEDIA_SCAN_DISABLED_DEFAULT_VALUE = false;
    static final boolean TTL_REQUIRED_DEFAULT_VALUE = true;
    static final boolean SECURE_PATH_REQUIRED_DEFAULT_VALUE = false;
    static final boolean CACHEABLE_DEFAULT_VALUE = true;
    static final Set<String> CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE = Collections.emptySet();
    public static final short JSON_VERSION_1 = 1;
    public static final short JSON_VERSION_2 = 2;
    private static short currentJsonVersion = (short)2;
    public static final short UNKNOWN_CONTAINER_ID = -1;
    public static final short HELIX_ACCOUNT_SERVICE_CONTAINER_ID = -2;
    public static final short DEFAULT_PUBLIC_CONTAINER_ID = 0;
    public static final short DEFAULT_PRIVATE_CONTAINER_ID = 1;
    public static final String UNKNOWN_CONTAINER_NAME = "ambry-unknown-container";
    public static final String DEFAULT_PUBLIC_CONTAINER_NAME = "default-public-container";
    public static final String DEFAULT_PRIVATE_CONTAINER_NAME = "default-private-container";
    public static final ContainerStatus UNKNOWN_CONTAINER_STATUS = ContainerStatus.ACTIVE;
    public static final ContainerStatus DEFAULT_PUBLIC_CONTAINER_STATUS = ContainerStatus.ACTIVE;
    public static final ContainerStatus DEFAULT_PRIVATE_CONTAINER_STATUS = ContainerStatus.ACTIVE;
    public static final String UNKNOWN_CONTAINER_DESCRIPTION = "This is a container for the blobs without specifying a target account and container when they are put";
    public static final String DEFAULT_PUBLIC_CONTAINER_DESCRIPTION = "This is a container for the blobs without specifying a target account and container when they are put and isPrivate flag is false";
    public static final String DEFAULT_PRIVATE_CONTAINER_DESCRIPTION = "This is a container for the blobs without specifying a target account and container when they are put and isPrivate flag is true";
    public static final boolean UNKNOWN_CONTAINER_ENCRYPTED_SETTING = false;
    public static final boolean DEFAULT_PUBLIC_CONTAINER_ENCRYPTED_SETTING = false;
    public static final boolean DEFAULT_PRIVATE_CONTAINER_ENCRYPTED_SETTING = false;
    public static final boolean UNKNOWN_CONTAINER_PREVIOUSLY_ENCRYPTED_SETTING = false;
    public static final boolean DEFAULT_PUBLIC_CONTAINER_PREVIOUSLY_ENCRYPTED_SETTING = false;
    public static final boolean DEFAULT_PRIVATE_CONTAINER_PREVIOUSLY_ENCRYPTED_SETTING = false;
    public static final boolean UNKNOWN_CONTAINER_CACHEABLE_SETTING = true;
    public static final boolean DEFAULT_PUBLIC_CONTAINER_CACHEABLE_SETTING = true;
    public static final boolean DEFAULT_PRIVATE_CONTAINER_CACHEABLE_SETTING = false;
    public static final boolean UNKNOWN_CONTAINER_MEDIA_SCAN_DISABLED_SETTING = false;
    public static final boolean DEFAULT_PUBLIC_CONTAINER_MEDIA_SCAN_DISABLED_SETTING = false;
    public static final boolean DEFAULT_PRIVATE_CONTAINER_MEDIA_SCAN_DISABLED_SETTING = false;
    public static final boolean UNKNOWN_CONTAINER_TTL_REQUIRED_SETTING = true;
    public static final boolean DEFAULT_PUBLIC_CONTAINER_TTL_REQUIRED_SETTING = true;
    public static final boolean DEFAULT_PRIVATE_CONTAINER_TTL_REQUIRED_SETTING = true;
    public static final short UNKNOWN_CONTAINER_PARENT_ACCOUNT_ID = -1;
    public static final short DEFAULT_PUBLIC_CONTAINER_PARENT_ACCOUNT_ID = -1;
    public static final short DEFAULT_PRIVATE_CONTAINER_PARENT_ACCOUNT_ID = -1;
    @Deprecated
    public static final Container UNKNOWN_CONTAINER = new Container(-1, "ambry-unknown-container", UNKNOWN_CONTAINER_STATUS, "This is a container for the blobs without specifying a target account and container when they are put", false, false, true, false, null, true, false, CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE, false, -1);
    @Deprecated
    public static final Container DEFAULT_PUBLIC_CONTAINER = new Container(0, "default-public-container", DEFAULT_PUBLIC_CONTAINER_STATUS, "This is a container for the blobs without specifying a target account and container when they are put and isPrivate flag is false", false, false, true, false, null, true, false, CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE, false, -1);
    @Deprecated
    public static final Container DEFAULT_PRIVATE_CONTAINER = new Container(1, "default-private-container", DEFAULT_PRIVATE_CONTAINER_STATUS, "This is a container for the blobs without specifying a target account and container when they are put and isPrivate flag is true", false, false, false, false, null, true, false, CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE, false, -1);
    private final short id;
    private final String name;
    private final ContainerStatus status;
    private final String description;
    private final boolean encrypted;
    private final boolean previouslyEncrypted;
    private final boolean cacheable;
    private final boolean backupEnabled;
    private final boolean mediaScanDisabled;
    private final String replicationPolicy;
    private final boolean ttlRequired;
    private final boolean securePathRequired;
    private final Set<String> contentTypeWhitelistForFilenamesOnDownload;
    private final short parentAccountId;

    private Container(JSONObject metadata, short parentAccountId) throws JSONException {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null.");
        }
        this.parentAccountId = parentAccountId;
        short metadataVersion = (short)metadata.getInt(JSON_VERSION_KEY);
        switch (metadataVersion) {
            case 1: {
                this.id = (short)metadata.getInt(CONTAINER_ID_KEY);
                this.name = metadata.getString(CONTAINER_NAME_KEY);
                this.status = ContainerStatus.valueOf(metadata.getString(STATUS_KEY));
                this.description = metadata.optString(DESCRIPTION_KEY);
                this.encrypted = false;
                this.previouslyEncrypted = false;
                this.cacheable = !metadata.getBoolean(IS_PRIVATE_KEY);
                this.backupEnabled = false;
                this.mediaScanDisabled = false;
                this.replicationPolicy = null;
                this.ttlRequired = true;
                this.securePathRequired = false;
                this.contentTypeWhitelistForFilenamesOnDownload = CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE;
                break;
            }
            case 2: {
                this.id = (short)metadata.getInt(CONTAINER_ID_KEY);
                this.name = metadata.getString(CONTAINER_NAME_KEY);
                this.status = ContainerStatus.valueOf(metadata.getString(STATUS_KEY));
                this.description = metadata.optString(DESCRIPTION_KEY);
                this.encrypted = metadata.optBoolean(ENCRYPTED_KEY, false);
                this.previouslyEncrypted = metadata.optBoolean(PREVIOUSLY_ENCRYPTED_KEY, false);
                this.cacheable = metadata.optBoolean(CACHEABLE_KEY, true);
                this.backupEnabled = metadata.optBoolean(BACKUP_ENABLED_KEY, false);
                this.mediaScanDisabled = metadata.optBoolean(MEDIA_SCAN_DISABLED_KEY, false);
                this.replicationPolicy = metadata.optString(REPLICATION_POLICY_KEY, null);
                this.ttlRequired = metadata.optBoolean(TTL_REQUIRED_KEY, true);
                this.securePathRequired = metadata.optBoolean(SECURE_PATH_REQUIRED_KEY, false);
                JSONArray contentTypeWhitelistForFilenamesOnDownloadJson = metadata.optJSONArray(CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD);
                if (contentTypeWhitelistForFilenamesOnDownloadJson != null) {
                    this.contentTypeWhitelistForFilenamesOnDownload = new HashSet<String>();
                    contentTypeWhitelistForFilenamesOnDownloadJson.forEach(contentType -> this.contentTypeWhitelistForFilenamesOnDownload.add(contentType.toString()));
                    break;
                }
                this.contentTypeWhitelistForFilenamesOnDownload = CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported container json version=" + metadataVersion);
            }
        }
        this.checkPreconditions(this.name, this.status, this.encrypted, this.previouslyEncrypted);
    }

    Container(short id, String name, ContainerStatus status, String description, boolean encrypted, boolean previouslyEncrypted, boolean cacheable, boolean mediaScanDisabled, String replicationPolicy, boolean ttlRequired, boolean securePathRequired, Set<String> contentTypeWhitelistForFilenamesOnDownload, boolean backupEnabled, short parentAccountId) {
        this.checkPreconditions(name, status, encrypted, previouslyEncrypted);
        this.id = id;
        this.name = name;
        this.status = status;
        this.description = description;
        this.cacheable = cacheable;
        this.parentAccountId = parentAccountId;
        switch (currentJsonVersion) {
            case 1: {
                this.backupEnabled = false;
                this.encrypted = false;
                this.previouslyEncrypted = false;
                this.mediaScanDisabled = false;
                this.replicationPolicy = null;
                this.ttlRequired = true;
                this.securePathRequired = false;
                this.contentTypeWhitelistForFilenamesOnDownload = CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE;
                break;
            }
            case 2: {
                this.backupEnabled = backupEnabled;
                this.encrypted = encrypted;
                this.previouslyEncrypted = previouslyEncrypted;
                this.mediaScanDisabled = mediaScanDisabled;
                this.replicationPolicy = replicationPolicy;
                this.ttlRequired = ttlRequired;
                this.securePathRequired = securePathRequired;
                this.contentTypeWhitelistForFilenamesOnDownload = contentTypeWhitelistForFilenamesOnDownload == null ? Collections.emptySet() : contentTypeWhitelistForFilenamesOnDownload;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported container json version=" + currentJsonVersion);
            }
        }
    }

    public static short getCurrentJsonVersion() {
        return currentJsonVersion;
    }

    public static void setCurrentJsonVersion(short currentJsonVersion) {
        Container.currentJsonVersion = currentJsonVersion;
    }

    static Container fromJson(JSONObject json, short parentAccountId) throws JSONException {
        return new Container(json, parentAccountId);
    }

    JSONObject toJson() throws JSONException {
        JSONObject metadata = new JSONObject();
        switch (currentJsonVersion) {
            case 1: {
                metadata.put(JSON_VERSION_KEY, 1);
                metadata.put(CONTAINER_ID_KEY, (int)this.id);
                metadata.put(CONTAINER_NAME_KEY, (Object)this.name);
                metadata.put(STATUS_KEY, (Object)this.status.name());
                metadata.put(DESCRIPTION_KEY, (Object)this.description);
                metadata.put(IS_PRIVATE_KEY, !this.cacheable);
                metadata.put(PARENT_ACCOUNT_ID_KEY, (int)this.parentAccountId);
                break;
            }
            case 2: {
                metadata.put(JSON_VERSION_KEY, 2);
                metadata.put(CONTAINER_ID_KEY, (int)this.id);
                metadata.put(CONTAINER_NAME_KEY, (Object)this.name);
                metadata.put(STATUS_KEY, (Object)this.status.name());
                metadata.put(DESCRIPTION_KEY, (Object)this.description);
                metadata.put(ENCRYPTED_KEY, this.encrypted);
                metadata.put(PREVIOUSLY_ENCRYPTED_KEY, this.previouslyEncrypted);
                metadata.put(CACHEABLE_KEY, this.cacheable);
                metadata.put(BACKUP_ENABLED_KEY, this.backupEnabled);
                metadata.put(MEDIA_SCAN_DISABLED_KEY, this.mediaScanDisabled);
                metadata.putOpt(REPLICATION_POLICY_KEY, (Object)this.replicationPolicy);
                metadata.put(TTL_REQUIRED_KEY, this.ttlRequired);
                metadata.put(SECURE_PATH_REQUIRED_KEY, this.securePathRequired);
                if (this.contentTypeWhitelistForFilenamesOnDownload == null || this.contentTypeWhitelistForFilenamesOnDownload.isEmpty()) break;
                JSONArray contentTypeWhitelistForFilenamesOnDownloadJson = new JSONArray();
                this.contentTypeWhitelistForFilenamesOnDownload.forEach(arg_0 -> ((JSONArray)contentTypeWhitelistForFilenamesOnDownloadJson).put(arg_0));
                metadata.put(CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD, (Object)contentTypeWhitelistForFilenamesOnDownloadJson);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported container json version=" + currentJsonVersion);
            }
        }
        return metadata;
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ContainerStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isBackupEnabled() {
        return this.backupEnabled;
    }

    public boolean wasPreviouslyEncrypted() {
        return this.previouslyEncrypted;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isMediaScanDisabled() {
        return this.mediaScanDisabled;
    }

    public String getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public boolean isTtlRequired() {
        return this.ttlRequired;
    }

    public Set<String> getContentTypeWhitelistForFilenamesOnDownload() {
        return this.contentTypeWhitelistForFilenamesOnDownload;
    }

    public boolean isSecurePathRequired() {
        return this.securePathRequired;
    }

    public short getParentAccountId() {
        return this.parentAccountId;
    }

    public String toString() {
        return "Container[" + this.getParentAccountId() + ":" + this.getId() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        return this.id == container.id && this.encrypted == container.encrypted && this.previouslyEncrypted == container.previouslyEncrypted && this.cacheable == container.cacheable && this.mediaScanDisabled == container.mediaScanDisabled && this.parentAccountId == container.parentAccountId && Objects.equals(this.name, container.name) && this.status == container.status && Objects.equals(this.description, container.description) && Objects.equals(this.replicationPolicy, container.replicationPolicy) && this.ttlRequired == container.ttlRequired && this.securePathRequired == container.securePathRequired && Objects.equals(this.contentTypeWhitelistForFilenamesOnDownload, container.contentTypeWhitelistForFilenamesOnDownload);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentAccountId);
    }

    private void checkPreconditions(String name, ContainerStatus status, boolean encrypted, boolean previouslyEncrypted) {
        if (name == null || status == null) {
            throw new IllegalStateException("Either of required fields name=" + name + " or status=" + (Object)((Object)status) + " is null");
        }
        if (encrypted && !previouslyEncrypted) {
            throw new IllegalStateException("previouslyEncrypted should be true if the container is currently encrypted");
        }
    }

    public static enum ContainerStatus {
        ACTIVE,
        INACTIVE;

    }
}

