/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.account;

import com.github.ambry.account.Account;
import com.github.ambry.account.Container;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AccountBuilder {
    private short id;
    private String name;
    private Account.AccountStatus status;
    private int snapshotVersion = 0;
    private Map<Short, Container> idToContainerMetadataMap = new HashMap<Short, Container>();

    public AccountBuilder(Account origin) {
        if (origin == null) {
            throw new IllegalArgumentException("origin cannot be null.");
        }
        this.id = origin.getId();
        this.name = origin.getName();
        this.status = origin.getStatus();
        this.snapshotVersion = origin.getSnapshotVersion();
        for (Container container : origin.getAllContainers()) {
            this.idToContainerMetadataMap.put(container.getId(), container);
        }
    }

    public AccountBuilder(short id, String name, Account.AccountStatus status) {
        this.id = id;
        this.name = name;
        this.status = status;
    }

    public AccountBuilder id(short id) {
        this.id = id;
        return this;
    }

    public AccountBuilder name(String name) {
        this.name = name;
        return this;
    }

    public AccountBuilder status(Account.AccountStatus status) {
        this.status = status;
        return this;
    }

    public AccountBuilder snapshotVersion(int snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
        return this;
    }

    public AccountBuilder containers(Collection<Container> containers) {
        this.idToContainerMetadataMap.clear();
        if (containers != null) {
            for (Container container : containers) {
                this.idToContainerMetadataMap.put(container.getId(), container);
            }
        }
        return this;
    }

    public AccountBuilder addOrUpdateContainer(Container container) {
        if (container != null) {
            this.idToContainerMetadataMap.put(container.getId(), container);
        }
        return this;
    }

    public AccountBuilder removeContainer(Container container) {
        short id;
        Container containerToRemove;
        if (container != null && container.equals(containerToRemove = this.idToContainerMetadataMap.get(id = container.getId()))) {
            this.idToContainerMetadataMap.remove(id);
        }
        return this;
    }

    public Account build() {
        return new Account(this.id, this.name, this.status, this.snapshotVersion, this.idToContainerMetadataMap.values());
    }
}

