/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.account;

import com.github.ambry.account.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Account {
    static final String JSON_VERSION_KEY = "version";
    static final String ACCOUNT_ID_KEY = "accountId";
    static final String ACCOUNT_NAME_KEY = "accountName";
    static final String STATUS_KEY = "status";
    static final String SNAPSHOT_VERSION_KEY = "snapshotVersion";
    static final String CONTAINERS_KEY = "containers";
    static final short JSON_VERSION_1 = 1;
    static final short CURRENT_JSON_VERSION = 1;
    static final int SNAPSHOT_VERSION_DEFAULT_VALUE = 0;
    public static final short UNKNOWN_ACCOUNT_ID = -1;
    public static final String UNKNOWN_ACCOUNT_NAME = "ambry-unknown-account";
    public static final short HELIX_ACCOUNT_SERVICE_ACCOUNT_ID = -2;
    public static final String HELIX_ACCOUNT_SERVICE_ACCOUNT_NAME = "helix-account-service-account-name";
    private final short id;
    private final String name;
    private AccountStatus status;
    private final int snapshotVersion;
    private final Map<Short, Container> containerIdToContainerMap = new HashMap<Short, Container>();
    private final Map<String, Container> containerNameToContainerMap = new HashMap<String, Container>();

    private Account(JSONObject metadata) throws JSONException {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null.");
        }
        short metadataVersion = (short)metadata.getInt(JSON_VERSION_KEY);
        switch (metadataVersion) {
            case 1: {
                this.id = (short)metadata.getInt(ACCOUNT_ID_KEY);
                this.name = metadata.getString(ACCOUNT_NAME_KEY);
                this.status = AccountStatus.valueOf(metadata.getString(STATUS_KEY));
                this.snapshotVersion = metadata.optInt(SNAPSHOT_VERSION_KEY, 0);
                this.checkRequiredFieldsForBuild();
                JSONArray containerArray = metadata.optJSONArray(CONTAINERS_KEY);
                if (containerArray == null) break;
                for (int index = 0; index < containerArray.length(); ++index) {
                    Container container = Container.fromJson(containerArray.getJSONObject(index), this.id);
                    this.checkParentAccountIdInContainers(container);
                    this.checkDuplicateContainerNameOrId(container);
                    this.updateContainerMap(container);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported account json version=" + metadataVersion);
            }
        }
    }

    Account(short id, String name, AccountStatus status, int snapshotVersion, Collection<Container> containers) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.snapshotVersion = snapshotVersion;
        this.checkRequiredFieldsForBuild();
        if (containers != null) {
            for (Container container : containers) {
                this.checkParentAccountIdInContainers(container);
                this.checkDuplicateContainerNameOrId(container);
                this.updateContainerMap(container);
            }
        }
    }

    JSONObject toJson(boolean incrementSnapshotVersion) throws JSONException {
        JSONObject metadata = new JSONObject();
        metadata.put(JSON_VERSION_KEY, 1);
        metadata.put(ACCOUNT_ID_KEY, (int)this.id);
        metadata.put(ACCOUNT_NAME_KEY, (Object)this.name);
        metadata.put(STATUS_KEY, (Object)this.status.name());
        metadata.put(SNAPSHOT_VERSION_KEY, incrementSnapshotVersion ? this.snapshotVersion + 1 : this.snapshotVersion);
        JSONArray containerArray = new JSONArray();
        for (Container container : this.containerIdToContainerMap.values()) {
            containerArray.put((Object)container.toJson());
        }
        metadata.put(CONTAINERS_KEY, (Object)containerArray);
        return metadata;
    }

    static Account fromJson(JSONObject json) throws JSONException {
        return new Account(json);
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public int getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public Container getContainerById(short containerId) {
        return this.containerIdToContainerMap.get(containerId);
    }

    public Container getContainerByName(String containerName) {
        return this.containerNameToContainerMap.get(containerName);
    }

    public Collection<Container> getAllContainers() {
        return Collections.unmodifiableCollection(this.containerIdToContainerMap.values());
    }

    public String toString() {
        return "Account[" + this.getId() + "," + this.getSnapshotVersion() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        if (this.id != account.id) {
            return false;
        }
        if (!this.name.equals(account.name)) {
            return false;
        }
        if (this.status != account.status) {
            return false;
        }
        return this.containerIdToContainerMap.equals(account.containerIdToContainerMap);
    }

    public int hashCode() {
        return this.id;
    }

    private void updateContainerMap(Container container) {
        this.containerIdToContainerMap.put(container.getId(), container);
        this.containerNameToContainerMap.put(container.getName(), container);
    }

    private void checkParentAccountIdInContainers(Container container) {
        if (container.getParentAccountId() != this.id) {
            throw new IllegalStateException("Container does not belong to this account because parentAccountId=" + container.getParentAccountId() + " is not the same as accountId=" + this.id);
        }
    }

    private void checkRequiredFieldsForBuild() {
        if (this.name == null || this.status == null) {
            throw new IllegalStateException("Either of required fields name=" + this.name + " or status=" + (Object)((Object)this.status) + " is null");
        }
    }

    private void checkDuplicateContainerNameOrId(Container container) {
        if (this.containerIdToContainerMap.containsKey(container.getId()) || this.containerNameToContainerMap.containsKey(container.getName())) {
            Container conflictContainer = this.containerIdToContainerMap.get(container.getId());
            conflictContainer = conflictContainer == null ? this.containerNameToContainerMap.get(container.getName()) : conflictContainer;
            String errorMessage = "Duplicate container id or name exists. containerId=" + container.getId() + " containerName=" + container.getName() + " conflicts with containerId=" + conflictContainer.getId() + " containerName=" + conflictContainer.getName();
            throw new IllegalStateException(errorMessage);
        }
    }

    public static enum AccountStatus {
        ACTIVE,
        INACTIVE;

    }
}

