/*
 * Decompiled with CFR 0.152.
 */
package com.amar.library.ui.presenter;

import android.support.annotation.StyleableRes;
import com.amar.library.provider.interfaces.IResourceProvider;
import com.amar.library.provider.interfaces.IScreenInfoProvider;
import com.amar.library.ui.presentation.IStickyScrollPresentation;

public class StickyScrollPresenter {
    private final IResourceProvider mTypedArrayResourceProvider;
    private IStickyScrollPresentation mStickyScrollPresentation;
    private int mDeviceHeight;
    private int mStickyFooterHeight;
    private int mStickyFooterInitialTranslation;
    private int mStickyFooterInitialLocation;
    private int mStickyHeaderInitialLocation;
    private boolean mIsFooterSticky;
    private boolean mIsHeaderSticky;
    public boolean mScrolled;

    public StickyScrollPresenter(IStickyScrollPresentation stickyScrollPresentation, IScreenInfoProvider screenInfoProvider, IResourceProvider typedArrayResourceProvider) {
        this.mDeviceHeight = screenInfoProvider.getScreenHeight();
        this.mTypedArrayResourceProvider = typedArrayResourceProvider;
        this.mStickyScrollPresentation = stickyScrollPresentation;
    }

    public void onGlobalLayoutChange(@StyleableRes int headerRes, @StyleableRes int footerRes) {
        int footerId;
        int headerId = this.mTypedArrayResourceProvider.getResourceId(headerRes);
        if (headerId != 0) {
            this.mStickyScrollPresentation.initHeaderView(headerId);
        }
        if ((footerId = this.mTypedArrayResourceProvider.getResourceId(footerRes)) != 0) {
            this.mStickyScrollPresentation.initFooterView(footerId);
        }
        this.mTypedArrayResourceProvider.recycle();
    }

    public void initStickyFooter(int measuredHeight, int initialStickyFooterLocation) {
        this.mStickyFooterHeight = measuredHeight;
        this.mStickyFooterInitialLocation = initialStickyFooterLocation;
        this.mStickyFooterInitialTranslation = this.mDeviceHeight - initialStickyFooterLocation - this.mStickyFooterHeight;
        if (this.mStickyFooterInitialLocation > this.mDeviceHeight - this.mStickyFooterHeight) {
            this.mStickyScrollPresentation.stickFooter(this.mStickyFooterInitialTranslation);
            this.mIsFooterSticky = true;
        }
    }

    public void initStickyHeader(int headerTop) {
        this.mStickyHeaderInitialLocation = headerTop;
    }

    public void onScroll(int scrollY) {
        this.mScrolled = true;
        this.handleFooterStickiness(scrollY);
        this.handleHeaderStickiness(scrollY);
    }

    private void handleFooterStickiness(int scrollY) {
        if (scrollY > this.mStickyFooterInitialLocation - this.mDeviceHeight + this.mStickyFooterHeight) {
            this.mStickyScrollPresentation.freeFooter();
            this.mIsFooterSticky = false;
        } else {
            this.mStickyScrollPresentation.stickFooter(this.mStickyFooterInitialTranslation + scrollY);
            this.mIsFooterSticky = true;
        }
    }

    private void handleHeaderStickiness(int scrollY) {
        if (scrollY > this.mStickyHeaderInitialLocation) {
            this.mStickyScrollPresentation.stickHeader(scrollY - this.mStickyHeaderInitialLocation);
            this.mIsHeaderSticky = true;
        } else {
            this.mStickyScrollPresentation.freeHeader();
            this.mIsHeaderSticky = false;
        }
    }

    public boolean isFooterSticky() {
        return this.mIsFooterSticky;
    }

    public boolean isHeaderSticky() {
        return this.mIsHeaderSticky;
    }

    public void recomputeFooterLocation(int footerTop, int footerLocation) {
        if (this.mScrolled) {
            this.mStickyFooterInitialTranslation = this.mDeviceHeight - footerTop - this.mStickyFooterHeight;
            this.mStickyFooterInitialLocation = footerTop;
            if (footerLocation > this.mDeviceHeight - this.mStickyFooterHeight) {
                this.mStickyScrollPresentation.stickFooter(this.mStickyFooterInitialTranslation);
                this.mIsFooterSticky = true;
            } else {
                this.mStickyScrollPresentation.freeFooter();
                this.mIsFooterSticky = false;
            }
        } else {
            this.initStickyFooter(this.mStickyFooterHeight, footerTop);
        }
    }
}

