/*
 * Decompiled with CFR 0.152.
 */
package com.amar.library.ui;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import com.amar.library.R;
import com.amar.library.provider.ResourceProvider;
import com.amar.library.provider.ScreenInfoProvider;
import com.amar.library.ui.PropertySetter;
import com.amar.library.ui.interfaces.IScrollViewListener;
import com.amar.library.ui.presentation.IStickyScrollPresentation;
import com.amar.library.ui.presenter.StickyScrollPresenter;

public class StickyScrollView
extends ScrollView
implements IStickyScrollPresentation {
    private static final String TAG = StickyScrollView.class.getSimpleName();
    private IScrollViewListener scrollViewListener;
    private View stickyFooterView;
    private View stickyHeaderView;
    private static final String SCROLL_STATE = "scroll_state";
    private static final String SUPER_STATE = "super_state";
    private StickyScrollPresenter mStickyScrollPresenter;
    int[] updatedFooterLocation = new int[2];

    public StickyScrollView(Context context) {
        this(context, null);
    }

    public StickyScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickyScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        ScreenInfoProvider screenInfoProvider = new ScreenInfoProvider(context);
        ResourceProvider resourceProvider = new ResourceProvider(context, attrs, R.styleable.StickyScrollView);
        this.mStickyScrollPresenter = new StickyScrollPresenter(this, screenInfoProvider, resourceProvider);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                StickyScrollView.this.mStickyScrollPresenter.onGlobalLayoutChange(R.styleable.StickyScrollView_stickyHeader, R.styleable.StickyScrollView_stickyFooter);
                StickyScrollView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.stickyFooterView != null && !changed) {
            this.stickyFooterView.getLocationInWindow(this.updatedFooterLocation);
            this.mStickyScrollPresenter.recomputeFooterLocation(this.getRelativeTop(this.stickyFooterView), this.updatedFooterLocation[1]);
        }
    }

    private int getRelativeTop(View myView) {
        if (myView.getParent() == myView.getRootView()) {
            return myView.getTop();
        }
        return myView.getTop() + this.getRelativeTop((View)myView.getParent());
    }

    @Override
    public void initHeaderView(int id) {
        this.stickyHeaderView = this.findViewById(id);
        this.mStickyScrollPresenter.initStickyHeader(this.stickyHeaderView.getTop());
    }

    @Override
    public void initFooterView(int id) {
        this.stickyFooterView = this.findViewById(id);
        this.mStickyScrollPresenter.initStickyFooter(this.stickyFooterView.getMeasuredHeight(), this.getRelativeTop(this.stickyFooterView));
    }

    @Override
    public void freeHeader() {
        if (this.stickyHeaderView != null) {
            this.stickyHeaderView.setTranslationY(0.0f);
            PropertySetter.setTranslationZ(this.stickyHeaderView, 0.0f);
        }
    }

    @Override
    public void freeFooter() {
        if (this.stickyFooterView != null) {
            this.stickyFooterView.setTranslationY(0.0f);
        }
    }

    @Override
    public void stickHeader(int translationY) {
        if (this.stickyHeaderView != null) {
            this.stickyHeaderView.setTranslationY((float)translationY);
            PropertySetter.setTranslationZ(this.stickyHeaderView, 1.0f);
        }
    }

    @Override
    public void stickFooter(int translationY) {
        if (this.stickyFooterView != null) {
            this.stickyFooterView.setTranslationY((float)translationY);
        }
    }

    protected void onScrollChanged(int mScrollX, int mScrollY, int oldX, int oldY) {
        super.onScrollChanged(mScrollX, mScrollY, oldX, oldY);
        this.mStickyScrollPresenter.onScroll(mScrollY);
        if (this.scrollViewListener != null) {
            this.scrollViewListener.onScrollChanged(mScrollX, mScrollY, oldX, oldY);
        }
    }

    public IScrollViewListener getScrollViewListener() {
        return this.scrollViewListener;
    }

    public void setScrollViewListener(IScrollViewListener scrollViewListener) {
        this.scrollViewListener = scrollViewListener;
    }

    public boolean isFooterSticky() {
        return this.mStickyScrollPresenter.isFooterSticky();
    }

    public boolean isHeaderSticky() {
        return this.mStickyScrollPresenter.isHeaderSticky();
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
        if (this.scrollViewListener != null) {
            this.scrollViewListener.onScrollStopped(clampedY);
        }
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(SUPER_STATE, super.onSaveInstanceState());
        bundle.putBoolean(SCROLL_STATE, this.mStickyScrollPresenter.mScrolled);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mStickyScrollPresenter.mScrolled = bundle.getBoolean(SCROLL_STATE);
            state = bundle.getParcelable(SUPER_STATE);
        }
        super.onRestoreInstanceState(state);
    }
}

