/*
 * Decompiled with CFR 0.152.
 */
package am.leon.swipePackage;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

public class SwipeVerticalTouchListener
implements View.OnTouchListener {
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private View mView;
    private DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private Object mToken;
    private VelocityTracker mVelocityTracker;
    private float mTranslationY;
    private boolean mTiltEnabled = true;

    SwipeVerticalTouchListener(View view, Object token, DismissCallbacks callbacks) {
        ViewConfiguration vc = ViewConfiguration.get((Context)view.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = view.getContext().getResources().getInteger(0x10E0000);
        this.mView = view;
        this.mToken = token;
        this.mCallbacks = callbacks;
    }

    void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        motionEvent.offsetLocation(0.0f, this.mTranslationY);
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                if (this.mCallbacks.canDismiss(this.mToken)) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                return false;
            }
            case 1: {
                boolean dismissRight;
                if (this.mVelocityTracker == null) break;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityY = this.mVelocityTracker.getYVelocity();
                float absVelocityY = Math.abs(velocityY);
                float absVelocityX = Math.abs(this.mVelocityTracker.getXVelocity());
                boolean dismiss = false;
                if (Math.abs(deltaY) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaY > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityY && absVelocityY <= (float)this.mMaxFlingVelocity && absVelocityX < absVelocityY && absVelocityX < absVelocityY && this.mSwiping) {
                    dismiss = velocityY < 0.0f == deltaY < 0.0f;
                    dismissRight = this.mVelocityTracker.getYVelocity() > 0.0f;
                } else {
                    dismissRight = false;
                }
                if (dismiss) {
                    this.mView.animate().translationY(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeVerticalTouchListener.this.performDismiss(dismissRight);
                        }
                    });
                } else if (this.mSwiping) {
                    this.mView.animate().translationY(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationY = 0.0f;
                this.mDownY = 0.0f;
                this.mDownX = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mView.animate().translationY(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationY = 0.0f;
                this.mDownY = 0.0f;
                this.mDownX = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(deltaY) > (float)this.mSlop && Math.abs(deltaX) < Math.abs(deltaY) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = deltaY > 0.0f ? this.mSlop : -this.mSlop;
                    this.mView.getParent().requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mView.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mSwiping) break;
                this.mTranslationY = deltaY;
                this.mView.setTranslationY(deltaY - (float)this.mSwipingSlop);
                this.mView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaY) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(final boolean toRight) {
        final ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        final int originalHeight = this.mView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeVerticalTouchListener.this.mCallbacks.onDismiss(SwipeVerticalTouchListener.this.mView, toRight, SwipeVerticalTouchListener.this.mToken);
                SwipeVerticalTouchListener.this.mView.setAlpha(1.0f);
                SwipeVerticalTouchListener.this.mView.setTranslationY(0.0f);
                lp.height = originalHeight;
                SwipeVerticalTouchListener.this.mView.setLayoutParams(lp);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                lp.height = (Integer)animation.getAnimatedValue();
                SwipeVerticalTouchListener.this.mView.setLayoutParams(lp);
            }
        });
        animator.start();
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(Object var1);

        public void onDismiss(View var1, boolean var2, Object var3);
    }
}

