/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.Objects;

public class Media
implements Parcelable {
    public static final String TYPE_PHOTO = "photo";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_FILE = "file";
    private int id;
    private String path;
    private String type;
    private String title;
    private String description;
    private boolean main;
    public static final Parcelable.Creator<Media> CREATOR = new Parcelable.Creator<Media>(){

        public Media createFromParcel(Parcel in) {
            return new Media(in);
        }

        public Media[] newArray(int size) {
            return new Media[size];
        }
    };

    public Media(String path, String type) {
        this.path = path;
        this.type = type;
    }

    public Media(String path, String title, String type) {
        this.path = path;
        this.title = title;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Media media = (Media)o;
        return this.type.equals(media.type) && Objects.equals(this.title, media.title);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title);
    }

    private Media(Parcel in) {
        this.id = in.readInt();
        this.path = in.readString();
        this.type = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.main = in.readByte() != 0;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeString(this.path);
        dest.writeString(this.type);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeByte((byte)(this.main ? 1 : 0));
    }

    @NonNull
    public String toString() {
        return "Media{id=" + this.id + ", path='" + this.path + '\'' + ", type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", main=" + this.main + '}';
    }
}

