/*
 * Decompiled with CFR 0.152.
 */
package com.github.alturkovic.lock.redis.impl;

import com.github.alturkovic.lock.Lock;
import io.lettuce.core.RedisCommandInterruptedException;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.StringUtils;

public class MultiRedisLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(MultiRedisLock.class);
    private static final String LOCK_SCRIPT = "local msetnx_keys_with_tokens = {}\nfor _, key in ipairs(KEYS) do\n    msetnx_keys_with_tokens[#msetnx_keys_with_tokens + 1] = key\n    msetnx_keys_with_tokens[#msetnx_keys_with_tokens + 1] = ARGV[1]\nend\nlocal keys_successfully_set = redis.call('MSETNX', unpack(msetnx_keys_with_tokens))\nif (keys_successfully_set == 0) then\n    return false\nend\nlocal expiration = tonumber(ARGV[2])\nfor _, key in ipairs(KEYS) do\n    redis.call('PEXPIRE', key, expiration)\nend\nreturn true\n";
    private static final String LOCK_RELEASE_SCRIPT = "for _, key in pairs(KEYS) do\n    if redis.call('GET', key) ~= ARGV[1] then\n        return false\n    end\nend\nredis.call('DEL', unpack(KEYS))\nreturn true\n";
    private static final String LOCK_REFRESH_SCRIPT = "for _, key in pairs(KEYS) do\n    local value = redis.call('GET', key)\n    if (value == nil or value ~= ARGV[1]) then\n        return false\n    end\nend\nfor _, key in pairs(KEYS) do\n    redis.call('PEXPIRE', key, ARGV[2])\nend\nreturn true";
    private final RedisScript<Boolean> lockScript = new DefaultRedisScript("local msetnx_keys_with_tokens = {}\nfor _, key in ipairs(KEYS) do\n    msetnx_keys_with_tokens[#msetnx_keys_with_tokens + 1] = key\n    msetnx_keys_with_tokens[#msetnx_keys_with_tokens + 1] = ARGV[1]\nend\nlocal keys_successfully_set = redis.call('MSETNX', unpack(msetnx_keys_with_tokens))\nif (keys_successfully_set == 0) then\n    return false\nend\nlocal expiration = tonumber(ARGV[2])\nfor _, key in ipairs(KEYS) do\n    redis.call('PEXPIRE', key, expiration)\nend\nreturn true\n", Boolean.class);
    private final RedisScript<Boolean> lockReleaseScript = new DefaultRedisScript("for _, key in pairs(KEYS) do\n    if redis.call('GET', key) ~= ARGV[1] then\n        return false\n    end\nend\nredis.call('DEL', unpack(KEYS))\nreturn true\n", Boolean.class);
    private final RedisScript<Boolean> lockRefreshScript = new DefaultRedisScript("for _, key in pairs(KEYS) do\n    local value = redis.call('GET', key)\n    if (value == nil or value ~= ARGV[1]) then\n        return false\n    end\nend\nfor _, key in pairs(KEYS) do\n    redis.call('PEXPIRE', key, ARGV[2])\nend\nreturn true", Boolean.class);
    private final StringRedisTemplate stringRedisTemplate;
    private final Supplier<String> tokenSupplier;

    public MultiRedisLock(StringRedisTemplate stringRedisTemplate) {
        this(stringRedisTemplate, () -> UUID.randomUUID().toString());
    }

    public String acquire(List<String> keys, String storeId, long expiration) {
        List keysWithStoreIdPrefix = keys.stream().map(key -> storeId + ":" + key).collect(Collectors.toList());
        String token = this.tokenSupplier.get();
        if (StringUtils.isEmpty((Object)token)) {
            throw new IllegalStateException("Cannot lock with empty token");
        }
        boolean locked = (Boolean)this.stringRedisTemplate.execute(this.lockScript, keysWithStoreIdPrefix, new Object[]{token, String.valueOf(expiration)});
        log.debug("Tried to acquire lock for keys {} in store {} with token {}. Locked: {}", new Object[]{keys, storeId, token, locked});
        return locked ? token : null;
    }

    public boolean release(List<String> keys, String storeId, String token) {
        List keysWithStoreIdPrefix = keys.stream().map(key -> storeId + ":" + key).collect(Collectors.toList());
        boolean released = (Boolean)this.stringRedisTemplate.execute(this.lockReleaseScript, keysWithStoreIdPrefix, new Object[]{token});
        if (released) {
            log.debug("Release script deleted the record for keys {} with token {} in store {}", new Object[]{keys, token, storeId});
        } else {
            log.error("Release script failed for keys {} with token {} in store {}", new Object[]{keys, token, storeId});
        }
        return released;
    }

    public boolean refresh(List<String> keys, String storeId, String token, long expiration) {
        List keysWithStoreIdPrefix = keys.stream().map(key -> storeId + ":" + key).collect(Collectors.toList());
        boolean refreshed = false;
        try {
            refreshed = (Boolean)this.stringRedisTemplate.execute(this.lockRefreshScript, keysWithStoreIdPrefix, new Object[]{token, String.valueOf(expiration)});
            if (refreshed) {
                log.debug("Refresh script refreshed the expiration for keys {} with token {} in store {}", new Object[]{keys, token, storeId});
            } else {
                log.debug("Refresh script failed to update expiration for keys {} with token {} in store {}", new Object[]{keys, token, storeId});
            }
        }
        catch (RedisSystemException e) {
            if (e.getCause() != null && e.getCause() instanceof RedisCommandInterruptedException) {
                log.debug("Refresh script thread interrupted to update expiration for keys {} with token {} in store {} with expiration: {}", new Object[]{keys, token, storeId, expiration});
            }
            throw e;
        }
        return refreshed;
    }

    public RedisScript<Boolean> getLockScript() {
        return this.lockScript;
    }

    public RedisScript<Boolean> getLockReleaseScript() {
        return this.lockReleaseScript;
    }

    public RedisScript<Boolean> getLockRefreshScript() {
        return this.lockRefreshScript;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public Supplier<String> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiRedisLock)) {
            return false;
        }
        MultiRedisLock other = (MultiRedisLock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisScript<Boolean> this$lockScript = this.getLockScript();
        RedisScript<Boolean> other$lockScript = other.getLockScript();
        if (this$lockScript == null ? other$lockScript != null : !this$lockScript.equals(other$lockScript)) {
            return false;
        }
        RedisScript<Boolean> this$lockReleaseScript = this.getLockReleaseScript();
        RedisScript<Boolean> other$lockReleaseScript = other.getLockReleaseScript();
        if (this$lockReleaseScript == null ? other$lockReleaseScript != null : !this$lockReleaseScript.equals(other$lockReleaseScript)) {
            return false;
        }
        RedisScript<Boolean> this$lockRefreshScript = this.getLockRefreshScript();
        RedisScript<Boolean> other$lockRefreshScript = other.getLockRefreshScript();
        if (this$lockRefreshScript == null ? other$lockRefreshScript != null : !this$lockRefreshScript.equals(other$lockRefreshScript)) {
            return false;
        }
        StringRedisTemplate this$stringRedisTemplate = this.getStringRedisTemplate();
        StringRedisTemplate other$stringRedisTemplate = other.getStringRedisTemplate();
        if (this$stringRedisTemplate == null ? other$stringRedisTemplate != null : !this$stringRedisTemplate.equals(other$stringRedisTemplate)) {
            return false;
        }
        Supplier<String> this$tokenSupplier = this.getTokenSupplier();
        Supplier<String> other$tokenSupplier = other.getTokenSupplier();
        return !(this$tokenSupplier == null ? other$tokenSupplier != null : !this$tokenSupplier.equals(other$tokenSupplier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiRedisLock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisScript<Boolean> $lockScript = this.getLockScript();
        result = result * 59 + ($lockScript == null ? 43 : $lockScript.hashCode());
        RedisScript<Boolean> $lockReleaseScript = this.getLockReleaseScript();
        result = result * 59 + ($lockReleaseScript == null ? 43 : $lockReleaseScript.hashCode());
        RedisScript<Boolean> $lockRefreshScript = this.getLockRefreshScript();
        result = result * 59 + ($lockRefreshScript == null ? 43 : $lockRefreshScript.hashCode());
        StringRedisTemplate $stringRedisTemplate = this.getStringRedisTemplate();
        result = result * 59 + ($stringRedisTemplate == null ? 43 : $stringRedisTemplate.hashCode());
        Supplier<String> $tokenSupplier = this.getTokenSupplier();
        result = result * 59 + ($tokenSupplier == null ? 43 : $tokenSupplier.hashCode());
        return result;
    }

    public String toString() {
        return "MultiRedisLock(lockScript=" + this.getLockScript() + ", lockReleaseScript=" + this.getLockReleaseScript() + ", lockRefreshScript=" + this.getLockRefreshScript() + ", stringRedisTemplate=" + this.getStringRedisTemplate() + ", tokenSupplier=" + this.getTokenSupplier() + ")";
    }

    public MultiRedisLock(StringRedisTemplate stringRedisTemplate, Supplier<String> tokenSupplier) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.tokenSupplier = tokenSupplier;
    }
}

