/*
 * Decompiled with CFR 0.152.
 */
package abak.tr.com.boxedverticalseekbar;

import abak.tr.com.boxedverticalseekbar.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.BitmapDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import junit.framework.Assert;

public class BoxedVertical
extends View {
    private static final String TAG = BoxedVertical.class.getSimpleName();
    private static final int MAX = 100;
    private static final int MIN = 0;
    private int mMin = 0;
    private int mMax = 100;
    private int mStep = 10;
    private int mCornerRadius = 10;
    private float mTextSize = 26.0f;
    private int mtextBottomPadding = 20;
    private int mPoints;
    private boolean mEnabled = true;
    private boolean mtextEnabled = true;
    private boolean mImageEnabled = false;
    private boolean mTouchDisabled = true;
    private float mProgressSweep = 0.0f;
    private Paint mProgressPaint;
    private Paint mTextPaint;
    private int scrWidth;
    private int scrHeight;
    private OnValuesChangeListener mOnValuesChangeListener;
    private int backgroundColor;
    private int mDefaultValue;
    private Bitmap mDefaultImage;
    private Bitmap mMinImage;
    private Bitmap mMaxImage;
    private Rect dRect = new Rect();
    private boolean firstRun = true;

    public BoxedVertical(Context context) {
        super(context);
        this.init(context, null);
    }

    public BoxedVertical(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        System.out.println("INIT");
        float density = this.getResources().getDisplayMetrics().density;
        int progressColor = ContextCompat.getColor((Context)context, (int)R.color.color_progress);
        this.backgroundColor = ContextCompat.getColor((Context)context, (int)R.color.color_background);
        this.backgroundColor = ContextCompat.getColor((Context)context, (int)R.color.color_background);
        int textColor = ContextCompat.getColor((Context)context, (int)R.color.color_text);
        this.mTextSize = (int)(this.mTextSize * density);
        this.mDefaultValue = this.mMax / 2;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BoxedVertical, 0, 0);
            this.mPoints = a.getInteger(R.styleable.BoxedVertical_points, this.mPoints);
            this.mMax = a.getInteger(R.styleable.BoxedVertical_max, this.mMax);
            this.mMin = a.getInteger(R.styleable.BoxedVertical_min, this.mMin);
            this.mStep = a.getInteger(R.styleable.BoxedVertical_step, this.mStep);
            this.mDefaultValue = a.getInteger(R.styleable.BoxedVertical_defaultValue, this.mDefaultValue);
            this.mCornerRadius = a.getInteger(R.styleable.BoxedVertical_libCornerRadius, this.mCornerRadius);
            this.mtextBottomPadding = a.getInteger(R.styleable.BoxedVertical_textBottomPadding, this.mtextBottomPadding);
            this.mImageEnabled = a.getBoolean(R.styleable.BoxedVertical_imageEnabled, this.mImageEnabled);
            if (this.mImageEnabled) {
                Assert.assertNotNull((String)"When images are enabled, defaultImage can not be null. Please assign a drawable in the layout XML file", (Object)a.getDrawable(R.styleable.BoxedVertical_defaultImage));
                Assert.assertNotNull((String)"When images are enabled, minImage can not be null. Please assign a drawable in the layout XML file", (Object)a.getDrawable(R.styleable.BoxedVertical_minImage));
                Assert.assertNotNull((String)"When images are enabled, maxImage can not be null. Please assign a drawable in the layout XML file", (Object)a.getDrawable(R.styleable.BoxedVertical_maxImage));
                this.mDefaultImage = ((BitmapDrawable)a.getDrawable(R.styleable.BoxedVertical_defaultImage)).getBitmap();
                this.mMinImage = ((BitmapDrawable)a.getDrawable(R.styleable.BoxedVertical_minImage)).getBitmap();
                this.mMaxImage = ((BitmapDrawable)a.getDrawable(R.styleable.BoxedVertical_maxImage)).getBitmap();
            }
            progressColor = a.getColor(R.styleable.BoxedVertical_progressColor, progressColor);
            this.backgroundColor = a.getColor(R.styleable.BoxedVertical_backgroundColor, this.backgroundColor);
            this.mTextSize = (int)a.getDimension(R.styleable.BoxedVertical_textSize, this.mTextSize);
            textColor = a.getColor(R.styleable.BoxedVertical_textColor, textColor);
            this.mEnabled = a.getBoolean(R.styleable.BoxedVertical_enabled, this.mEnabled);
            this.mTouchDisabled = a.getBoolean(R.styleable.BoxedVertical_touchDisabled, this.mTouchDisabled);
            this.mtextEnabled = a.getBoolean(R.styleable.BoxedVertical_textEnabled, this.mtextEnabled);
            this.mPoints = this.mDefaultValue;
            a.recycle();
        }
        this.mPoints = this.mPoints > this.mMax ? this.mMax : this.mPoints;
        this.mPoints = this.mPoints < this.mMin ? this.mMin : this.mPoints;
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setColor(progressColor);
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.scrHeight = context.getResources().getDisplayMetrics().heightPixels;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.scrWidth = BoxedVertical.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        this.scrHeight = BoxedVertical.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.mProgressPaint.setStrokeWidth((float)this.scrWidth);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setAlpha(255);
        canvas.translate(0.0f, 0.0f);
        Path mPath = new Path();
        mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.scrWidth, (float)this.scrHeight), (float)this.mCornerRadius, (float)this.mCornerRadius, Path.Direction.CCW);
        canvas.clipPath(mPath, Region.Op.INTERSECT);
        paint.setColor(this.backgroundColor);
        paint.setAntiAlias(true);
        canvas.drawRect(0.0f, 0.0f, (float)this.scrWidth, (float)this.scrHeight, paint);
        canvas.drawLine((float)(canvas.getWidth() / 2), (float)canvas.getHeight(), (float)(canvas.getWidth() / 2), this.mProgressSweep, this.mProgressPaint);
        if (this.mImageEnabled && this.mDefaultImage != null && this.mMinImage != null && this.mMaxImage != null) {
            if (this.mPoints == this.mMax) {
                this.drawIcon(this.mMaxImage, canvas);
            } else if (this.mPoints == this.mMin) {
                this.drawIcon(this.mMinImage, canvas);
            } else {
                this.drawIcon(this.mDefaultImage, canvas);
            }
        } else if (this.mtextEnabled) {
            String strPoint = String.valueOf(this.mPoints);
            this.drawText(canvas, this.mTextPaint, strPoint);
        }
        if (this.firstRun) {
            this.firstRun = false;
            this.setValue(this.mPoints);
        }
    }

    private void drawText(Canvas canvas, Paint paint, String text) {
        canvas.getClipBounds(this.dRect);
        int cWidth = this.dRect.width();
        paint.setTextAlign(Paint.Align.LEFT);
        paint.getTextBounds(text, 0, text.length(), this.dRect);
        float x = (float)cWidth / 2.0f - (float)this.dRect.width() / 2.0f - (float)this.dRect.left;
        canvas.drawText(text, x, (float)(canvas.getHeight() - this.mtextBottomPadding), paint);
    }

    private void drawIcon(Bitmap bitmap, Canvas canvas) {
        bitmap = this.getResizedBitmap(bitmap, canvas.getWidth() / 2, canvas.getWidth() / 2);
        canvas.drawBitmap(bitmap, null, new RectF((float)(canvas.getWidth() / 2 - bitmap.getWidth() / 2), (float)(canvas.getHeight() - bitmap.getHeight()), (float)(canvas.getWidth() / 3 + bitmap.getWidth()), (float)canvas.getHeight()), null);
    }

    private Bitmap getResizedBitmap(Bitmap bm, int newHeight, int newWidth) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mEnabled) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
            switch (event.getAction()) {
                case 0: {
                    if (this.mOnValuesChangeListener != null) {
                        this.mOnValuesChangeListener.onStartTrackingTouch(this);
                    }
                    if (this.mTouchDisabled) break;
                    this.updateOnTouch(event);
                    break;
                }
                case 2: {
                    this.updateOnTouch(event);
                    break;
                }
                case 1: {
                    if (this.mOnValuesChangeListener != null) {
                        this.mOnValuesChangeListener.onStopTrackingTouch(this);
                    }
                    this.setPressed(false);
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    break;
                }
                case 3: {
                    if (this.mOnValuesChangeListener != null) {
                        this.mOnValuesChangeListener.onStopTrackingTouch(this);
                    }
                    this.setPressed(false);
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
            }
            return true;
        }
        return false;
    }

    private void updateOnTouch(MotionEvent event) {
        this.setPressed(true);
        double mTouch = this.convertTouchEventPoint(event.getY());
        int progress = (int)Math.round(mTouch);
        this.updateProgress(progress);
    }

    private double convertTouchEventPoint(float yPos) {
        if (yPos > (float)(this.scrHeight * 2)) {
            float wReturn = this.scrHeight * 2;
            return wReturn;
        }
        float wReturn = yPos < 0.0f ? 0.0f : yPos;
        return wReturn;
    }

    private void updateProgress(int progress) {
        this.mProgressSweep = progress;
        progress = progress > this.scrHeight ? this.scrHeight : progress;
        progress = progress < 0 ? 0 : progress;
        this.mPoints = progress * (this.mMax - this.mMin) / this.scrHeight + this.mMin;
        this.mPoints = this.mMax + this.mMin - this.mPoints;
        if (this.mPoints != this.mMax && this.mPoints != this.mMin) {
            this.mPoints = this.mPoints - this.mPoints % this.mStep + this.mMin % this.mStep;
        }
        if (this.mOnValuesChangeListener != null) {
            this.mOnValuesChangeListener.onPointsChanged(this, this.mPoints);
        }
        this.invalidate();
    }

    private void updateProgressByValue(int value) {
        this.mPoints = value;
        this.mPoints = this.mPoints > this.mMax ? this.mMax : this.mPoints;
        this.mPoints = this.mPoints < this.mMin ? this.mMin : this.mPoints;
        this.mProgressSweep = (this.mPoints - this.mMin) * this.scrHeight / (this.mMax - this.mMin);
        this.mProgressSweep = (float)this.scrHeight - this.mProgressSweep;
        if (this.mOnValuesChangeListener != null) {
            this.mOnValuesChangeListener.onPointsChanged(this, this.mPoints);
        }
        this.invalidate();
    }

    public void setValue(int points) {
        points = points > this.mMax ? this.mMax : points;
        points = points < this.mMin ? this.mMin : points;
        this.updateProgressByValue(points);
    }

    public int getValue() {
        return this.mPoints;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int mMax) {
        if (mMax <= this.mMin) {
            throw new IllegalArgumentException("Max should not be less than zero");
        }
        this.mMax = mMax;
    }

    public void setCornerRadius(int mRadius) {
        this.mCornerRadius = mRadius;
        this.invalidate();
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public int getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(int mDefaultValue) {
        if (mDefaultValue > this.mMax) {
            throw new IllegalArgumentException("Default value should not be bigger than max value.");
        }
        this.mDefaultValue = mDefaultValue;
    }

    public int getStep() {
        return this.mStep;
    }

    public void setStep(int step) {
        this.mStep = step;
    }

    public boolean isImageEnabled() {
        return this.mImageEnabled;
    }

    public void setImageEnabled(boolean mImageEnabled) {
        this.mImageEnabled = mImageEnabled;
    }

    public void setOnBoxedPointsChangeListener(OnValuesChangeListener onValuesChangeListener) {
        this.mOnValuesChangeListener = onValuesChangeListener;
    }

    public static interface OnValuesChangeListener {
        public void onPointsChanged(BoxedVertical var1, int var2);

        public void onStartTrackingTouch(BoxedVertical var1);

        public void onStopTrackingTouch(BoxedVertical var1);
    }
}

