/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.alorma.timeline.R;
import com.alorma.timeline.painter.Painter;
import com.alorma.timeline.painter.line.LinePainter;
import com.alorma.timeline.painter.point.PointPainter;
import com.alorma.timeline.property.LineColor;
import com.alorma.timeline.property.LineStyle;
import com.alorma.timeline.property.LineWidth;
import com.alorma.timeline.property.PointStyle;
import com.alorma.timeline.property.Property;
import com.alorma.timeline.property.TimelinePosition;
import com.alorma.timeline.property.TimelinePositionOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u000267B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\u0002\b\u0013J\u001f\u0010\u0014\u001a\u00020\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u001a\u0010#\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\bJ\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020.J\u000e\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201J\u001c\u00102\u001a\u00020\u000f\"\u0004\b\u0000\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H305H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/alorma/timeline/TimelineView;", "Landroid/view/View;", "Lcom/alorma/timeline/painter/Painter;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawRect", "Landroid/graphics/Rect;", "linePainter", "pointPainter", "configureLine", "", "block", "Lkotlin/Function1;", "Lcom/alorma/timeline/TimelineView$TimelineLineBuilder;", "Lkotlin/ExtensionFunctionType;", "configurePoint", "Lcom/alorma/timeline/TimelineView$TimelinePointBuilder;", "containsPosition", "", "flagSet", "flag", "Lcom/alorma/timeline/property/TimelinePositionOption;", "draw", "canvas", "Landroid/graphics/Canvas;", "rect", "initProperties", "typedArray", "Landroid/content/res/TypedArray;", "onDraw", "readAttrs", "readPosition", "setLineColor", "lineColor", "Lcom/alorma/timeline/property/LineColor;", "setLineStyle", "lineStyle", "Lcom/alorma/timeline/property/LineStyle;", "setLineWidth", "lineWidth", "Lcom/alorma/timeline/property/LineWidth;", "", "setPointStyle", "pointStyle", "Lcom/alorma/timeline/property/PointStyle;", "updateProperty", "T", "property", "Lcom/alorma/timeline/property/Property;", "TimelineLineBuilder", "TimelinePointBuilder", "timeline_release"})
public final class TimelineView
extends View
implements Painter {
    private final Painter linePainter;
    private final Painter pointPainter;
    private final Rect drawRect;
    private HashMap _$_findViewCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readAttrs(AttributeSet attrs, int defStyleAttr) {
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2;
            AttributeSet it = attributeSet2 = attributeSet;
            boolean bl = false;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TimelineView, defStyleAttr, 0);
            try {
                TypedArray typedArray2 = typedArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)typedArray2, (String)"typedArray");
                this.initProperties(typedArray2);
                this.readPosition(typedArray);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readPosition(TypedArray typedArray) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        int positionFlag = typedArray.getInteger(R.styleable.TimelineView_timeline_pointPosition, ((Number)TimelinePositionOption.POSITION_CENTER.INSTANCE.getValue()).intValue());
        List position = CollectionsKt.listOf((Object[])new TimelinePositionOption[]{TimelinePositionOption.POSITION_CENTER.INSTANCE, TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE, TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE, TimelinePositionOption.POSITION_TOP.INSTANCE, TimelinePositionOption.POSITION_BOTTOM.INSTANCE, TimelinePositionOption.POSITION_START.INSTANCE, TimelinePositionOption.POSITION_END.INSTANCE});
        Iterable iterable = $receiver$iv = (Iterable)position;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TimelinePositionOption it = (TimelinePositionOption)element$iv$iv;
            boolean bl = false;
            if (!this.containsPosition(positionFlag, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List flags = (List)destination$iv$iv;
        TimelinePosition timelinePosition = new TimelinePosition(flags);
        this.updateProperty(timelinePosition);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2;
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            Canvas it = canvas2 = canvas3;
            boolean bl = false;
            it.drawColor(0, PorterDuff.Mode.ADD);
            it.getClipBounds(this.drawRect);
            this.draw(it, this.drawRect);
        }
    }

    @Override
    public void initProperties(@NotNull TypedArray typedArray) {
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        this.linePainter.initProperties(typedArray);
        this.pointPainter.initProperties(typedArray);
    }

    @Override
    public <T> void updateProperty(@NotNull Property<T> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this.linePainter.updateProperty(property);
        this.pointPainter.updateProperty(property);
        this.invalidate();
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.linePainter.draw(canvas, this.drawRect);
        this.pointPainter.draw(canvas, this.drawRect);
    }

    public final void setLineStyle(@NotNull LineStyle lineStyle) {
        Intrinsics.checkParameterIsNotNull((Object)lineStyle, (String)"lineStyle");
        this.linePainter.updateProperty(lineStyle);
        this.invalidate();
    }

    public final void setPointStyle(@NotNull PointStyle pointStyle) {
        Intrinsics.checkParameterIsNotNull((Object)pointStyle, (String)"pointStyle");
        this.pointPainter.updateProperty(pointStyle);
        this.invalidate();
    }

    public final void setLineWidth(float lineWidth) {
        this.setLineWidth(new LineWidth(lineWidth));
    }

    public final void setLineWidth(@NotNull LineWidth lineWidth) {
        Intrinsics.checkParameterIsNotNull((Object)lineWidth, (String)"lineWidth");
        this.linePainter.updateProperty(lineWidth);
        this.invalidate();
    }

    public final void setLineColor(int lineColor) {
        this.setLineColor(new LineColor(lineColor));
    }

    public final void setLineColor(@NotNull LineColor lineColor) {
        Intrinsics.checkParameterIsNotNull((Object)lineColor, (String)"lineColor");
        this.linePainter.updateProperty(lineColor);
        this.invalidate();
    }

    public final void configureLine(@NotNull Function1<? super TimelineLineBuilder, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        TimelineLineBuilder timelineLineBuilder = new TimelineLineBuilder(this.linePainter);
        block.invoke((Object)timelineLineBuilder);
        this.invalidate();
    }

    public final void configurePoint(@NotNull Function1<? super TimelinePointBuilder, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        TimelinePointBuilder timelinePointBuilder = new TimelinePointBuilder(this.pointPainter);
        block.invoke((Object)timelinePointBuilder);
        this.invalidate();
    }

    private final boolean containsPosition(int flagSet, TimelinePositionOption flag) {
        return (flagSet | ((Number)flag.getValue()).intValue()) == flagSet;
    }

    @JvmOverloads
    public TimelineView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.linePainter = new LinePainter(context);
        this.pointPainter = new PointPainter(context);
        this.drawRect = new Rect();
        this.readAttrs(attrs, defStyleAttr);
    }

    @JvmOverloads
    public /* synthetic */ TimelineView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TimelineView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TimelineView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/alorma/timeline/TimelineView$TimelineLineBuilder;", "", "linePainter", "Lcom/alorma/timeline/painter/Painter;", "(Lcom/alorma/timeline/painter/Painter;)V", "setLineColor", "", "lineColor", "Lcom/alorma/timeline/property/LineColor;", "", "setLineStyle", "lineStyle", "Lcom/alorma/timeline/property/LineStyle;", "setLineWidth", "lineWidth", "Lcom/alorma/timeline/property/LineWidth;", "", "timeline_release"})
    public static final class TimelineLineBuilder {
        private final Painter linePainter;

        public final void setLineStyle(@NotNull LineStyle lineStyle) {
            Intrinsics.checkParameterIsNotNull((Object)lineStyle, (String)"lineStyle");
            this.linePainter.updateProperty(lineStyle);
        }

        public final void setLineWidth(float lineWidth) {
            this.setLineWidth(new LineWidth(lineWidth));
        }

        public final void setLineWidth(@NotNull LineWidth lineWidth) {
            Intrinsics.checkParameterIsNotNull((Object)lineWidth, (String)"lineWidth");
            this.linePainter.updateProperty(lineWidth);
        }

        public final void setLineColor(int lineColor) {
            this.setLineColor(new LineColor(lineColor));
        }

        public final void setLineColor(@NotNull LineColor lineColor) {
            Intrinsics.checkParameterIsNotNull((Object)lineColor, (String)"lineColor");
            this.linePainter.updateProperty(lineColor);
        }

        public TimelineLineBuilder(@NotNull Painter linePainter) {
            Intrinsics.checkParameterIsNotNull((Object)linePainter, (String)"linePainter");
            this.linePainter = linePainter;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/alorma/timeline/TimelineView$TimelinePointBuilder;", "", "pointPainter", "Lcom/alorma/timeline/painter/Painter;", "(Lcom/alorma/timeline/painter/Painter;)V", "setPointStyle", "", "pointStyle", "Lcom/alorma/timeline/property/PointStyle;", "timeline_release"})
    public static final class TimelinePointBuilder {
        private final Painter pointPainter;

        public final void setPointStyle(@NotNull PointStyle pointStyle) {
            Intrinsics.checkParameterIsNotNull((Object)pointStyle, (String)"pointStyle");
            this.pointPainter.updateProperty(pointStyle);
        }

        public TimelinePointBuilder(@NotNull Painter pointPainter) {
            Intrinsics.checkParameterIsNotNull((Object)pointPainter, (String)"pointPainter");
            this.pointPainter = pointPainter;
        }
    }
}

