/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import com.alorma.timeline.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lcom/alorma/timeline/AttributesUtils;", "", "()V", "colorPrimary", "", "context", "Landroid/content/Context;", "defaultValue", "getColor", "id", "timeline_release"})
public final class AttributesUtils {
    public static final AttributesUtils INSTANCE;

    public final int colorPrimary(@NotNull Context context, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 21 ? this.getColor(context, 16843827, defaultValue) : this.getColor(context, R.attr.colorPrimary, defaultValue);
    }

    private final int getColor(Context context, int id, int defaultValue) {
        TypedValue value = new TypedValue();
        Resources.Theme theme = context.getTheme();
        if (theme != null && theme.resolveAttribute(id, value, true)) {
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            if (value.type == 3) {
                return context.getResources().getColor(value.resourceId);
            }
        }
        return defaultValue;
    }

    private AttributesUtils() {
    }

    static {
        AttributesUtils attributesUtils;
        INSTANCE = attributesUtils = new AttributesUtils();
    }
}

