/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Size;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.alorma.timeline.AttributesUtils;
import com.alorma.timeline.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class TimelineView
extends ImageView {
    public static final int TYPE_HIDDEN = -1;
    public static final int TYPE_START = 0;
    public static final int TYPE_MIDDLE = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_END = 3;
    public static final int TYPE_DEFAULT = 1;
    public static final int ALIGNMENT_START = -1;
    public static final int ALIGNMENT_MIDDLE = 0;
    public static final int ALIGNMENT_END = 1;
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int STYLE_DASHED = -1;
    public static final int STYLE_LINEAR = 0;
    public static final int STYLE_DEFAULT = 0;
    Bitmap internalBitmap;
    Bitmap internalBitmapCache;
    private int lineStyle;
    private float indicatorSize;
    private float internalPadding;
    private boolean drawInternal;
    private int timelineType;
    private int timelineAlignment;
    private Paint paintLine;
    private Paint paintIndicator;
    private Paint paintInternal;
    private Rect rect;
    private float[] dashEffect;
    private int lineColor;
    private float lineWidth;
    private int indicatorColor;
    private int internalColor;

    public TimelineView(Context context) {
        this(context, null);
    }

    public TimelineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimelineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    @TargetApi(value=21)
    public TimelineView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        this.setLayerType(1, null);
        Resources res = this.getResources();
        TypedArray typedArray = this.getTypedArray(context, attrs, defStyle);
        this.initProperties(context, res, typedArray);
        this.initDrawable(typedArray);
        typedArray.recycle();
        this.initPaints();
        this.initRect();
    }

    private void initPaints() {
        this.initPaintLine();
        this.initPaintIndicator();
        this.initPaintInternal();
    }

    private void initProperties(Context context, Resources res, TypedArray typedArray) {
        this.initLineStyle(typedArray);
        this.initIndicatorSize(res, typedArray);
        this.initDrawInternal(res, typedArray);
        this.initInternalPadding(res, typedArray);
        this.initTimelineType(typedArray);
        this.initTimelineAlignment(typedArray);
        this.initLineWidth(res, typedArray);
        this.initLineColor(context, res, typedArray);
        this.initIndicatorColor(context, res, typedArray);
        this.initInternalColor(context, typedArray);
    }

    private void initInternalColor(Context context, TypedArray typedArray) {
        this.internalColor = this.getInternalColor(context, typedArray);
    }

    private void initIndicatorColor(Context context, Resources res, TypedArray typedArray) {
        this.indicatorColor = this.getIndicatorColor(context, res, typedArray);
    }

    private void initLineWidth(Resources res, TypedArray typedArray) {
        this.lineWidth = this.getLineWidth(res, typedArray);
    }

    private void initLineColor(Context context, Resources res, TypedArray typedArray) {
        this.lineColor = this.getLineColor(context, res, typedArray);
    }

    private float getLineWidth(Resources res, TypedArray typedArray) {
        return typedArray.getDimension(R.styleable.TimelineView_timeline_lineWidth, (float)res.getDimensionPixelOffset(R.dimen.default_lineWidth));
    }

    private int getLineColor(Context context, Resources res, TypedArray typedArray) {
        return typedArray.getColor(R.styleable.TimelineView_timeline_lineColor, AttributesUtils.colorPrimary(context, res.getColor(R.color.colorPrimary)));
    }

    private TypedArray getTypedArray(Context context, AttributeSet attrs, int defStyle) {
        return context.getTheme().obtainStyledAttributes(attrs, R.styleable.TimelineView, defStyle, 0);
    }

    private void initDrawable(TypedArray typedArray) {
        if (!this.isInEditMode()) {
            this.setImageDrawable(typedArray.getDrawable(R.styleable.TimelineView_timeline_internalDrawable));
        }
    }

    private boolean isLineDashed() {
        return this.lineStyle == -1;
    }

    private void initRect() {
        this.rect = new Rect();
    }

    private void initPaintInternal() {
        this.paintInternal = new Paint();
        this.paintInternal.setFlags(1);
        this.paintInternal.setColor(this.internalColor);
        this.paintInternal.setStyle(Paint.Style.FILL);
    }

    private void initPaintIndicator() {
        this.paintIndicator = new Paint();
        this.paintIndicator.setFlags(1);
        this.paintIndicator.setColor(this.indicatorColor);
        this.paintIndicator.setStyle(Paint.Style.FILL);
    }

    private void initPaintLine() {
        this.paintLine = new Paint();
        this.paintLine.setFlags(1);
        this.paintLine.setColor(this.lineColor);
        this.paintLine.setStrokeWidth(this.lineWidth);
        this.paintLine.setStyle(Paint.Style.STROKE);
        this.initDefaultDash();
        if (this.isLineDashed()) {
            this.paintLine.setPathEffect(this.createDashEffect());
        }
    }

    private void initDefaultDash() {
        this.dashEffect = new float[]{25.0f, 20.0f};
    }

    private int getInternalColor(Context context, TypedArray typedArray) {
        return typedArray.getColor(R.styleable.TimelineView_timeline_internalColor, AttributesUtils.windowBackground(context, -1));
    }

    private int getIndicatorColor(Context context, Resources res, TypedArray typedArray) {
        return typedArray.getColor(R.styleable.TimelineView_timeline_indicatorColor, AttributesUtils.colorAccent(context, res.getColor(R.color.colorAccent)));
    }

    private void initTimelineAlignment(TypedArray typedArray) {
        this.timelineAlignment = this.getTimelineAlignment(typedArray.getInt(R.styleable.TimelineView_timeline_alignment, 0));
    }

    private void initTimelineType(TypedArray typedArray) {
        this.timelineType = this.getTimelineType(typedArray.getInt(R.styleable.TimelineView_timeline_type, 1));
    }

    private void initInternalPadding(Resources res, TypedArray typedArray) {
        this.internalPadding = typedArray.getDimension(R.styleable.TimelineView_timeline_internalPadding, (float)res.getDimensionPixelOffset(R.dimen.default_internalPadding));
    }

    private void initDrawInternal(Resources res, TypedArray typedArray) {
        this.drawInternal = typedArray.getBoolean(R.styleable.TimelineView_timeline_drawInternal, res.getBoolean(R.bool.default_drawInternal));
    }

    private void initIndicatorSize(Resources res, TypedArray typedArray) {
        this.indicatorSize = typedArray.getDimension(R.styleable.TimelineView_timeline_indicatorSize, (float)res.getDimensionPixelOffset(R.dimen.default_itemSize));
    }

    private void initLineStyle(TypedArray typedArray) {
        this.lineStyle = this.getTimelineStyle(typedArray.getInt(R.styleable.TimelineView_timeline_lineStyle, 0));
    }

    protected void onDraw(Canvas canvas) {
        canvas.getClipBounds(this.rect);
        this.drawByType(canvas);
        super.onDraw(canvas);
    }

    private void drawByType(Canvas canvas) {
        switch (this.timelineType) {
            case 0: {
                this.drawTypeStart(canvas);
                break;
            }
            case 1: {
                this.drawTypeMiddle(canvas);
                break;
            }
            case 3: {
                this.drawTypeEnd(canvas);
                break;
            }
            case -1: {
                if (!this.hasInternalBitmap()) break;
                this.drawBitmap(canvas, (float)this.rect.centerX() - this.indicatorSize + this.internalPadding, (float)this.rect.centerY() - this.indicatorSize + this.internalPadding, (int)((this.indicatorSize - this.internalPadding) * 2.0f));
                break;
            }
            default: {
                this.drawLine(canvas, this.rect.top, this.rect.bottom);
            }
        }
    }

    private void drawTypeEnd(Canvas canvas) {
        this.drawLine(canvas, this.rect.top, this.rect.centerY());
        this.drawIndicator(canvas, this.paintIndicator, this.rect.centerX(), this.rect.centerY(), this.indicatorSize);
        if (this.isDrawInternal()) {
            this.drawInternal(canvas);
        }
        if (this.hasInternalBitmap()) {
            this.drawBitmap(canvas, (float)this.rect.centerX() - this.indicatorSize + this.internalPadding, (float)this.rect.centerY() - this.indicatorSize + this.internalPadding, (int)((this.indicatorSize - this.internalPadding) * 2.0f));
        }
    }

    private void drawLine(Canvas canvas, int startY, int stopY) {
        canvas.drawLine((float)this.getRect().centerX(), (float)startY, (float)this.getRect().centerX(), (float)stopY, this.getPaintLine());
    }

    private void drawTypeMiddle(Canvas canvas) {
        this.drawLine(canvas, this.rect.top, this.rect.bottom);
        int centerY = this.rect.centerY();
        if (this.timelineAlignment == -1) {
            centerY = (int)((float)this.rect.top + this.indicatorSize);
        } else if (this.timelineAlignment == 1) {
            centerY = (int)((float)this.rect.bottom - this.indicatorSize);
        }
        this.drawIndicator(canvas, this.paintIndicator, this.rect.centerX(), centerY, this.indicatorSize);
        if (this.isDrawInternal()) {
            this.drawInternal(canvas, this.paintInternal, this.rect.centerX(), centerY, this.indicatorSize - this.internalPadding);
        }
        if (this.hasInternalBitmap()) {
            this.drawBitmap(canvas, (float)this.rect.centerX() - this.indicatorSize + this.internalPadding, (float)centerY - this.indicatorSize + this.internalPadding, (int)((this.indicatorSize - this.internalPadding) * 2.0f));
        }
    }

    private boolean hasInternalBitmap() {
        return this.internalBitmap != null;
    }

    private void drawTypeStart(Canvas canvas) {
        this.drawLine(canvas, this.rect.centerY(), this.rect.bottom);
        this.drawIndicator(canvas, this.paintIndicator, this.rect.centerX(), this.rect.centerY(), this.indicatorSize);
        if (this.isDrawInternal()) {
            this.drawInternal(canvas);
        }
        if (this.hasInternalBitmap()) {
            this.drawBitmap(canvas, (float)this.rect.centerX() - this.indicatorSize + this.internalPadding, (float)this.rect.centerY() - this.indicatorSize + this.internalPadding, (int)((this.indicatorSize - this.internalPadding) * 2.0f));
        }
    }

    private void drawInternal(Canvas canvas) {
        this.drawInternal(canvas, this.paintInternal, this.rect.centerX(), this.rect.centerY(), this.indicatorSize - this.internalPadding);
    }

    private int getTimelineType(int value) {
        return value;
    }

    private int getTimelineAlignment(int value) {
        return value;
    }

    private int getTimelineStyle(int value) {
        return value;
    }

    public int getLineColor() {
        return this.paintLine.getColor();
    }

    public void setLineColor(@ColorInt int lineColor) {
        this.paintLine.setColor(lineColor);
        this.invalidate();
    }

    public float getLineWidth() {
        return this.paintLine.getStrokeWidth();
    }

    public void setLineWidth(float lineWidth) {
        this.paintLine.setStrokeWidth(lineWidth);
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.paintIndicator.getColor();
    }

    public void setIndicatorColor(@ColorInt int indicatorColor) {
        this.paintIndicator.setColor(indicatorColor);
        this.invalidate();
    }

    public float getIndicatorSize() {
        return this.indicatorSize;
    }

    public void setIndicatorSize(float indicatorSize) {
        this.indicatorSize = indicatorSize;
        this.invalidate();
        this.requestLayout();
    }

    public int getInternalColor() {
        return this.paintInternal.getColor();
    }

    public void setInternalColor(@ColorInt int internalColor) {
        this.paintInternal.setColor(internalColor);
        this.invalidate();
    }

    public float getInternalPadding() {
        return this.internalPadding;
    }

    public void setInternalPadding(float internalPadding) {
        this.internalPadding = internalPadding;
        this.invalidate();
    }

    public boolean isDrawInternal() {
        return this.drawInternal;
    }

    public void setDrawInternal(boolean drawInternal) {
        this.drawInternal = drawInternal;
        this.invalidate();
    }

    public float[] getDashEffect() {
        return this.dashEffect;
    }

    public void setDashEffect(@Size(value=2L) float[] dashEffect) {
        this.dashEffect = dashEffect;
        if (this.isLineDashed()) {
            this.paintLine.setPathEffect(this.createDashEffect());
        }
        this.invalidate();
    }

    private PathEffect createDashEffect() {
        return new DashPathEffect(this.dashEffect, 1.0f);
    }

    public Paint getPaintLine() {
        return this.paintLine;
    }

    public Paint getPaintIndicator() {
        return this.paintIndicator;
    }

    public Paint getPaintInternal() {
        return this.paintInternal;
    }

    public void setTimelineStyle(int timelineStyle) {
        if (timelineStyle == -1) {
            this.paintLine.setPathEffect(this.createDashEffect());
        } else {
            this.paintLine.setPathEffect(null);
        }
        this.invalidate();
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getTimelineType() {
        return this.timelineType;
    }

    public void setTimelineType(int timelineType) {
        this.timelineType = timelineType;
        this.invalidate();
    }

    public int getTimelineAlignment() {
        return this.timelineAlignment;
    }

    public void setTimelineAlignment(int timelineAlignment) {
        this.timelineAlignment = timelineAlignment;
        this.invalidate();
    }

    public void setImageDrawable(Drawable internalDrawable) {
        this.internalBitmap = this.drawableToBitmap(internalDrawable);
        if (this.internalBitmapCache != null) {
            this.internalBitmapCache.recycle();
            this.internalBitmapCache = null;
        }
        this.invalidate();
    }

    public void setImageBitmap(Bitmap internalBitmap) {
        this.internalBitmap = internalBitmap;
        if (this.internalBitmapCache != null) {
            this.internalBitmapCache.recycle();
            this.internalBitmapCache = null;
        }
        this.invalidate();
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private Rect getRect() {
        return this.rect;
    }

    protected abstract void drawIndicator(Canvas var1, Paint var2, float var3, float var4, float var5);

    protected abstract void drawInternal(Canvas var1, Paint var2, float var3, float var4, float var5);

    protected abstract void drawBitmap(Canvas var1, float var2, float var3, int var4);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineAlignment {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineType {
    }
}

