/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene3d;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.dsl.components.ActivatorComponent;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.scene3d.Cuboid;
import com.almasb.fxgl.scene3d.Model3D;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.Sphere;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/scene3d/DoorComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "()V", "activator", "Lcom/almasb/fxgl/dsl/components/ActivatorComponent;", "frame", "Lcom/almasb/fxgl/scene3d/Model3D;", "getFrame", "()Lcom/almasb/fxgl/scene3d/Model3D;", "handle", "Ljavafx/scene/shape/Sphere;", "getHandle", "()Ljavafx/scene/shape/Sphere;", "openAnimation", "Lcom/almasb/fxgl/animation/Animation;", "getOpenAnimation", "()Lcom/almasb/fxgl/animation/Animation;", "setOpenAnimation", "(Lcom/almasb/fxgl/animation/Animation;)V", "panel", "getPanel", "onAdded", "", "onUpdate", "tpf", "", "fxgl"})
public final class DoorComponent
extends Component {
    private ActivatorComponent activator;
    @NotNull
    private final Model3D frame = new Model3D();
    @NotNull
    private final Model3D panel = new Model3D();
    @NotNull
    private final Sphere handle = new Sphere(0.03);
    @NotNull
    private Animation<?> openAnimation;

    public DoorComponent() {
        Cuboid left = new Cuboid(0.1, 2.0, 0.1);
        Cuboid right = new Cuboid(0.1, 2.0, 0.1);
        Cuboid top = new Cuboid(1.0, 0.1, 0.1);
        left.setTranslateX(-0.45);
        right.setTranslateX(0.45);
        top.setTranslateY(-1.0);
        Object[] objectArray = new Node[]{(Node)left, (Node)right, (Node)top};
        this.frame.getChildren().addAll(objectArray);
        Cuboid main = new Cuboid(0.8, 1.93, 0.05);
        this.handle.setTranslateX(main.getWidth() * 0.45);
        this.handle.setTranslateZ(-this.handle.getRadius());
        this.panel.setTranslateY(0.02);
        Node[] nodeArray = new Node[]{(Node)main, (Node)this.handle};
        this.panel.getChildren().addAll((Object[])nodeArray);
        AnimationBuilder animationBuilder = FXGLForKtKt.animationBuilder();
        nodeArray = Duration.seconds((double)2.5);
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"seconds(2.5)");
        AnimationBuilder animationBuilder2 = animationBuilder.duration((Duration)nodeArray);
        nodeArray = new Node[]{(Node)this.panel};
        this.openAnimation = animationBuilder2.rotate(nodeArray).origin(new Point3D(-main.getWidth() / (double)2, 0.0, 0.0)).from(new Point3D(0.0, 0.0, 0.0)).to(new Point3D(0.0, 90.0, 0.0)).build();
    }

    @NotNull
    public final Model3D getFrame() {
        return this.frame;
    }

    @NotNull
    public final Model3D getPanel() {
        return this.panel;
    }

    @NotNull
    public final Sphere getHandle() {
        return this.handle;
    }

    @NotNull
    public final Animation<?> getOpenAnimation() {
        return this.openAnimation;
    }

    public final void setOpenAnimation(@NotNull Animation<?> animation) {
        Intrinsics.checkNotNullParameter(animation, (String)"<set-?>");
        this.openAnimation = animation;
    }

    public void onAdded() {
        ViewComponent viewComponent = this.entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        ViewComponent.addChild$default((ViewComponent)viewComponent, (Node)((Node)this.frame), (boolean)false, (int)2, null);
        viewComponent = this.entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        ViewComponent.addChild$default((ViewComponent)viewComponent, (Node)((Node)this.panel), (boolean)false, (int)2, null);
        ActivatorComponent activatorComponent = this.activator;
        if (activatorComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activator");
            activatorComponent = null;
        }
        activatorComponent.valueProperty().addListener((arg_0, arg_1, arg_2) -> DoorComponent.onAdded$lambda-0(this, arg_0, arg_1, arg_2));
    }

    public void onUpdate(double tpf) {
        this.openAnimation.onUpdate(tpf);
    }

    private static final void onAdded$lambda-0(DoorComponent this$0, ObservableValue $noName_0, Boolean wasOpen, Boolean isOpen) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isOpen, (String)"isOpen");
        if (isOpen.booleanValue()) {
            this$0.openAnimation.stop();
            this$0.openAnimation.start();
        } else {
            this$0.openAnimation.stop();
            this$0.openAnimation.startReverse();
        }
    }
}

