/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.component.Component;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0006\u0010)\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0011R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/dsl/components/RandomMoveComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "bounds", "Ljavafx/geometry/Rectangle2D;", "moveSpeed", "", "tx", "(Ljavafx/geometry/Rectangle2D;DD)V", "angleAdjustRate", "getBounds", "()Ljavafx/geometry/Rectangle2D;", "setBounds", "(Ljavafx/geometry/Rectangle2D;)V", "directionAngle", "getDirectionAngle", "()D", "setDirectionAngle", "(D)V", "isRotating", "", "()Z", "setRotating", "(Z)V", "getMoveSpeed", "setMoveSpeed", "rotationSpeed", "", "getTx", "setTx", "velocity", "Lcom/almasb/fxgl/core/math/Vec2;", "getVelocity", "()Lcom/almasb/fxgl/core/math/Vec2;", "adjustAngle", "", "tpf", "checkBounds", "isComponentInjectionRequired", "move", "onUpdate", "rotate", "withoutRotation", "fxgl"})
public final class RandomMoveComponent
extends Component {
    @NotNull
    private Rectangle2D bounds;
    private double moveSpeed;
    private double tx;
    private final double angleAdjustRate;
    private boolean isRotating;
    @NotNull
    private final Vec2 velocity;
    private double directionAngle;
    private final int rotationSpeed;

    @JvmOverloads
    public RandomMoveComponent(@NotNull Rectangle2D bounds, double moveSpeed, double tx) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.bounds = bounds;
        this.moveSpeed = moveSpeed;
        this.tx = tx;
        this.angleAdjustRate = FXGLForKtKt.random(0.0, 0.5);
        this.isRotating = true;
        this.velocity = new Vec2();
        this.directionAngle = FXGLMath.toDegrees((double)((double)FXGLForKtKt.random(-1, 1) * (Math.PI * 2)));
        this.rotationSpeed = FXGLForKtKt.random(-100, 100);
    }

    public /* synthetic */ RandomMoveComponent(Rectangle2D rectangle2D, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = FXGLForKtKt.random(100, 10000);
        }
        this(rectangle2D, d, d2);
    }

    @NotNull
    public final Rectangle2D getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull Rectangle2D rectangle2D) {
        Intrinsics.checkNotNullParameter((Object)rectangle2D, (String)"<set-?>");
        this.bounds = rectangle2D;
    }

    public final double getMoveSpeed() {
        return this.moveSpeed;
    }

    public final void setMoveSpeed(double d) {
        this.moveSpeed = d;
    }

    public final double getTx() {
        return this.tx;
    }

    public final void setTx(double d) {
        this.tx = d;
    }

    public final boolean isRotating() {
        return this.isRotating;
    }

    public final void setRotating(boolean bl) {
        this.isRotating = bl;
    }

    @NotNull
    public final Vec2 getVelocity() {
        return this.velocity;
    }

    public final double getDirectionAngle() {
        return this.directionAngle;
    }

    public final void setDirectionAngle(double d) {
        this.directionAngle = d;
    }

    public void onUpdate(double tpf) {
        this.adjustAngle(tpf);
        this.move(tpf);
        if (this.isRotating) {
            this.rotate(tpf);
        }
        this.tx += tpf;
        this.checkBounds();
    }

    private final void adjustAngle(double tpf) {
        if (FXGLMath.randomBoolean((double)this.angleAdjustRate)) {
            this.directionAngle += FXGLMath.toDegrees((double)(FXGLMath.noise1D((double)this.tx) - 0.5));
        }
    }

    private final void move(double tpf) {
        Vec2 directionVector = Vec2.fromAngle((double)this.directionAngle).mulLocal(this.moveSpeed);
        this.velocity.addLocal(directionVector).mulLocal(tpf);
        this.entity.translate(this.velocity);
    }

    private final void checkBounds() {
        if (this.entity.getX() < this.bounds.getMinX() || this.entity.getY() < this.bounds.getMinY() || this.entity.getRightX() >= this.bounds.getMaxX() || this.entity.getBottomY() >= this.bounds.getMaxY()) {
            Point2D newDirectionVector = new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / (double)2, (this.bounds.getMinY() + this.bounds.getMaxY()) / (double)2).subtract(this.entity.getCenter());
            double angle = FXGLMath.toDegrees((double)Math.atan(newDirectionVector.getY() / newDirectionVector.getX()));
            this.directionAngle = newDirectionVector.getX() > 0.0 ? angle : (double)180 + angle;
        }
    }

    private final void rotate(double tpf) {
        this.entity.rotateBy((double)this.rotationSpeed * tpf);
    }

    @NotNull
    public final RandomMoveComponent withoutRotation() {
        RandomMoveComponent randomMoveComponent;
        RandomMoveComponent it = randomMoveComponent = this;
        boolean bl = false;
        this.setRotating(false);
        return randomMoveComponent;
    }

    public boolean isComponentInjectionRequired() {
        return false;
    }

    @JvmOverloads
    public RandomMoveComponent(@NotNull Rectangle2D bounds, double moveSpeed) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this(bounds, moveSpeed, 0.0, 4, null);
    }
}

