/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene3d.obj;

import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.scene3d.Model3D;
import com.almasb.fxgl.scene3d.Model3DLoader;
import com.almasb.fxgl.scene3d.obj.MtlData;
import com.almasb.fxgl.scene3d.obj.ObjData;
import com.almasb.fxgl.scene3d.obj.ObjGroup;
import com.almasb.fxgl.scene3d.obj.ObjModelLoader;
import com.almasb.fxgl.scene3d.obj.SubGroup;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableFloatArray;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.shape.VertexFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/scene3d/obj/ObjModelLoader;", "Lcom/almasb/fxgl/scene3d/Model3DLoader;", "()V", "load", "Lcom/almasb/fxgl/scene3d/Model3D;", "url", "Ljava/net/URL;", "Companion", "fxgl"})
public final class ObjModelLoader
implements Model3DLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LinkedHashMap<Function1<String, Boolean>, Function2<List<String>, ObjData, Unit>> objParsers;
    @NotNull
    private static final LinkedHashMap<Function1<String, Boolean>, Function2<List<String>, MtlData, Unit>> mtlParsers;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Model3D load(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            ObjData data = ObjModelLoader.Companion.loadObjData(url);
            Model3D modelRoot = new Model3D();
            Iterable $this$forEach$iv = data.getGroups();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjGroup it = (ObjGroup)element$iv;
                boolean bl = false;
                Model3D groupRoot = new Model3D();
                Object object = groupRoot.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupRoot.properties");
                object = (Map)object;
                String string = "name";
                String string2 = it.getName();
                boolean bl2 = false;
                object.put(string, string2);
                Iterable $this$forEach$iv2 = it.getSubGroups();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    int n;
                    Collection<Float> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    SubGroup it2 = (SubGroup)element$iv2;
                    boolean bl3 = false;
                    if (it2.getFaces().isEmpty()) continue;
                    TriangleMesh mesh = new TriangleMesh(VertexFormat.POINT_NORMAL_TEXCOORD);
                    Object object2 = data.getVertices();
                    ObservableFloatArray observableFloatArray = mesh.getPoints();
                    boolean $i$f$map = false;
                    void var21_25 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        float f = ((Number)item$iv$iv).floatValue();
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        Float f2 = Float.valueOf((float)(it3 * 0.05f));
                        collection.add(f2);
                    }
                    collection = (List)destination$iv$iv;
                    Object object3 = CollectionsKt.toFloatArray((Collection)collection);
                    observableFloatArray.addAll(Arrays.copyOf(object3, ((float[])object3).length));
                    if (data.getVertexTextures().isEmpty()) {
                        int n2 = 0;
                        object2 = new float[2];
                        observableFloatArray = mesh.getTexCoords();
                        while (n2 < 2) {
                            n = n2++;
                            object2[n] = 0.0f;
                        }
                        observableFloatArray.addAll((float[])object2);
                    } else {
                        object3 = CollectionsKt.toFloatArray((Collection)data.getVertexTextures());
                        mesh.getTexCoords().addAll(Arrays.copyOf(object3, ((float[])object3).length));
                    }
                    if (data.getVertexNormals().isEmpty()) {
                        int n3 = 0;
                        object2 = new float[3];
                        observableFloatArray = mesh.getNormals();
                        while (n3 < 3) {
                            n = n3++;
                            object2[n] = 0.0f;
                        }
                        observableFloatArray.addAll((float[])object2);
                    } else {
                        float[] fArray = CollectionsKt.toFloatArray((Collection)data.getVertexNormals());
                        mesh.getNormals().addAll(Arrays.copyOf(fArray, fArray.length));
                    }
                    object3 = CollectionsKt.toIntArray((Collection)it2.getFaces());
                    mesh.getFaces().addAll(Arrays.copyOf((int[])object3, ((float[])object3).length));
                    object3 = it2.getSmoothingGroups();
                    boolean bl5 = false;
                    if (!object3.isEmpty()) {
                        object3 = CollectionsKt.toIntArray((Collection)it2.getSmoothingGroups());
                        mesh.getFaceSmoothingGroups().addAll(Arrays.copyOf((int[])object3, ((float[])object3).length));
                    }
                    MeshView view2 = new MeshView((Mesh)mesh);
                    view2.setMaterial(it2.getMaterial());
                    view2.setCullFace(CullFace.NONE);
                    groupRoot.addMeshView(view2);
                }
                modelRoot.addModel(groupRoot);
            }
            return modelRoot;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Load failed for URL: " + url + " Error: " + e);
        }
    }

    static {
        boolean bl = false;
        objParsers = new LinkedHashMap();
        bl = false;
        mtlParsers = new LinkedHashMap();
        Map map = objParsers;
        Lambda lambda = Companion.1.INSTANCE;
        Object object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseGroup((Companion)this.receiver, p0, p1);
            }
        };
        boolean bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.3.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseSmoothing((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.5.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertexTextures((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.7.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertexNormals((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.9.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertices((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.11.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseFaces((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.13.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseMaterialLib((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = objParsers;
        lambda = Companion.15.INSTANCE;
        object = new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull ObjData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseUseMaterial((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.17.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseNewMaterial((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.19.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorAmbient((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.21.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorDiffuse((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.23.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorSpecular((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.25.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseSpecularPower((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
        map = mtlParsers;
        lambda = Companion.27.INSTANCE;
        object = new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p0, @NotNull MtlData p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseDiffuseMap((Companion)this.receiver, p0, p1);
            }
        };
        bl2 = false;
        map.put(lambda, object);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\u000f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u001226\u0010\u0013\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u000b0\b0\u00142\u0006\u0010\u0015\u001a\u0002H\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u001d\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010 \u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010!\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\"\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010#\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010$\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010%\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010&\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010'\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010(\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010)\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0012\u0010*\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\t*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\t*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0012\u0010/\u001a\u000200*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002Rr\u0010\u0003\u001af\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\u0004j2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\r\u001af\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\b0\u0004j2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/almasb/fxgl/scene3d/obj/ObjModelLoader$Companion;", "", "()V", "mtlParsers", "Ljava/util/LinkedHashMap;", "Lkotlin/Function1;", "", "", "Lkotlin/Function2;", "", "Lcom/almasb/fxgl/scene3d/obj/MtlData;", "", "Lkotlin/collections/LinkedHashMap;", "objParsers", "Lcom/almasb/fxgl/scene3d/obj/ObjData;", "load", "T", "url", "Ljava/net/URL;", "parsers", "", "data", "(Ljava/net/URL;Ljava/util/Map;Ljava/lang/Object;)V", "loadMtlData", "loadObjData", "parseColorAmbient", "tokens", "parseColorDiffuse", "parseColorSpecular", "parseDiffuseMap", "parseFaceVertex", "token", "parseFaces", "parseGroup", "parseMaterialLib", "parseNewMaterial", "parseSmoothing", "parseSpecularPower", "parseUseMaterial", "parseVertexNormals", "parseVertexTextures", "parseVertices", "toColor", "Ljavafx/scene/paint/Color;", "toFloats2", "", "toFloats3", "toSmoothingGroup", "", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        private final void parseGroup(List<String> tokens, ObjData data) {
            String groupName = tokens.isEmpty() ? "default" : tokens.get(0);
            ObjData objData = data;
            Collection collection = objData.getGroups();
            ObjGroup objGroup = new ObjGroup(groupName);
            boolean bl = false;
            collection.add(objGroup);
        }

        private final void parseSmoothing(List<String> tokens, ObjData data) {
            data.getCurrentGroup().getCurrentSubGroup().setSmoothingGroup(this.toSmoothingGroup(tokens));
        }

        private final void parseVertexTextures(List<String> tokens, ObjData data) {
            ObjData objData = data;
            Collection collection = objData.getVertexTextures();
            Iterable iterable = this.toFloats2(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        private final void parseVertexNormals(List<String> tokens, ObjData data) {
            ObjData objData = data;
            Collection collection = objData.getVertexNormals();
            Iterable iterable = this.toFloats3(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        private final void parseVertices(List<String> tokens, ObjData data) {
            ObjData objData = data;
            Collection collection = objData.getVertices();
            Iterable iterable = this.toFloats3(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        private final void parseFaces(List<String> tokens, ObjData data) {
            if (tokens.size() > 3) {
                int n = 2;
                int n2 = tokens.size();
                if (n < n2) {
                    do {
                        int i = n++;
                        this.parseFaceVertex(tokens.get(0), data);
                        this.parseFaceVertex(tokens.get(i - 1), data);
                        this.parseFaceVertex(tokens.get(i), data);
                    } while (n < n2);
                }
            } else {
                Iterable $this$forEach$iv = tokens;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String token = (String)element$iv;
                    boolean bl = false;
                    Companion.parseFaceVertex(token, data);
                }
            }
        }

        private final void parseFaceVertex(String token, ObjData data) {
            String[] stringArray = new String[]{"/"};
            List faceVertex = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int n = faceVertex.size();
            switch (n) {
                case 1: {
                    SubGroup subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    Collection collection = subGroup.getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    break;
                }
                case 2: {
                    SubGroup subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    Collection collection = subGroup.getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = (String)faceVertex.get(1);
                    bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    break;
                }
                case 3: {
                    SubGroup subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    Collection collection = subGroup.getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = (String)faceVertex.get(2);
                    bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    subGroup = data.getCurrentGroup().getCurrentSubGroup();
                    collection = subGroup.getFaces();
                    object = StringsKt.toIntOrNull((String)((String)faceVertex.get(1)));
                    object = (object == null ? 1 : (Integer)object) - 1;
                    bl = false;
                    collection.add(object);
                }
            }
        }

        private final void parseMaterialLib(List<String> tokens, ObjData data) {
            String fileName = tokens.get(0);
            StringBuilder stringBuilder = new StringBuilder();
            String string = data.getUrl().toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.url.toExternalForm()");
            URL mtlURL = new URL(stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (char)'/', null, (int)2, null)).append('/').append(fileName).toString());
            MtlData mtlData = this.loadMtlData(mtlURL);
            ObjData objData = data;
            Map map = objData.getMaterials();
            Map map2 = mtlData.getMaterials();
            boolean bl = false;
            map.putAll(map2);
            objData = data;
            map = objData.getAmbientColors();
            map2 = mtlData.getAmbientColors();
            bl = false;
            map.putAll(map2);
        }

        private final void parseUseMaterial(List<String> tokens, ObjData data) {
            ObjGroup objGroup = data.getCurrentGroup();
            Collection collection = objGroup.getSubGroups();
            SubGroup subGroup = new SubGroup();
            boolean bl = false;
            collection.add(subGroup);
            objGroup = data.getMaterials().get(tokens.get(0));
            if (objGroup == null) {
                throw new RuntimeException("Material with name " + tokens.get(0) + " not found");
            }
            data.getCurrentGroup().getCurrentSubGroup().setMaterial((Material)objGroup);
            data.getCurrentGroup().getCurrentSubGroup().setAmbientColor(data.getAmbientColors().get(data.getCurrentGroup().getCurrentSubGroup().getMaterial()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Float> toFloats2(List<String> $this$toFloats2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)$this$toFloats2, (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                Float f = Float.valueOf(Float.parseFloat((String)var11_11));
                collection.add(f);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Float> toFloats3(List<String> $this$toFloats3) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)$this$toFloats3, (int)3);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                Float f = Float.valueOf(Float.parseFloat((String)var11_11));
                collection.add(f);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Color toColor(List<String> $this$toColor) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.toFloats3($this$toColor);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Double d = (double)it > 1.0 ? 1.0 : (double)it;
                collection.add(d);
            }
            List rgb = (List)destination$iv$iv;
            Color color = Color.color((double)((Number)rgb.get(0)).doubleValue(), (double)((Number)rgb.get(1)).doubleValue(), (double)((Number)rgb.get(2)).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color(rgb[0], rgb[1], rgb[2])");
            return color;
        }

        private final int toSmoothingGroup(List<String> $this$toSmoothingGroup) {
            int n;
            if (Intrinsics.areEqual((Object)$this$toSmoothingGroup.get(0), (Object)"off")) {
                n = 0;
            } else {
                String string = $this$toSmoothingGroup.get(0);
                boolean bl = false;
                n = Integer.parseInt(string);
            }
            return n;
        }

        private final void parseNewMaterial(List<String> tokens, MtlData data) {
            data.setCurrentMaterial(new PhongMaterial());
            Map map = data.getMaterials();
            String string = tokens.get(0);
            PhongMaterial phongMaterial = data.getCurrentMaterial();
            boolean bl = false;
            map.put(string, phongMaterial);
        }

        private final void parseColorAmbient(List<String> tokens, MtlData data) {
            Map map = data.getAmbientColors();
            PhongMaterial phongMaterial = data.getCurrentMaterial();
            Color color = this.toColor(tokens);
            boolean bl = false;
            map.put(phongMaterial, color);
        }

        private final void parseColorDiffuse(List<String> tokens, MtlData data) {
            data.getCurrentMaterial().setDiffuseColor(this.toColor(tokens));
        }

        private final void parseColorSpecular(List<String> tokens, MtlData data) {
            data.getCurrentMaterial().setSpecularColor(this.toColor(tokens));
        }

        private final void parseSpecularPower(List<String> tokens, MtlData data) {
            String string = tokens.get(0);
            boolean bl = false;
            data.getCurrentMaterial().setSpecularPower(Double.parseDouble(string));
        }

        private final void parseDiffuseMap(List<String> tokens, MtlData data) {
            String string = data.getUrl().toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.url.toExternalForm()");
            String ext = Intrinsics.stringPlus((String)StringsKt.substringBeforeLast$default((String)string, (String)"/", null, (int)2, null), (Object)"/");
            data.getCurrentMaterial().setDiffuseMap(FXGL.Companion.getAssetLoader().loadImage(new URL(Intrinsics.stringPlus((String)ext, (Object)tokens.get(0)))));
        }

        private final ObjData loadObjData(URL url) {
            ObjData data = new ObjData(url);
            this.load(url, objParsers, data);
            return data;
        }

        private final MtlData loadMtlData(URL url) {
            MtlData data = new MtlData(url);
            this.load(url, mtlParsers, data);
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final <T> void load(URL url, Map<Function1<String, Boolean>, ? extends Function2<? super List<String>, ? super T, Unit>> parsers, T data) {
            void $this$useLines$iv;
            Closeable closeable = url.openStream();
            Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"url.openStream()");
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = closeable;
            int n = 0;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            n = 8192;
            boolean bl2 = false;
            closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
            boolean $i$f$useLines = false;
            Closeable closeable3 = $this$useLines$iv;
            int n2 = 8192;
            n = 0;
            closeable3 = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n2);
            n2 = 0;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable3;
                boolean bl3 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                block5: for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl5 = false;
                    Object object = line;
                    boolean bl6 = false;
                    String string = object;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String lineTrimmed = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    Object object2 = parsers;
                    boolean bl7 = false;
                    object = object2.entrySet().iterator();
                    while (object.hasNext()) {
                        Object object3 = object2 = (Map.Entry)object.next();
                        boolean bl8 = false;
                        Function1 condition = (Function1)object3.getKey();
                        Object object4 = object2;
                        boolean bl9 = false;
                        Function2 action = (Function2)object4.getValue();
                        if (!((Boolean)condition.invoke((Object)lineTrimmed)).booleanValue()) continue;
                        CharSequence charSequence = lineTrimmed;
                        String string2 = " +";
                        int n3 = 0;
                        string2 = new Regex(string2);
                        n3 = 0;
                        boolean bl10 = false;
                        List tokens = CollectionsKt.drop((Iterable)string2.split(charSequence, n3), (int)1);
                        action.invoke((Object)tokens, data);
                        continue block5;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$parseGroup(Companion $this, List tokens, ObjData data) {
            $this.parseGroup(tokens, data);
        }

        public static final /* synthetic */ void access$parseSmoothing(Companion $this, List tokens, ObjData data) {
            $this.parseSmoothing(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertexTextures(Companion $this, List tokens, ObjData data) {
            $this.parseVertexTextures(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertexNormals(Companion $this, List tokens, ObjData data) {
            $this.parseVertexNormals(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertices(Companion $this, List tokens, ObjData data) {
            $this.parseVertices(tokens, data);
        }

        public static final /* synthetic */ void access$parseFaces(Companion $this, List tokens, ObjData data) {
            $this.parseFaces(tokens, data);
        }

        public static final /* synthetic */ void access$parseMaterialLib(Companion $this, List tokens, ObjData data) {
            $this.parseMaterialLib(tokens, data);
        }

        public static final /* synthetic */ void access$parseUseMaterial(Companion $this, List tokens, ObjData data) {
            $this.parseUseMaterial(tokens, data);
        }

        public static final /* synthetic */ void access$parseNewMaterial(Companion $this, List tokens, MtlData data) {
            $this.parseNewMaterial(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorAmbient(Companion $this, List tokens, MtlData data) {
            $this.parseColorAmbient(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorDiffuse(Companion $this, List tokens, MtlData data) {
            $this.parseColorDiffuse(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorSpecular(Companion $this, List tokens, MtlData data) {
            $this.parseColorSpecular(tokens, data);
        }

        public static final /* synthetic */ void access$parseSpecularPower(Companion $this, List tokens, MtlData data) {
            $this.parseSpecularPower(tokens, data);
        }

        public static final /* synthetic */ void access$parseDiffuseMap(Companion $this, List tokens, MtlData data) {
            $this.parseDiffuseMap(tokens, data);
        }
    }
}

