/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.scene.Camera3D;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.input.MouseEvent;
import javafx.scene.robot.Robot;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0002abB1\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u000202J\u001f\u0010B\u001a\u00020:2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u0002020D\"\u000202\u00a2\u0006\u0002\u0010EJ\u0006\u0010F\u001a\u00020:J\u0006\u0010G\u001a\u00020:J\u0010\u0010H\u001a\u00020:2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020:2\u0006\u0010I\u001a\u00020JH\u0002J\u0018\u0010L\u001a\u00020:2\u0006\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020&H\u0002J\u0018\u0010O\u001a\u00020P2\u0006\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020&H\u0002J\u0010\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020\u0015H\u0016J\u0010\u0010S\u001a\u00020:2\u0006\u0010R\u001a\u00020\u0015H\u0016J\u0010\u0010T\u001a\u00020:2\u0006\u0010U\u001a\u00020&H\u0014J\u000e\u0010V\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u0010W\u001a\u00020:2\u0006\u0010>\u001a\u00020?J\u000e\u0010X\u001a\u00020\u000b2\u0006\u0010Y\u001a\u000202J\u001f\u0010Z\u001a\u00020:2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u0002020D\"\u000202\u00a2\u0006\u0002\u0010EJ\r\u0010[\u001a\u00020:H\u0000\u00a2\u0006\u0002\b\\J\u000e\u0010]\u001a\u00020:2\u0006\u0010^\u001a\u00020\u000bJ\b\u0010_\u001a\u00020:H\u0002J\u000e\u0010`\u001a\u00020:2\u0006\u0010U\u001a\u00020&R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u001a\u0010\"\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010(\u001a\u0012 **\b\u0018\u00010)R\u00020\u00000)R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0012\u001a\u0004\b+\u0010,R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\b\u0012\u0004\u0012\u000202018G\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020807X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene;", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "is3D", "", "(IILcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;Z)V", "camera3D", "Lcom/almasb/fxgl/app/scene/Camera3D;", "getCamera3D", "()Lcom/almasb/fxgl/app/scene/Camera3D;", "camera3D$delegate", "Lkotlin/Lazy;", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "gameRoot", "Ljavafx/scene/Group;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "value", "isFPSCamera", "()Z", "setFPSCamera", "(Z)V", "isMouseGrabbed", "setMouseGrabbed", "isSingleStep", "setSingleStep", "isZSortingNeeded", "lastMouseX", "", "lastMouseY", "mouseWarper", "Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "kotlin.jvm.PlatformType", "getMouseWarper", "()Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "mouseWarper$delegate", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUINodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "zChangeListener", "Ljavafx/beans/value/ChangeListener;", "", "addGameView", "", "view", "Lcom/almasb/fxgl/app/scene/GameView;", "addUI", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "h", "make3DSubScene", "Ljavafx/scene/SubScene;", "onEntityAdded", "entity", "onEntityRemoved", "onUpdate", "tpf", "removeGameView", "removeUI", "removeUINode", "n", "removeUINodes", "reset", "reset$fxgl", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "MouseWarper", "fxgl"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private final boolean is3D;
    @NotNull
    private final Group gameRoot;
    @NotNull
    private final Group uiRoot;
    @NotNull
    private final ArrayList<Entity> entities;
    private boolean isZSortingNeeded;
    @NotNull
    private final ChangeListener<Number> zChangeListener;
    private boolean isSingleStep;
    @NotNull
    private final Lazy camera3D$delegate;
    @NotNull
    private final Lazy mouseWarper$delegate;
    private boolean isMouseGrabbed;
    private boolean isFPSCamera;
    private double lastMouseX;
    private double lastMouseY;
    @NotNull
    private static final Logger log = Logger.Companion.get(GameScene.class);

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld, boolean is3D) {
        Intrinsics.checkNotNullParameter((Object)gameWorld, (String)"gameWorld");
        Intrinsics.checkNotNullParameter((Object)physicsWorld, (String)"physicsWorld");
        super(width, height);
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.is3D = is3D;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.zChangeListener = (arg_0, arg_1, arg_2) -> GameScene.zChangeListener$lambda-0(this, arg_0, arg_1, arg_2);
        this.camera3D$delegate = LazyKt.lazy((Function0)camera3D.2.INSTANCE);
        this.mouseWarper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MouseWarper>(this){
            final /* synthetic */ GameScene this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MouseWarper invoke() {
                return (MouseWarper)Async.INSTANCE.startAsyncFX(() -> mouseWarper.2.invoke$lambda-0(this.this$0)).await();
            }

            private static final MouseWarper invoke$lambda-0(GameScene this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                return this$0.new MouseWarper(this$0.getWindow());
            }
        }));
        Node[] nodeArray = new Node[]{this.is3D ? (Node)this.make3DSubScene(width, height) : (Node)this.gameRoot, (Node)this.uiRoot};
        this.getContentRoot().getChildren().addAll((Object[])nodeArray);
        if (this.is3D) {
            Input input = this.getInput();
            nodeArray = MouseEvent.MOUSE_MOVED;
            Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"MOUSE_MOVED");
            input.addEventHandler((EventType)nodeArray, arg_0 -> GameScene._init_$lambda-2(this, arg_0));
        }
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add((Object)this.getViewport().getCamera$fxgl().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + 'x' + height);
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
    }

    public /* synthetic */ GameScene(int n, int n2, GameWorld gameWorld, PhysicsWorld physicsWorld, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, gameWorld, physicsWorld, bl);
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    @JvmName(name="getUINodes")
    @NotNull
    public final ObservableList<Node> getUINodes() {
        ObservableList observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"uiRoot.childrenUnmodifiable");
        return observableList;
    }

    public final boolean isSingleStep() {
        return this.isSingleStep;
    }

    public final void setSingleStep(boolean bl) {
        this.isSingleStep = bl;
    }

    @NotNull
    public final Camera3D getCamera3D() {
        Lazy lazy = this.camera3D$delegate;
        boolean bl = false;
        return (Camera3D)lazy.getValue();
    }

    private final MouseWarper getMouseWarper() {
        Lazy lazy = this.mouseWarper$delegate;
        boolean bl = false;
        return (MouseWarper)lazy.getValue();
    }

    public final boolean isMouseGrabbed() {
        return this.isMouseGrabbed;
    }

    public final void setMouseGrabbed(boolean bl) {
        this.isMouseGrabbed = bl;
    }

    public final boolean isFPSCamera() {
        return this.isFPSCamera;
    }

    public final void setFPSCamera(boolean value) {
        this.isFPSCamera = value;
        this.isMouseGrabbed = value;
        if (value) {
            Async.INSTANCE.startAsyncFX(() -> GameScene._set_isFPSCamera_$lambda-1(this));
        }
    }

    private final SubScene make3DSubScene(double w, double h) {
        SubScene scene3D = new SubScene((Parent)this.gameRoot, w, h, true, SceneAntialiasing.BALANCED);
        scene3D.setCamera((Camera)this.getCamera3D().getPerspectiveCamera());
        return scene3D;
    }

    private final void initViewport(double w, double h) {
        this.gameRoot.translateXProperty().bind((ObservableValue)this.getViewport().xProperty().negate());
        this.gameRoot.translateYProperty().bind((ObservableValue)this.getViewport().yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty());
        scale.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty());
        scale.xProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        scale.yProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty().add(h / (double)2));
        rotate.angleProperty().bind((ObservableValue)this.getViewport().angleProperty().negate());
        this.gameRoot.getTransforms().add((Object)rotate);
    }

    protected void onUpdate(double tpf) {
        if (this.isSingleStep) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        if (!this.is3D && this.isZSortingNeeded) {
            this.sortZ();
            this.isZSortingNeeded = false;
        }
        if (this.is3D) {
            this.getCamera3D().update(tpf);
        }
        if (this.isMouseGrabbed && this.getWindow().isFocused()) {
            if (this.getInput().getMouseXUI() < 10.0) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseXUI() + (double)10 > (double)FXGL.Companion.getAppWidth()) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseYUI() < 10.0) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseYUI() + (double)10 > (double)FXGL.Companion.getAppHeight()) {
                this.getMouseWarper().warpToCenter();
            }
        }
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.uiRoot.getChildren().add((Object)node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.addUINode((Node)ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.removeUINode((Node)ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    private final void sortZ() {
        ArrayList tmp = new ArrayList((Collection)this.gameRoot.getChildren());
        List $this$sortBy$iv = tmp;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Node it = (Node)a;
                    boolean bl2 = false;
                    Object object = it.getProperties().get((Object)"viewData");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    it = (Node)b;
                    Comparable comparable = Integer.valueOf(((GameView)object).getZ());
                    bl2 = false;
                    object = it.getProperties().get((Object)"viewData");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    Integer n = ((GameView)object).getZ();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            });
        }
        this.gameRoot.getChildren().setAll((Collection)tmp);
    }

    public final void reset$fxgl() {
        log.debug("Clearing game scene");
        this.gameWorld.reset();
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
        this.physicsWorld.clear();
        this.physicsWorld.clearCollisionHandlers();
        this.getTimer().clear();
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        this.initView(viewComponent);
    }

    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        this.destroyView(viewComponent);
    }

    public final void addGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.getZProperty().addListener(this.zChangeListener);
        Object object = view2.getNode().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"view.node.properties");
        object = (Map)object;
        String string = "viewData";
        boolean bl = false;
        object.put(string, view2);
        this.gameRoot.getChildren().add((Object)view2.getNode());
        this.isZSortingNeeded = true;
    }

    public final void removeGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.getNode().getProperties().clear();
        this.gameRoot.getChildren().remove((Object)view2.getNode());
    }

    private final void initView(ViewComponent viewComponent) {
        Node node = (Node)viewComponent.getParent();
        Integer n = viewComponent.zIndexProperty().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"viewComponent.zIndexProperty.value");
        GameView view2 = new GameView(node, ((Number)n).intValue());
        view2.getZProperty().bind((ObservableValue)viewComponent.zIndexProperty());
        this.addGameView(view2);
    }

    private final void destroyView(ViewComponent viewComponent) {
        Object object = viewComponent.getParent().getProperties().get((Object)"viewData");
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            GameView view2 = (GameView)it;
            view2.getZProperty().unbind();
            view2.getZProperty().removeListener(this.zChangeListener);
            this.removeGameView(view2);
        }
    }

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkNotNullParameter((Object)gameWorld, (String)"gameWorld");
        Intrinsics.checkNotNullParameter((Object)physicsWorld, (String)"physicsWorld");
        this(width, height, gameWorld, physicsWorld, false, 16, null);
    }

    private static final void zChangeListener$lambda-0(GameScene this$0, ObservableValue $noName_0, Number $noName_1, Number $noName_2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.isZSortingNeeded = true;
    }

    private static final void _set_isFPSCamera_$lambda-1(GameScene this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMouseWarper().warpToCenter();
    }

    private static final void _init_$lambda-2(GameScene this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.isMouseGrabbed() && (int)it.getScreenX() == (int)this$0.getMouseWarper().getWarpScreenX() && (int)it.getScreenY() == (int)this$0.getMouseWarper().getWarpScreenY()) {
            this$0.lastMouseX = it.getScreenX() - this$0.getWindow().getX();
            this$0.lastMouseY = it.getScreenY() - this$0.getWindow().getY();
            return;
        }
        if (!this$0.isFPSCamera()) {
            return;
        }
        double mouseX = it.getScreenX() - this$0.getWindow().getX();
        double mouseY = it.getScreenY() - this$0.getWindow().getY();
        double offsetX = mouseX - this$0.lastMouseX;
        double offsetY = mouseY - this$0.lastMouseY;
        if (FXGLMath.abs((double)offsetX) < 100.0 && FXGLMath.abs((double)offsetY) < 100.0) {
            double mouseSensitivity = FXGL.Companion.getSettings().getMouseSensitivity();
            if (FXGLMath.abs((double)offsetX) > 0.5) {
                if (mouseX > this$0.lastMouseX) {
                    this$0.getCamera3D().getTransform().lookRightBy(mouseSensitivity * (mouseX - this$0.lastMouseX));
                } else if (mouseX < this$0.lastMouseX) {
                    this$0.getCamera3D().getTransform().lookLeftBy(mouseSensitivity * (this$0.lastMouseX - mouseX));
                }
            }
            if (FXGLMath.abs((double)offsetY) > 0.5) {
                if (mouseY > this$0.lastMouseY) {
                    double angle = mouseSensitivity * (mouseY - this$0.lastMouseY);
                    if (this$0.getCamera3D().isOverRotationXAllowed() || this$0.getCamera3D().getTransform().getRotationX() - angle > -85.0) {
                        this$0.getCamera3D().getTransform().lookDownBy(angle);
                    }
                } else if (mouseY < this$0.lastMouseY) {
                    double angle = mouseSensitivity * (this$0.lastMouseY - mouseY);
                    if (this$0.getCamera3D().isOverRotationXAllowed() || this$0.getCamera3D().getTransform().getRotationX() + angle < 85.0) {
                        this$0.getCamera3D().getTransform().lookUpBy(angle);
                    }
                }
            }
        }
        this$0.lastMouseX = mouseX;
        this$0.lastMouseY = mouseY;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "", "window", "Lcom/almasb/fxgl/app/MainWindow;", "(Lcom/almasb/fxgl/app/scene/GameScene;Lcom/almasb/fxgl/app/MainWindow;)V", "robot", "Ljavafx/scene/robot/Robot;", "warpScreenX", "", "getWarpScreenX", "()D", "setWarpScreenX", "(D)V", "warpScreenY", "getWarpScreenY", "setWarpScreenY", "getWindow", "()Lcom/almasb/fxgl/app/MainWindow;", "warpToCenter", "", "fxgl"})
    private final class MouseWarper {
        @NotNull
        private final MainWindow window;
        @NotNull
        private final Robot robot;
        private double warpScreenX;
        private double warpScreenY;

        public MouseWarper(MainWindow window2) {
            Intrinsics.checkNotNullParameter((Object)((Object)GameScene.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
            this.window = window2;
            this.robot = new Robot();
        }

        @NotNull
        public final MainWindow getWindow() {
            return this.window;
        }

        public final double getWarpScreenX() {
            return this.warpScreenX;
        }

        public final void setWarpScreenX(double d) {
            this.warpScreenX = d;
        }

        public final double getWarpScreenY() {
            return this.warpScreenY;
        }

        public final void setWarpScreenY(double d) {
            this.warpScreenY = d;
        }

        public final void warpToCenter() {
            this.warpScreenX = this.window.getX() + this.window.getWidth() / 2.0;
            this.warpScreenY = this.window.getY() + this.window.getHeight() / 2.0;
            this.robot.mouseMove(this.warpScreenX, this.warpScreenY);
        }
    }
}

