/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.collection.UpdatableObjectProperty;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ui.PropertyViewChangeListener;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;

public class PropertyMapView
extends Parent {
    private static final Map<Class<?>, PropertyViewChangeListener<?, ?>> converters = new HashMap();

    public static <T> void addViewConverter(Class<T> type, PropertyViewChangeListener<T, ?> converter) {
        converters.put(type, converter);
    }

    public PropertyMapView(PropertyMap map) {
        VBox rootBox = new VBox();
        rootBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.gray((double)1.0), CornerRadii.EMPTY, Insets.EMPTY)}));
        for (String key : map.keys()) {
            HBox propertyBox = new HBox();
            Text name = new Text(key);
            name.setWrappingWidth(150.0);
            Node value = this.makeView(map.getValueObservable(key));
            propertyBox.getChildren().add((Object)name);
            propertyBox.getChildren().add((Object)value);
            rootBox.getChildren().add((Object)propertyBox);
        }
        this.getChildren().add((Object)rootBox);
    }

    private Node makeView(Object value) {
        if (value instanceof BooleanProperty) {
            CheckBox box = new CheckBox();
            box.selectedProperty().bindBidirectional((Property)((BooleanProperty)value));
            return box;
        }
        if (value instanceof ObjectProperty) {
            ObjectProperty property = (ObjectProperty)value;
            if (property.get().getClass().isEnum()) {
                return this.makeEnumView(property);
            }
            if (converters.containsKey(property.get().getClass())) {
                PropertyViewChangeListener<?, ?> converter = converters.get(property.get().getClass());
                return converter.makeViewInternal(property);
            }
            Text text = new Text();
            text.textProperty().bind((ObservableValue)property.asString());
            return text;
        }
        TextField textField = new TextField();
        textField.setPrefWidth(150.0);
        if (value instanceof StringProperty) {
            textField.textProperty().bindBidirectional((Property)((StringProperty)value), (StringConverter)new DefaultStringConverter());
        }
        if (value instanceof IntegerProperty) {
            textField.textProperty().bindBidirectional((Property)value, (StringConverter)new IntegerStringConverter());
        }
        if (value instanceof DoubleProperty) {
            textField.textProperty().bindBidirectional((Property)value, (StringConverter)new DoubleStringConverter());
        }
        return textField;
    }

    private Node makeEnumView(ObjectProperty<Enum<?>> enumProperty) {
        Enum enumValue = (Enum)enumProperty.get();
        ObservableList list = FXCollections.observableArrayList();
        for (Enum anEnum : (Enum[])enumValue.getDeclaringClass().getEnumConstants()) {
            list.add((Object)anEnum);
        }
        ChoiceBox view = new ChoiceBox();
        view.setItems(list);
        view.setValue((Object)enumValue);
        view.valueProperty().bindBidirectional(enumProperty);
        return view;
    }

    static {
        PropertyViewChangeListener<Vec2, HBox> l = new PropertyViewChangeListener<Vec2, HBox>(){
            private boolean ignoreChangeView = false;
            private boolean ignoreChangeProperty = false;

            @Override
            public HBox makeView(ObjectProperty<Vec2> value) {
                TextField fieldX = new TextField();
                TextField fieldY = new TextField();
                HBox view = new HBox(new Node[]{fieldX, fieldY});
                value.addListener((obs, o, newValue) -> {
                    if (this.ignoreChangeProperty) {
                        return;
                    }
                    this.onPropertyChanged(value, view);
                });
                fieldX.textProperty().addListener((obs, o, x) -> {
                    if (this.ignoreChangeView) {
                        return;
                    }
                    this.onViewChanged(value, view);
                });
                fieldY.textProperty().addListener((obs, o, y) -> {
                    if (this.ignoreChangeView) {
                        return;
                    }
                    this.onViewChanged(value, view);
                });
                this.onPropertyChanged(value, view);
                return view;
            }

            @Override
            public void onPropertyChanged(ObjectProperty<Vec2> value, HBox view) {
                TextField fieldX = (TextField)view.getChildren().get(0);
                TextField fieldY = (TextField)view.getChildren().get(1);
                this.ignoreChangeView = true;
                fieldX.setText(Float.toString(((Vec2)value.getValue()).x));
                fieldY.setText(Float.toString(((Vec2)value.getValue()).y));
                this.ignoreChangeView = false;
            }

            @Override
            public void onViewChanged(ObjectProperty<Vec2> value, HBox view) {
                TextField fieldX = (TextField)view.getChildren().get(0);
                TextField fieldY = (TextField)view.getChildren().get(1);
                this.ignoreChangeProperty = true;
                ((Vec2)value.getValue()).x = Float.parseFloat(fieldX.getText());
                ((Vec2)value.getValue()).y = Float.parseFloat(fieldY.getText());
                ((UpdatableObjectProperty)value).forceUpdateListeners((Object)((Vec2)value.getValue()), (Object)((Vec2)value.getValue()));
                this.ignoreChangeProperty = false;
            }
        };
        PropertyMapView.addViewConverter(Vec2.class, l);
    }
}

