/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.profile;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.FileSystemService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012J\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001d0\u000f2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/almasb/fxgl/profile/SaveLoadService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "fs", "Lcom/almasb/fxgl/io/FileSystemService;", "log", "Lcom/almasb/fxgl/logging/Logger;", "saveLoadHandlers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/profile/SaveLoadHandler;", "Lkotlin/collections/ArrayList;", "addHandler", "", "saveLoadHandler", "deleteSaveFileTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/lang/Void;", "saveFileName", "", "load", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "readAndLoadTask", "readLastModifiedSaveFileTask", "Ljava/util/Optional;", "Lcom/almasb/fxgl/profile/SaveFile;", "dirName", "saveFileExt", "readSaveFilesTask", "", "readTask", "removeHandler", "save", "saveAndWriteTask", "saveFileExists", "", "writeTask", "fxgl-io"})
public final class SaveLoadService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private FileSystemService fs;
    @NotNull
    private final ArrayList<SaveLoadHandler> saveLoadHandlers = new ArrayList();

    public final void addHandler(@NotNull SaveLoadHandler saveLoadHandler) {
        Intrinsics.checkNotNullParameter((Object)saveLoadHandler, (String)"saveLoadHandler");
        ((Collection)this.saveLoadHandlers).add(saveLoadHandler);
    }

    public final void removeHandler(@NotNull SaveLoadHandler saveLoadHandler) {
        Intrinsics.checkNotNullParameter((Object)saveLoadHandler, (String)"saveLoadHandler");
        ((Collection)this.saveLoadHandlers).remove(saveLoadHandler);
    }

    public final void save(@NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Iterable $this$forEach$iv = this.saveLoadHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SaveLoadHandler it = (SaveLoadHandler)element$iv;
            boolean bl = false;
            it.onSave(dataFile);
        }
    }

    public final void load(@NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Iterable $this$forEach$iv = this.saveLoadHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SaveLoadHandler it = (SaveLoadHandler)element$iv;
            boolean bl = false;
            it.onLoad(dataFile);
        }
    }

    public final boolean saveFileExists(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("Checking if save file exists: " + saveFileName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        return fileSystemService.exists(saveFileName);
    }

    @NotNull
    public final IOTask<Void> saveAndWriteTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        IOTask iOTask = IOTask.of(() -> SaveLoadService.saveAndWriteTask$lambda-2(this)).then(arg_0 -> SaveLoadService.saveAndWriteTask$lambda-3(this, saveFileName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of {\n            val dat\u2026eTask(saveFileName, it) }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> writeTask(@NotNull String saveFileName, @NotNull DataFile dataFile) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        SaveFile saveFile = new SaveFile(saveFileName, null, dataFile, 2, null);
        this.log.debug("writeTask: " + saveFile.getName());
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        IOTask<Void> iOTask = fileSystemService.writeDataTask(saveFile, saveFile.getName());
        Intrinsics.checkNotNullExpressionValue(iOTask, (String)"fs.writeDataTask(saveFile, saveFile.name)");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> readAndLoadTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("readAndLoadTask: " + saveFileName);
        IOTask iOTask = this.readTask(saveFileName).then(arg_0 -> SaveLoadService.readAndLoadTask$lambda-5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"readTask(saveFileName)\n \u2026      }\n                }");
        return iOTask;
    }

    @NotNull
    public final IOTask<SaveFile> readTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        return fileSystemService.readDataTask(saveFileName);
    }

    @NotNull
    public final IOTask<Void> deleteSaveFileTask(@NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)saveFileName, (String)"saveFileName");
        this.log.debug("Deleting save file: " + saveFileName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        return fileSystemService.deleteFileTask(saveFileName);
    }

    @NotNull
    public final IOTask<Optional<SaveFile>> readLastModifiedSaveFileTask(@NotNull String dirName, @NotNull String saveFileExt) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)saveFileExt, (String)"saveFileExt");
        this.log.debug("Reading last modified save file from " + dirName + " with ext: " + saveFileExt);
        IOTask iOTask = this.readSaveFilesTask(dirName, saveFileExt).then(arg_0 -> SaveLoadService.readLastModifiedSaveFileTask$lambda-7(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"readSaveFilesTask(dirNam\u2026)\n            }\n        }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<SaveFile>> readSaveFilesTask(@NotNull String dirName, @NotNull String saveFileExt) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)saveFileExt, (String)"saveFileExt");
        this.log.debug("Reading save files from " + dirName);
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            fileSystemService = null;
        }
        IOTask iOTask = fileSystemService.loadFileNamesTask(dirName, true, CollectionsKt.listOf((Object)new FileExtension(saveFileExt))).then(arg_0 -> SaveLoadService.readSaveFilesTask$lambda-9(this, dirName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"fs.loadFileNamesTask(dir\u2026      }\n                }");
        return iOTask;
    }

    private static final DataFile saveAndWriteTask$lambda-2(SaveLoadService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DataFile dataFile = new DataFile();
        this$0.save(dataFile);
        return dataFile;
    }

    private static final IOTask saveAndWriteTask$lambda-3(SaveLoadService this$0, String $saveFileName, DataFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$saveFileName, (String)"$saveFileName");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.writeTask($saveFileName, it);
    }

    private static final void readAndLoadTask$lambda-5$lambda-4(SaveLoadService this$0, SaveFile $saveFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.load($saveFile.getData());
    }

    private static final IOTask readAndLoadTask$lambda-5(SaveLoadService this$0, SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return IOTask.ofVoid(() -> SaveLoadService.readAndLoadTask$lambda-5$lambda-4(this$0, saveFile));
    }

    private static final Optional readLastModifiedSaveFileTask$lambda-7$lambda-6(List $files, SaveLoadService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if ($files.isEmpty()) {
            this$0.log.warning("No save files found");
            return Optional.empty();
        }
        Collections.sort($files, SaveFile.RECENT_FIRST);
        return Optional.of($files.get(0));
    }

    private static final IOTask readLastModifiedSaveFileTask$lambda-7(SaveLoadService this$0, List files) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return IOTask.of((String)"findLastSave", () -> SaveLoadService.readLastModifiedSaveFileTask$lambda-7$lambda-6(files, this$0));
    }

    private static final List readSaveFilesTask$lambda-9$lambda-8(List $fileNames, SaveLoadService this$0, String $dirName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        ArrayList<SaveFile> list = new ArrayList<SaveFile>();
        for (String name : $fileNames) {
            SaveFile file;
            FileSystemService fileSystemService = this$0.fs;
            if (fileSystemService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
                fileSystemService = null;
            }
            if ((file = (SaveFile)fileSystemService.readDataTask($dirName + "/" + name).run()) == null) continue;
            list.add(file);
        }
        return list;
    }

    private static final IOTask readSaveFilesTask$lambda-9(SaveLoadService this$0, String $dirName, List fileNames) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        return IOTask.of((String)"readSaveFiles", () -> SaveLoadService.readSaveFilesTask$lambda-9$lambda-8(fileNames, this$0, $dirName));
    }
}

