/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.tcp;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Server;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public final class TCPServer<T>
extends Server<T> {
    private static final Logger log = Logger.get(TCPServer.class);
    private boolean isStopped = false;
    private int port;
    private Class<T> messageType;
    private ServerSocket serverSocket;

    public TCPServer(int port, Class<T> messageType) {
        this.port = port;
        this.messageType = messageType;
    }

    @Override
    protected void start() {
        block8: {
            log.debug("Starting to listen at: " + this.port + " type: " + this.messageType);
            try (ServerSocket serverSocket = new ServerSocket(this.port);){
                this.serverSocket = serverSocket;
                this.onStartedListening();
                int connectionNum = 1;
                while (!this.isStopped) {
                    Socket socket = serverSocket.accept();
                    this.openTCPConnection(socket, connectionNum++, this.messageType);
                }
            }
            catch (Exception e) {
                if (this.isStopped) break block8;
                throw new RuntimeException("Failed to start: " + e.getMessage(), e);
            }
        }
        this.onStoppedListening();
    }

    @Override
    public void stop() {
        this.isStopped = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            log.warning("IOException when closing server socket: " + e.getMessage(), (Throwable)e);
        }
    }
}

