/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.io;

import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.FileSystemAccess;
import com.almasb.fxgl.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011J\u0019\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0016\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\fJ\u001c\u0010\u001e\u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/io/FileSystemAccess;", "", "rootStorage", "Ljava/io/File;", "(Ljava/io/File;)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "checkExists", "", "file", "createDirectory", "dirName", "", "deleteDirectory", "deleteFile", "fileName", "exists", "", "pathName", "loadDirectoryNames", "", "recursive", "loadFileNames", "extensions", "Lcom/almasb/fxgl/io/FileExtension;", "loadLastModifiedFileName", "readData", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "toFile", "writeData", "data", "Ljava/io/Serializable;", "text", "fxgl-io"})
public final class FileSystemAccess {
    @NotNull
    private final File rootStorage;
    @NotNull
    private final Logger log;

    public FileSystemAccess(@NotNull File rootStorage) {
        Intrinsics.checkNotNullParameter((Object)rootStorage, (String)"rootStorage");
        this.rootStorage = rootStorage;
        this.log = Logger.Companion.get(this.getClass());
    }

    public final boolean exists(@NotNull String pathName) {
        Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
        return this.toFile(pathName).exists();
    }

    public final void createDirectory(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File dir = this.toFile(dirName);
        dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(@NotNull Serializable data, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.toFile(fileName);
        file.getParentFile().mkdirs();
        Closeable closeable = new ObjectOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            this.log.debug("Writing to: " + file);
            it.writeObject(data);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void writeData(@NotNull List<String> text, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.toFile(fileName);
        FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)text, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.toFile(fileName);
        Closeable closeable = new ObjectInputStream(new FileInputStream(file));
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            this.log.debug("Reading from: " + file);
            Object object = it.readObject();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<String> loadFileNames(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir).maxDepth(recursive ? Integer.MAX_VALUE : 1)), (Function1)loadFileNames.1.INSTANCE), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = FilesKt.relativeTo((File)it, (File)this.$dir).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(dir).toString()");
                return StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            }
        })));
    }

    @NotNull
    public final List<String> loadFileNames(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir).maxDepth(recursive ? Integer.MAX_VALUE : 1)), (Function1)((Function1)new Function1<File, Boolean>(extensions){
            final /* synthetic */ List<FileExtension> $extensions;
            {
                this.$extensions = $extensions;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull File file) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isFile()) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.$extensions;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        FileExtension it = (FileExtension)element$iv$iv;
                        boolean bl2 = false;
                        if (!StringsKt.endsWith$default((String)String.valueOf(file), (String)it.getExtension(), (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    if (!((Collection)((List)destination$iv$iv)).isEmpty()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        })), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = FilesKt.relativeTo((File)it, (File)this.$dir).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(dir).toString()");
                return StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            }
        })));
    }

    @NotNull
    public final List<String> loadDirectoryNames(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir).maxDepth(recursive ? Integer.MAX_VALUE : 1)), (Function1)loadDirectoryNames.1.INSTANCE), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = FilesKt.relativeTo((File)it, (File)this.$dir).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(dir).toString()");
                return StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            }
        })), (Function1)loadDirectoryNames.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String loadLastModifiedFileName(@NotNull String dirName, boolean recursive) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir).maxDepth(recursive ? Integer.MAX_VALUE : 1)), (Function1)loadLastModifiedFileName.1.INSTANCE);
        boolean $i$f$sortedByDescending = false;
        String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
            }
        }), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = FilesKt.relativeTo((File)it, (File)this.$dir).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(dir).toString()");
                return StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            }
        })));
        if (string == null) {
            throw new FileNotFoundException("No files found in " + dir);
        }
        return string;
    }

    public final void deleteFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.toFile(fileName);
        this.checkExists(file);
        file.delete();
    }

    public final void deleteDirectory(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File file = this.toFile(dirName);
        this.checkExists(file);
        FilesKt.deleteRecursively((File)file);
    }

    private final File toFile(String fileName) {
        return new File(this.rootStorage.getAbsolutePath() + File.separatorChar + fileName);
    }

    private final void checkExists(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException("Path " + file + " does not exist");
        }
    }
}

