/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.physics.CollisionCell;
import com.almasb.fxgl.physics.HitBox;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/physics/CollisionGrid;", "", "cellWidth", "", "cellHeight", "(II)V", "getCellHeight", "()I", "getCellWidth", "cells", "Ljava/util/HashMap;", "Ljavafx/geometry/Point2D;", "Lcom/almasb/fxgl/physics/CollisionCell;", "Lkotlin/collections/HashMap;", "getCells", "()Ljava/util/HashMap;", "insert", "", "e", "Lcom/almasb/fxgl/entity/Entity;", "fxgl-entity"})
public final class CollisionGrid {
    private final int cellWidth;
    private final int cellHeight;
    @NotNull
    private final HashMap<Point2D, CollisionCell> cells;

    public CollisionGrid(int cellWidth, int cellHeight) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        boolean bl = false;
        this.cells = new HashMap();
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    @NotNull
    public final HashMap<Point2D, CollisionCell> getCells() {
        return this.cells;
    }

    public final void insert(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getBoundingBoxComponent().hitBoxesProperty().isEmpty()) {
            return;
        }
        HitBox box = (HitBox)e.getBoundingBoxComponent().hitBoxesProperty().get(0);
        float minX = box.fastMinX;
        float minY = box.fastMinY;
        float maxX = box.fastMaxX;
        float maxY = box.fastMaxY;
        int n = 1;
        int n2 = e.getBoundingBoxComponent().hitBoxesProperty().size();
        if (n < n2) {
            do {
                int i = n++;
                box = (HitBox)e.getBoundingBoxComponent().hitBoxesProperty().get(i);
                minX = FXGLMath.min((float)minX, (float)box.fastMinX);
                minY = FXGLMath.min((float)minY, (float)box.fastMinY);
                maxX = FXGLMath.max((float)maxX, (float)box.fastMaxX);
                maxY = FXGLMath.max((float)maxY, (float)box.fastMaxY);
            } while (n < n2);
        }
        Point2D tl = new Point2D((double)minX, (double)minY);
        Point2D br = new Point2D((double)maxX, (double)maxY);
        int tlX = (int)Math.floor(tl.getX() / (double)this.cellWidth);
        int tlY = (int)Math.floor(tl.getY() / (double)this.cellHeight);
        int brX = (int)Math.ceil(br.getX() / (double)this.cellWidth);
        int brY = (int)Math.ceil(br.getY() / (double)this.cellHeight);
        int n3 = tlX;
        if (n3 <= brX) {
            int x;
            do {
                int y;
                x = n3++;
                int n4 = tlY;
                if (n4 > brY) continue;
                do {
                    Point2D point;
                    CollisionCell cell;
                    if ((cell = this.cells.get(point = new Point2D((double)x, (double)(y = n4++)))) == null) {
                        cell = new CollisionCell(x, y);
                        Map map = this.cells;
                        boolean bl = false;
                        map.put(point, cell);
                    }
                    cell.getEntities().add((Object)e);
                } while (y != brY);
            } while (x != brX);
        }
    }
}

