/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.time;

import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/time/TimerAction;", "", "interval", "Ljavafx/util/Duration;", "action", "Ljava/lang/Runnable;", "limit", "", "(Ljavafx/util/Duration;Ljava/lang/Runnable;I)V", "currentTime", "", "<set-?>", "", "isExpired", "()Z", "isPaused", "lastFired", "timesFired", "expire", "", "pause", "resume", "update", "tpf", "fxgl-core"})
public final class TimerAction {
    @NotNull
    private final Runnable action;
    private final int limit;
    private final double interval;
    private boolean isExpired;
    private boolean isPaused;
    private double lastFired;
    private double currentTime;
    private int timesFired;

    public TimerAction(@NotNull Duration interval, @NotNull Runnable action, int limit) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.action = action;
        this.limit = limit;
        this.interval = interval.toSeconds();
        this.isExpired = this.limit == 0;
    }

    public /* synthetic */ TimerAction(Duration duration, Runnable runnable, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(duration, runnable, n);
    }

    public final boolean isExpired() {
        return this.isExpired;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void update(double tpf) {
        if (this.isExpired || this.isPaused) {
            return;
        }
        this.currentTime += tpf;
        if (this.currentTime - this.lastFired >= this.interval) {
            this.action.run();
            int n = this.timesFired;
            this.timesFired = n + 1;
            this.lastFired = this.currentTime;
            if (this.timesFired == this.limit) {
                this.expire();
            }
        }
    }

    public final void pause() {
        this.isPaused = true;
    }

    public final void resume() {
        this.isPaused = false;
    }

    public final void expire() {
        this.isExpired = true;
    }
}

