/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import java.util.Collection;
import java.util.List;
import java.util.Queue;
import javafx.scene.input.KeyCode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/input/InputSequence;", "", "firstKey", "Ljavafx/scene/input/KeyCode;", "secondKey", "furtherKeys", "", "(Ljavafx/scene/input/KeyCode;Ljavafx/scene/input/KeyCode;[Ljavafx/scene/input/KeyCode;)V", "lastKey", "getLastKey", "()Ljavafx/scene/input/KeyCode;", "sequence", "", "matches", "", "queue", "Ljava/util/Queue;", "fxgl-core"})
public final class InputSequence {
    @NotNull
    private final List<KeyCode> sequence;
    @NotNull
    private final KeyCode lastKey;

    public InputSequence(@NotNull KeyCode firstKey, @NotNull KeyCode secondKey, KeyCode ... furtherKeys) {
        Intrinsics.checkNotNullParameter((Object)firstKey, (String)"firstKey");
        Intrinsics.checkNotNullParameter((Object)secondKey, (String)"secondKey");
        Intrinsics.checkNotNullParameter((Object)furtherKeys, (String)"furtherKeys");
        Object[] objectArray = new KeyCode[]{firstKey, secondKey};
        this.sequence = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Object[])furtherKeys);
        this.lastKey = (KeyCode)CollectionsKt.last(this.sequence);
    }

    @NotNull
    public final KeyCode getLastKey() {
        return this.lastKey;
    }

    public final boolean matches(@NotNull Queue<KeyCode> queue) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        if (queue.size() < this.sequence.size()) {
            return false;
        }
        List window = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)queue, (int)(queue.size() - this.sequence.size())), (int)this.sequence.size());
        return Intrinsics.areEqual((Object)window, this.sequence);
    }
}

