/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio;

import com.almasb.fxgl.audio.Audio;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.audio.impl.DesktopAndMobileAudioLoader;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.logging.Logger;
import java.net.URL;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0019J\u0006\u0010*\u001a\u00020\u0019J\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/almasb/fxgl/audio/AudioPlayer;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "activeMusic", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "Lcom/almasb/fxgl/audio/Music;", "activeSounds", "Lcom/almasb/fxgl/audio/Sound;", "isPauseMusicWhenMinimized", "", "loader", "Lcom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader;", "log", "Lcom/almasb/fxgl/logging/Logger;", "musicVolume", "Ljavafx/beans/property/DoubleProperty;", "soundVolume", "loadAudio", "Lcom/almasb/fxgl/audio/Audio;", "audioType", "Lcom/almasb/fxgl/audio/AudioType;", "url", "Ljava/net/URL;", "isMobile", "loopMusic", "", "music", "onMainLoopPausing", "onMainLoopResumed", "onMainLoopStarting", "onUpdate", "tpf", "", "pauseAllMusic", "pauseMusic", "playAllMusic", "playMusic", "playSound", "sound", "resumeAllMusic", "resumeMusic", "stopAllMusic", "stopAllSounds", "stopAllSoundsAndMusic", "stopMusic", "stopSound", "fxgl-core"})
public final class AudioPlayer
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @NotNull
    private final UnorderedArray<Music> activeMusic = new UnorderedArray(0, 1, null);
    @NotNull
    private final UnorderedArray<Sound> activeSounds = new UnorderedArray(0, 1, null);
    @Inject(value="globalMusicVolumeProperty")
    private DoubleProperty musicVolume;
    @Inject(value="globalSoundVolumeProperty")
    private DoubleProperty soundVolume;
    @Inject(value="isPauseMusicWhenMinimized")
    private boolean isPauseMusicWhenMinimized = true;
    @NotNull
    private final DesktopAndMobileAudioLoader loader = new DesktopAndMobileAudioLoader();

    @Override
    public void onMainLoopStarting() {
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"musicVolume");
            doubleProperty = null;
        }
        doubleProperty.addListener((arg_0, arg_1, arg_2) -> AudioPlayer.onMainLoopStarting$lambda-1(this, arg_0, arg_1, arg_2));
        DoubleProperty doubleProperty2 = this.soundVolume;
        if (doubleProperty2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"soundVolume");
            doubleProperty2 = null;
        }
        doubleProperty2.addListener((arg_0, arg_1, arg_2) -> AudioPlayer.onMainLoopStarting$lambda-3(this, arg_0, arg_1, arg_2));
    }

    @Override
    public void onMainLoopPausing() {
        if (this.isPauseMusicWhenMinimized) {
            this.pauseAllMusic();
        }
    }

    @Override
    public void onMainLoopResumed() {
        if (this.isPauseMusicWhenMinimized) {
            this.resumeAllMusic();
        }
    }

    @Override
    public void onUpdate(double tpf) {
        CollectionsKt.removeAll((Iterable)this.activeMusic, (Function1)onUpdate.1.INSTANCE);
        CollectionsKt.removeAll((Iterable)this.activeSounds, (Function1)onUpdate.2.INSTANCE);
    }

    public final void playSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        if (!this.activeSounds.containsByIdentity(sound)) {
            this.activeSounds.add(sound);
        }
        Audio audio2 = sound.getAudio$fxgl_core();
        DoubleProperty doubleProperty = this.soundVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"soundVolume");
            doubleProperty = null;
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"soundVolume.value");
        audio2.setVolume(((Number)d).doubleValue());
        sound.getAudio$fxgl_core().play();
    }

    public final void stopSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        sound.getAudio$fxgl_core().stop();
    }

    public final void stopAllSounds() {
        Iterable $this$forEach$iv = this.activeSounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sound it = (Sound)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.stopSound(it);
        }
    }

    public final void playMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter((Object)music, (String)"music");
        this.log.debug("Playing music " + music);
        if (!this.activeMusic.containsByIdentity(music)) {
            this.activeMusic.add(music);
        }
        Audio audio2 = music.getAudio$fxgl_core();
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"musicVolume");
            doubleProperty = null;
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"musicVolume.value");
        audio2.setVolume(((Number)d).doubleValue());
        music.getAudio$fxgl_core().play();
    }

    public final void pauseMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter((Object)music, (String)"music");
        this.log.debug("Pausing music " + music);
        music.getAudio$fxgl_core().pause();
    }

    public final void resumeMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter((Object)music, (String)"music");
        this.log.debug("Resuming music " + music);
        music.getAudio$fxgl_core().play();
    }

    public final void stopMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter((Object)music, (String)"music");
        this.log.debug("Stopping music " + music);
        music.getAudio$fxgl_core().stop();
    }

    public final void loopMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter((Object)music, (String)"music");
        music.getAudio$fxgl_core().setLooping(true);
        this.playMusic(music);
    }

    public final void pauseAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.pauseMusic(it);
        }
    }

    public final void resumeAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.resumeMusic(it);
        }
    }

    public final void playAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.playMusic(it);
        }
    }

    public final void stopAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.stopMusic(it);
        }
    }

    public final void stopAllSoundsAndMusic() {
        this.stopAllSounds();
        this.stopAllMusic();
    }

    @NotNull
    public final Audio loadAudio(@NotNull AudioType audioType, @NotNull URL url, boolean isMobile) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioType), (String)"audioType");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.loader.loadAudio(audioType, url, isMobile);
    }

    private static final void onMainLoopStarting$lambda-1(AudioPlayer this$0, ObservableValue $noName_0, Number $noName_1, Number newVolume) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            it.getAudio$fxgl_core().setVolume(newVolume.doubleValue());
        }
    }

    private static final void onMainLoopStarting$lambda-3(AudioPlayer this$0, ObservableValue $noName_0, Number $noName_1, Number newVolume) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.activeSounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sound it = (Sound)element$iv;
            boolean bl = false;
            it.getAudio$fxgl_core().setVolume(newVolume.doubleValue());
        }
    }
}

