/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.texture.Texture;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010*\u001a\u00020(H\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\b\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\f\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u000f\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u0016\u00101\u001a\u00020\u00062\u0006\u0010'\u001a\u0002022\u0006\u0010*\u001a\u000202J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u0012\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u0015\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u0018\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u001c\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\u001f\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J&\u0010\"\u001a\u00020\u00002\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(R\u001a\u0010\b\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\u0007R\u001a\u0010\u0018\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR\u001a\u0010\u001c\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\u0007R\u001a\u0010\"\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\u0007\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/texture/NineSliceTextureBuilder;", "", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;)V", "texture", "Lcom/almasb/fxgl/texture/Texture;", "(Lcom/almasb/fxgl/texture/Texture;)V", "bot", "getBot", "()Lcom/almasb/fxgl/texture/Texture;", "setBot", "botLeft", "getBotLeft", "setBotLeft", "botRight", "getBotRight", "setBotRight", "center", "getCenter", "setCenter", "left", "getLeft", "setLeft", "right", "getRight", "setRight", "getTexture", "top", "getTop", "setTop", "topLeft", "getTopLeft", "setTopLeft", "topRight", "getTopRight", "setTopRight", "adjustHorizontally", "base", "width", "", "adjustVertically", "height", "rect", "Ljavafx/geometry/Rectangle2D;", "x", "y", "w", "h", "build", "", "fxgl-core"})
public final class NineSliceTextureBuilder {
    @NotNull
    private final Texture texture;
    public Texture topLeft;
    public Texture top;
    public Texture topRight;
    public Texture right;
    public Texture botRight;
    public Texture bot;
    public Texture botLeft;
    public Texture left;
    public Texture center;

    public NineSliceTextureBuilder(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.texture = texture;
    }

    @NotNull
    public final Texture getTexture() {
        return this.texture;
    }

    public NineSliceTextureBuilder(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        this(new Texture(image2));
    }

    @NotNull
    public final Texture getTopLeft() {
        Texture texture = this.topLeft;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"topLeft");
        throw null;
    }

    public final void setTopLeft(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.topLeft = texture;
    }

    @NotNull
    public final Texture getTop() {
        Texture texture = this.top;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"top");
        throw null;
    }

    public final void setTop(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.top = texture;
    }

    @NotNull
    public final Texture getTopRight() {
        Texture texture = this.topRight;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"topRight");
        throw null;
    }

    public final void setTopRight(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.topRight = texture;
    }

    @NotNull
    public final Texture getRight() {
        Texture texture = this.right;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"right");
        throw null;
    }

    public final void setRight(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.right = texture;
    }

    @NotNull
    public final Texture getBotRight() {
        Texture texture = this.botRight;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"botRight");
        throw null;
    }

    public final void setBotRight(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.botRight = texture;
    }

    @NotNull
    public final Texture getBot() {
        Texture texture = this.bot;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bot");
        throw null;
    }

    public final void setBot(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.bot = texture;
    }

    @NotNull
    public final Texture getBotLeft() {
        Texture texture = this.botLeft;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"botLeft");
        throw null;
    }

    public final void setBotLeft(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.botLeft = texture;
    }

    @NotNull
    public final Texture getLeft() {
        Texture texture = this.left;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"left");
        throw null;
    }

    public final void setLeft(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.left = texture;
    }

    @NotNull
    public final Texture getCenter() {
        Texture texture = this.center;
        if (texture != null) {
            return texture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"center");
        throw null;
    }

    public final void setCenter(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.center = texture;
    }

    @NotNull
    public final NineSliceTextureBuilder topLeft(double x, double y, double w, double h) {
        return this.topLeft(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder topLeft(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setTopLeft(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder top(double x, double y, double w, double h) {
        return this.top(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder top(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setTop(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder topRight(double x, double y, double w, double h) {
        return this.topRight(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder topRight(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setTopRight(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder right(double x, double y, double w, double h) {
        return this.right(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder right(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setRight(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder botRight(double x, double y, double w, double h) {
        return this.botRight(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder botRight(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setBotRight(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder bot(double x, double y, double w, double h) {
        return this.bot(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder bot(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setBot(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder botLeft(double x, double y, double w, double h) {
        return this.botLeft(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder botLeft(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setBotLeft(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder left(double x, double y, double w, double h) {
        return this.left(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder left(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setLeft(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final NineSliceTextureBuilder center(double x, double y, double w, double h) {
        return this.center(new Rectangle2D(x, y, w, h));
    }

    @NotNull
    public final NineSliceTextureBuilder center(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        NineSliceTextureBuilder nineSliceTextureBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        NineSliceTextureBuilder it = nineSliceTextureBuilder;
        boolean bl3 = false;
        this.setCenter(this.getTexture().subTexture(rect));
        return nineSliceTextureBuilder;
    }

    @NotNull
    public final Texture build(int width, int height) {
        double w = (double)width - this.getLeft().getWidth() - this.getRight().getWidth();
        double h = (double)height - this.getTop().getHeight() - this.getBot().getHeight();
        boolean bl = w > 0.0 && h > 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The entered dimension are too small to build the texture.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Texture newTop = this.adjustHorizontally(this.getTop(), w);
        Texture row0 = this.getTopLeft().superTexture(newTop, HorizontalDirection.RIGHT).superTexture(this.getTopRight(), HorizontalDirection.RIGHT);
        Texture adjustedCenterHorizontally = this.adjustHorizontally(this.getCenter(), w);
        Texture adjustedCenterBoth = this.adjustVertically(adjustedCenterHorizontally, h);
        Texture newLeft = this.adjustVertically(this.getLeft(), h);
        Texture newRight = this.adjustVertically(this.getRight(), h);
        Texture row1 = newLeft.superTexture(adjustedCenterBoth, HorizontalDirection.RIGHT).superTexture(newRight, HorizontalDirection.RIGHT);
        Texture newBot = this.adjustHorizontally(this.getBot(), w);
        Texture row2 = this.getBotLeft().superTexture(newBot, HorizontalDirection.RIGHT).superTexture(this.getBotRight(), HorizontalDirection.RIGHT);
        return row0.superTexture(row1, VerticalDirection.DOWN).superTexture(row2, VerticalDirection.DOWN);
    }

    private final Texture adjustVertically(Texture base, double height) {
        Texture adjusted = base;
        if (base.getHeight() > height) {
            adjusted = base.subTexture(new Rectangle2D(0.0, 0.0, base.getWidth(), height));
        } else if (base.getHeight() < height) {
            int times = (int)height / (int)base.getHeight();
            int rem = (int)height % (int)base.getHeight();
            int n = 1;
            if (n < times) {
                do {
                    int i = n++;
                    adjusted = adjusted.superTexture(base, VerticalDirection.DOWN);
                } while (n < times);
            }
            if (rem > 0) {
                adjusted = adjusted.superTexture(base.subTexture(new Rectangle2D(0.0, 0.0, base.getWidth(), (double)rem)), VerticalDirection.DOWN);
            }
        }
        return adjusted;
    }

    private final Texture adjustHorizontally(Texture base, double width) {
        Texture adjusted = base;
        if (base.getWidth() > width) {
            adjusted = base.subTexture(new Rectangle2D(0.0, 0.0, width, base.getHeight()));
        } else if (base.getWidth() < width) {
            int times = (int)width / (int)base.getWidth();
            int rem = (int)width % (int)base.getWidth();
            int n = 1;
            if (n < times) {
                do {
                    int i = n++;
                    adjusted = adjusted.superTexture(base, HorizontalDirection.RIGHT);
                } while (n < times);
            }
            if (rem > 0) {
                adjusted = adjusted.superTexture(base.subTexture(new Rectangle2D(0.0, 0.0, (double)rem, base.getHeight())), HorizontalDirection.RIGHT);
            }
        }
        return adjusted;
    }
}

