/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.FrameData;
import com.almasb.fxgl.texture.Texture;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0006\u0010 \u001a\u00020\u0018J\b\u0010!\u001a\u00020\u0018H\u0002R\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/texture/AnimatedTexture;", "Lcom/almasb/fxgl/texture/Texture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "(Lcom/almasb/fxgl/texture/AnimationChannel;)V", "<set-?>", "animationChannel", "getAnimationChannel", "()Lcom/almasb/fxgl/texture/AnimationChannel;", "counter", "", "currentFrame", "", "isLooping", "", "needUpdate", "onCycleFinished", "Ljava/lang/Runnable;", "getOnCycleFinished", "()Ljava/lang/Runnable;", "setOnCycleFinished", "(Ljava/lang/Runnable;)V", "loop", "loopAnimationChannel", "", "channel", "loopNoOverride", "onUpdate", "tpf", "play", "playAnimationChannel", "reset", "stop", "updateImage", "fxgl-core"})
public final class AnimatedTexture
extends Texture {
    private int currentFrame;
    private double counter;
    private boolean isLooping;
    private boolean needUpdate;
    @NotNull
    private AnimationChannel animationChannel;
    @NotNull
    private Runnable onCycleFinished;

    public AnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkNotNullParameter((Object)defaultChannel, (String)"defaultChannel");
        super(defaultChannel.getImage());
        this.animationChannel = defaultChannel;
        this.onCycleFinished = EmptyRunnable.INSTANCE;
        this.updateImage();
    }

    @NotNull
    public final AnimationChannel getAnimationChannel() {
        return this.animationChannel;
    }

    @NotNull
    public final Runnable getOnCycleFinished() {
        return this.onCycleFinished;
    }

    public final void setOnCycleFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.onCycleFinished = runnable;
    }

    public final void playAnimationChannel(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.animationChannel = channel;
        this.isLooping = false;
        this.reset();
    }

    public final void loopNoOverride(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (this.animationChannel == channel) {
            return;
        }
        this.loopAnimationChannel(channel);
    }

    public final void loopAnimationChannel(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.animationChannel = channel;
        this.isLooping = true;
        this.reset();
    }

    @NotNull
    public final AnimatedTexture play() {
        this.playAnimationChannel(this.animationChannel);
        return this;
    }

    @NotNull
    public final AnimatedTexture loop() {
        this.loopAnimationChannel(this.animationChannel);
        return this;
    }

    public final void stop() {
        this.currentFrame = 0;
        this.counter = 0.0;
        this.needUpdate = false;
        this.updateImage();
    }

    @Override
    public void onUpdate(double tpf) {
        if (!this.needUpdate) {
            return;
        }
        boolean channelDone = false;
        AnimatedTexture animatedTexture = this;
        animatedTexture.counter += tpf;
        if (this.counter >= this.animationChannel.getFrameDuration$fxgl_core()) {
            if (this.animationChannel.isLastFrame(this.currentFrame)) {
                channelDone = true;
                if (!this.isLooping) {
                    this.needUpdate = false;
                    this.onCycleFinished();
                    return;
                }
            }
            this.counter = 0.0;
            this.currentFrame = this.animationChannel.frameAfter(this.currentFrame);
            this.updateImage();
        }
        if (channelDone) {
            this.onCycleFinished();
        }
    }

    private final void reset() {
        this.currentFrame = 0;
        this.counter = 0.0;
        this.needUpdate = true;
        this.updateImage();
    }

    private final void updateImage() {
        FrameData frameData = this.animationChannel.getFrameData(this.currentFrame);
        this.setImage(this.animationChannel.getImage());
        this.setFitWidth(frameData.getWidth());
        this.setFitHeight(frameData.getHeight());
        this.setViewport(new Rectangle2D((double)frameData.getX(), (double)frameData.getY(), (double)frameData.getWidth(), (double)frameData.getHeight()));
    }

    private final void onCycleFinished() {
        this.onCycleFinished.run();
    }
}

