/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.logging;

import com.almasb.fxgl.logging.LoggerOutput;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/logging/FileOutput;", "Lcom/almasb/fxgl/logging/LoggerOutput;", "baseFileName", "", "logDirectory", "maxLogFiles", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "append", "", "message", "cleanOldLogs", "logDir", "Ljava/nio/file/Path;", "close", "getOrCreateLogDir", "fxgl-core"})
public final class FileOutput
implements LoggerOutput {
    @NotNull
    private final String baseFileName;
    @NotNull
    private final String logDirectory;
    private final int maxLogFiles;
    @NotNull
    private final ArrayList<String> data;

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName, @NotNull String logDirectory, int maxLogFiles) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        this.baseFileName = baseFileName;
        this.logDirectory = logDirectory;
        this.maxLogFiles = maxLogFiles;
        boolean bl = false;
        this.data = new ArrayList();
        Path logDir = this.getOrCreateLogDir();
        this.cleanOldLogs(logDir);
    }

    public /* synthetic */ FileOutput(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "logs/";
        }
        if ((n2 & 4) != 0) {
            n = 10;
        }
        this(string, string2, n);
    }

    @Override
    public void append(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.data.add(message2);
    }

    @Override
    public void close() {
        String stamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MMM-yyyy-HH.mm.ss"));
        Path file = Paths.get(this.logDirectory + this.baseFileName + '-' + stamp + ".log", new String[0]);
        Files.write(file, (Iterable<? extends CharSequence>)this.data, new OpenOption[0]);
    }

    private final Path getOrCreateLogDir() {
        Path logDir = Paths.get(this.logDirectory, new String[0]);
        if (!Files.exists(logDir, new LinkOption[0])) {
            Files.createDirectory(logDir, new FileAttribute[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)logDir, (String)"logDir");
        return logDir;
    }

    private final void cleanOldLogs(Path logDir) {
        int n;
        int n2;
        List logs = Files.walk(logDir, 1, new FileVisitOption[0]).filter(FileOutput::cleanOldLogs$lambda-0).sorted(FileOutput::cleanOldLogs$lambda-1).collect(Collectors.toList());
        int logSize = logs.size();
        if (logSize >= this.maxLogFiles && (n2 = 0) < (n = logSize + 1 - this.maxLogFiles)) {
            do {
                int i = n2++;
                Files.delete((Path)logs.get(i));
            } while (n2 < n);
        }
    }

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName, @NotNull String logDirectory) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        this(baseFileName, logDirectory, 0, 4, null);
    }

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        this(baseFileName, null, 0, 6, null);
    }

    private static final boolean cleanOldLogs$lambda-0(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final int cleanOldLogs$lambda-1(Path file1, Path file2) {
        return Files.getLastModifiedTime(file1, new LinkOption[0]).compareTo(Files.getLastModifiedTime(file2, new LinkOption[0]));
    }
}

