/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.serialization.SerializableType;
import com.almasb.fxgl.input.CaptureData;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.MouseTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.TriggerListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/input/InputCapture;", "Lcom/almasb/fxgl/input/TriggerListener;", "Lcom/almasb/fxgl/core/serialization/SerializableType;", "()V", "data", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/input/CaptureData;", "Lkotlin/collections/ArrayList;", "timeSinceCaptureStarted", "", "onActionBegin", "", "trigger", "Lcom/almasb/fxgl/input/Trigger;", "onActionEnd", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "update", "tpf", "write", "CaptureApplier", "fxgl-core"})
public final class InputCapture
extends TriggerListener
implements SerializableType {
    private double timeSinceCaptureStarted;
    @NotNull
    private final ArrayList<CaptureData> data;

    public InputCapture() {
        boolean bl = false;
        this.data = new ArrayList();
    }

    public final void update(double tpf) {
        InputCapture inputCapture = this;
        inputCapture.timeSinceCaptureStarted += tpf;
    }

    @Override
    protected void onActionBegin(@NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        InputCapture inputCapture = this;
        Collection collection = inputCapture.data;
        CaptureData captureData = new CaptureData(this.timeSinceCaptureStarted, trigger, true);
        boolean bl = false;
        collection.add(captureData);
    }

    @Override
    protected void onActionEnd(@NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        InputCapture inputCapture = this;
        Collection collection = inputCapture.data;
        CaptureData captureData = new CaptureData(this.timeSinceCaptureStarted, trigger, false);
        boolean bl = false;
        collection.add(captureData);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        bundle.put("size", Integer.valueOf(this.data.size()));
        Iterable $this$forEachIndexed$iv = this.data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void captureData;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CaptureData captureData2 = (CaptureData)item$iv;
            int i = n;
            boolean bl2 = false;
            Bundle b = new Bundle(Intrinsics.stringPlus((String)"Data", (Object)i));
            boolean bl3 = false;
            boolean bl4 = false;
            Bundle $this$write_u24lambda_u2d1_u24lambda_u2d0 = b;
            boolean bl5 = false;
            $this$write_u24lambda_u2d1_u24lambda_u2d0.put("time", Double.valueOf(captureData.getTime()));
            $this$write_u24lambda_u2d1_u24lambda_u2d0.put("isPressed", Boolean.valueOf(captureData.isPressed()));
            $this$write_u24lambda_u2d1_u24lambda_u2d0.put("isKeyTrigger", Boolean.valueOf(captureData.getTrigger().isKey()));
            if (captureData.getTrigger().isKey()) {
                $this$write_u24lambda_u2d1_u24lambda_u2d0.put("key", (Serializable)((KeyTrigger)captureData.getTrigger()).getKey());
            } else {
                $this$write_u24lambda_u2d1_u24lambda_u2d0.put("btn", (Serializable)((MouseTrigger)captureData.getTrigger()).getButton());
            }
            bundle.put(b.getName(), b);
        }
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        int size = ((Number)bundle.get("size")).intValue();
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                Bundle b = (Bundle)bundle.get(Intrinsics.stringPlus((String)"Data", (Object)i));
                double time = ((Number)b.get("time")).doubleValue();
                boolean isPressed = (Boolean)b.get("isPressed");
                boolean isKeyTrigger = (Boolean)b.get("isKeyTrigger");
                Trigger trigger = isKeyTrigger ? (Trigger)new KeyTrigger((KeyCode)b.get("key"), null, 2, null) : (Trigger)new MouseTrigger((MouseButton)b.get("btn"), null, 2, null);
                InputCapture inputCapture = this;
                Collection collection = inputCapture.data;
                CaptureData captureData = new CaptureData(time, trigger, isPressed);
                boolean bl = false;
                collection.add(captureData);
            } while (n < size);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/input/InputCapture$CaptureApplier;", "", "input", "Lcom/almasb/fxgl/input/Input;", "capture", "Lcom/almasb/fxgl/input/InputCapture;", "(Lcom/almasb/fxgl/input/Input;Lcom/almasb/fxgl/input/InputCapture;)V", "index", "", "time", "", "update", "", "tpf", "fxgl-core"})
    public static final class CaptureApplier {
        @NotNull
        private final Input input;
        @NotNull
        private final InputCapture capture;
        private double time;
        private int index;

        public CaptureApplier(@NotNull Input input, @NotNull InputCapture capture) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
            this.input = input;
            this.capture = capture;
        }

        public final void update(double tpf) {
            if (this.index == this.capture.data.size()) {
                return;
            }
            CaptureApplier captureApplier = this;
            captureApplier.time += tpf;
            while (this.index < this.capture.data.size()) {
                Object object = this.capture.data.get(this.index);
                Intrinsics.checkNotNullExpressionValue(object, (String)"capture.data[index]");
                CaptureData data = (CaptureData)object;
                if (!(data.getTime() <= this.time)) break;
                if (data.isPressed()) {
                    this.input.mockTriggerPress(data.getTrigger());
                } else {
                    this.input.mockTriggerRelease(data.getTrigger());
                }
                object = this;
                int n = ((CaptureApplier)object).index;
                ((CaptureApplier)object).index = n + 1;
            }
        }
    }
}

