/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.event;

import com.almasb.fxgl.event.Subscriber;
import com.almasb.fxgl.logging.Logger;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u000e0\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ.\u0010\u0017\u001a\u00020\u0015\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u000e0\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/event/EventBus;", "", "()V", "eventHandlers", "Ljavafx/scene/Group;", "isLoggingEnabled", "", "()Z", "setLoggingEnabled", "(Z)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "addEventHandler", "Lcom/almasb/fxgl/event/Subscriber;", "T", "Ljavafx/event/Event;", "eventType", "Ljavafx/event/EventType;", "eventHandler", "Ljavafx/event/EventHandler;", "fireEvent", "", "event", "removeEventHandler", "fxgl-core"})
public final class EventBus {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @NotNull
    private final Group eventHandlers = new Group();
    private boolean isLoggingEnabled = true;

    public final boolean isLoggingEnabled() {
        return this.isLoggingEnabled;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.isLoggingEnabled = bl;
    }

    @NotNull
    public final <T extends Event> Subscriber addEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        this.eventHandlers.addEventHandler(eventType, eventHandler);
        return new Subscriber(this, eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        this.eventHandlers.removeEventHandler(eventType, eventHandler);
    }

    public final void fireEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isLoggingEnabled) {
            this.log.debug(Intrinsics.stringPlus((String)"Firing event: ", (Object)event));
        }
        this.eventHandlers.fireEvent(event);
    }
}

