/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.Distances;
import com.almasb.fxgl.core.math.PerlinNoiseGenerator;
import com.almasb.fxgl.core.math.SimplexNoise;
import com.almasb.fxgl.core.math.Vec2;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.paint.Color;

public final class FXGLMath {
    public static final double EPSILON = 1.1920928955078125E-7;
    public static final double PI = Math.PI;
    public static final double PI2 = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final float PI_F = (float)Math.PI;
    public static final float PI2_F = (float)Math.PI * 2;
    public static final float HALF_PI_F = 1.5707964f;
    public static final double E = Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final double radFull = Math.PI * 2;
    private static final double degFull = 360.0;
    private static final double radToIndex = 2607.5945876176133;
    private static final double degToIndex = 45.51111111111111;
    private static final double radiansToDegrees = 57.29577951308232;
    private static final double degreesToRadians = Math.PI / 180;
    private static Random random = new Random();
    private static final PerlinNoiseGenerator generator = FXGLMath.getNoise1DGenerator(0L);

    private FXGLMath() {
    }

    public static double sin(double radians) {
        return Sin.table[(int)(radians * 2607.5945876176133) & 0x3FFF];
    }

    public static double cos(double radians) {
        return Sin.table[(int)((radians + 1.5707963267948966) * 2607.5945876176133) & 0x3FFF];
    }

    public static double sinDeg(double degrees) {
        return Sin.table[(int)(degrees * 45.51111111111111) & 0x3FFF];
    }

    public static double cosDeg(double degrees) {
        return Sin.table[(int)((degrees + 90.0) * 45.51111111111111) & 0x3FFF];
    }

    public static float sinF(double radians) {
        return (float)FXGLMath.sin(radians);
    }

    public static float cosF(double radians) {
        return (float)FXGLMath.cos(radians);
    }

    public static float sinDegF(double degrees) {
        return (float)FXGLMath.sinDeg(degrees);
    }

    public static float cosDegF(double degrees) {
        return (float)FXGLMath.cosDeg(degrees);
    }

    public static double toDegrees(double radians) {
        return 57.29577951308232 * radians;
    }

    public static double toRadians(double degrees) {
        return Math.PI / 180 * degrees;
    }

    public static double atan2(double y, double x) {
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (Math.abs(z) < 1.0) {
            double atan = z / (1.0 + 0.28 * z * z);
            if (x < 0.0) {
                return atan + (y < 0.0 ? -Math.PI : Math.PI);
            }
            return atan;
        }
        double atan = 1.5707963267948966 - z / (z * z + 0.28);
        return y < 0.0 ? atan - Math.PI : atan;
    }

    public static double atan2Deg(double y, double x) {
        return FXGLMath.toDegrees(FXGLMath.atan2(y, x));
    }

    public static Point2D rotate(Point2D point, Point2D pivot, double angle) {
        double px = point.getX() - pivot.getX();
        double py = point.getY() - pivot.getY();
        double c = FXGLMath.cosDeg(angle);
        double s = FXGLMath.sinDeg(angle);
        double pxNew = px * c - py * s;
        double pyNew = px * s + py * c;
        return new Point2D(pxNew + pivot.getX(), pyNew + pivot.getY());
    }

    public static void setRandom(Random random) {
        FXGLMath.random = random;
    }

    public static Random getRandom() {
        return random;
    }

    public static Random getRandom(long seed) {
        return new Random(seed);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static long random(long start, long end) {
        return start + (long)(random.nextDouble() * (double)(end - start));
    }

    public static double random(double start, double end) {
        return start + random.nextDouble() * (end - start);
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(double chance) {
        return FXGLMath.randomDouble() < chance;
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static Point2D randomPoint(Rectangle2D bounds) {
        return new Point2D(FXGLMath.random(bounds.getMinX(), bounds.getMaxX()), FXGLMath.random(bounds.getMinY(), bounds.getMaxY()));
    }

    public static Point2D randomPoint2D() {
        return FXGLMath.randomVec2().toPoint2D();
    }

    public static Vec2 randomVec2() {
        return new Vec2(FXGLMath.random(-1.0, 1.0), FXGLMath.random(-1.0, 1.0)).normalizeLocal();
    }

    public static Color randomColor() {
        return Color.color((double)FXGLMath.randomDouble(), (double)FXGLMath.randomDouble(), (double)FXGLMath.randomDouble());
    }

    public static <T> Optional<T> random(T[] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[FXGLMath.random(0, array.length - 1)]);
    }

    public static <T> Optional<T> random(List<T> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(FXGLMath.random(0, list.size() - 1)));
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static float sqrtF(float x) {
        return (float)StrictMath.sqrt(x);
    }

    public static double map(double value, double currentRangeStart, double currentRangeStop, double targetRangeStart, double targetRangeStop) {
        return targetRangeStart + (targetRangeStop - targetRangeStart) * ((value - currentRangeStart) / (currentRangeStop - currentRangeStart));
    }

    public static float clamp(float a, float low, float high) {
        return Math.max(low, Math.min(a, high));
    }

    public static int floor(float x) {
        int y = (int)x;
        if (x < (float)y) {
            return y - 1;
        }
        return y;
    }

    public static float abs(float value) {
        return value > 0.0f ? value : -value;
    }

    public static double abs(double value) {
        return value > 0.0 ? value : -value;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static Point2D bezier(Point2D p1, Point2D p2, Point2D p3, double t) {
        double x = (1.0 - t) * (1.0 - t) * p1.getX() + 2.0 * (1.0 - t) * t * p2.getX() + t * t * p3.getX();
        double y = (1.0 - t) * (1.0 - t) * p1.getY() + 2.0 * (1.0 - t) * t * p2.getY() + t * t * p3.getY();
        return new Point2D(x, y);
    }

    public static Point2D bezier(Point2D p1, Point2D p2, Point2D p3, Point2D p4, double t) {
        double x = Math.pow(1.0 - t, 3.0) * p1.getX() + 3.0 * t * Math.pow(1.0 - t, 2.0) * p2.getX() + 3.0 * t * t * (1.0 - t) * p3.getX() + t * t * t * p4.getX();
        double y = Math.pow(1.0 - t, 3.0) * p1.getY() + 3.0 * t * Math.pow(1.0 - t, 2.0) * p2.getY() + 3.0 * t * t * (1.0 - t) * p3.getY() + t * t * t * p4.getY();
        return new Point2D(x, y);
    }

    public static double noise1D(double t) {
        return generator.noise1D(t);
    }

    public static PerlinNoiseGenerator getNoise1DGenerator(long seed) {
        return new PerlinNoiseGenerator(seed);
    }

    public static double noise2D(double x, double y) {
        return SimplexNoise.noise2D(x, y);
    }

    public static double noise3D(double x, double y, double z) {
        return SimplexNoise.noise3D(x, y, z);
    }

    public static double distance(Rectangle2D rect1, Rectangle2D rect2) {
        return Distances.INSTANCE.distance(rect1, rect2);
    }

    private static class Sin {
        static final double[] table;

        private Sin() {
        }

        static {
            int i;
            table = new double[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = Math.sin((double)(((float)i + 0.5f) / 16384.0f) * (Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((double)i * 45.51111111111111) & 0x3FFF] = Math.sin(FXGLMath.toRadians(i));
            }
        }
    }
}

