/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.webapi.method.groups;

import allbegray.slack.validation.Problem;
import allbegray.slack.validation.SlackFieldValidationUtils;
import allbegray.slack.validation.ValidationError;
import allbegray.slack.webapi.method.AbstractMethod;
import java.util.List;
import java.util.Map;

public class GroupCreateMethod
extends AbstractMethod {
    protected String channel;

    public GroupCreateMethod(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public String getMethodName() {
        return "groups.create";
    }

    @Override
    public void validate(List<ValidationError> errors) {
        if (this.channel == null) {
            errors.add(new ValidationError("channel", Problem.REQUIRED, null));
        } else if (!SlackFieldValidationUtils.validChannelName(this.channel)) {
            errors.add(new ValidationError("channel", Problem.PATTERN_NOT_MATCH, "check the link. https://slack.zendesk.com/hc/en-us/articles/201402297-Creating-a-channel"));
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        parameters.put("channel", this.channel);
    }
}

