/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack;

public class SlackTextBuilder {
    private StringBuffer buffer = new StringBuffer();

    public static SlackTextBuilder create() {
        return new SlackTextBuilder();
    }

    protected SlackTextBuilder() {
    }

    public SlackTextBuilder text(String text) {
        this.buffer.append(text);
        return this;
    }

    public SlackTextBuilder mail(String email) {
        return this.mail(email, null);
    }

    public SlackTextBuilder mail(String email, String text) {
        return this.link("mailto:" + email, text);
    }

    public SlackTextBuilder link(String url) {
        return this.link(url, null);
    }

    public SlackTextBuilder link(String url, String text) {
        if (text != null && text.length() > 0) {
            this.buffer.append("<").append(url).append("|").append(text).append(">");
        } else {
            this.buffer.append("<").append(url).append(">");
        }
        return this;
    }

    public SlackTextBuilder bold(String text) {
        this.buffer.append(" *").append(text).append("*");
        return this;
    }

    public SlackTextBuilder italic(String text) {
        this.buffer.append(" _").append(text).append("_");
        return this;
    }

    public SlackTextBuilder strike(String text) {
        this.buffer.append(" ~").append(text).append("~");
        return this;
    }

    public SlackTextBuilder code(String code) {
        this.buffer.append("`").append(code).append("`");
        return this;
    }

    public SlackTextBuilder preformatted(String text) {
        this.buffer.append("\n```").append(text).append("```");
        return this;
    }

    public SlackTextBuilder quote(String text) {
        this.buffer.append("\n> ").append(text).append("\n");
        return this;
    }

    public SlackTextBuilder paragraph(String text) {
        this.buffer.append("\n>>> ").append(text).append("\n");
        return this;
    }

    public SlackTextBuilder newline() {
        this.buffer.append("\n");
        return this;
    }

    public String build() {
        return this.buffer.length() > 0 ? this.buffer.toString() : null;
    }
}

