/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack;

import allbegray.slack.bot.SlackbotClient;
import allbegray.slack.rtm.ProxyServerInfo;
import allbegray.slack.rtm.SlackRealTimeMessagingClient;
import allbegray.slack.webapi.SlackWebApiClient;
import allbegray.slack.webapi.SlackWebApiClientImpl;
import allbegray.slack.webhook.SlackWebhookClient;
import com.fasterxml.jackson.databind.ObjectMapper;

public abstract class SlackClientFactory {
    public static SlackWebApiClient createWebApiClient(String token) {
        return new SlackWebApiClientImpl(token);
    }

    public static SlackWebApiClient createWebApiClient(String token, ProxyServerInfo proxyServerInfo) {
        return new SlackWebApiClientImpl(token, proxyServerInfo);
    }

    public static SlackWebApiClient createWebApiClient(String token, ObjectMapper mapper) {
        return new SlackWebApiClientImpl(token, mapper);
    }

    public static SlackWebApiClient createWebApiClient(String token, ObjectMapper mapper, ProxyServerInfo proxyServerInfo) {
        return new SlackWebApiClientImpl(token, mapper, proxyServerInfo);
    }

    public static SlackWebApiClient createWebApiClient(String token, ObjectMapper mapper, int timeout) {
        return new SlackWebApiClientImpl(token, mapper, timeout);
    }

    public static SlackWebApiClient createWebApiClient(String token, ObjectMapper mapper, int timeout, ProxyServerInfo proxyServerInfo) {
        return new SlackWebApiClientImpl(token, mapper, timeout, proxyServerInfo);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl) {
        return new SlackWebhookClient(webhookUrl);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl, ProxyServerInfo proxyServerInfo) {
        return new SlackWebhookClient(webhookUrl, proxyServerInfo);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl, ObjectMapper mapper) {
        return new SlackWebhookClient(webhookUrl, mapper);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl, ObjectMapper mapper, ProxyServerInfo proxyServerInfo) {
        return new SlackWebhookClient(webhookUrl, mapper, proxyServerInfo);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl, ObjectMapper mapper, int timeout) {
        return new SlackWebhookClient(webhookUrl, mapper, timeout);
    }

    public static SlackWebhookClient createWebhookClient(String webhookUrl, ObjectMapper mapper, int timeout, ProxyServerInfo proxyServerInfo) {
        return new SlackWebhookClient(webhookUrl, mapper, timeout, proxyServerInfo);
    }

    public static SlackbotClient createSlackbotClient(String slackbotUrl) {
        return new SlackbotClient(slackbotUrl);
    }

    public static SlackbotClient createSlackbotClient(String slackbotUrl, ProxyServerInfo proxyServerInfo) {
        return new SlackbotClient(slackbotUrl, proxyServerInfo);
    }

    public static SlackbotClient createSlackbotClient(String slackbotUrl, int timeout) {
        return new SlackbotClient(slackbotUrl, timeout);
    }

    public static SlackbotClient createSlackbotClient(String slackbotUrl, int timeout, ProxyServerInfo proxyServerInfo) {
        return new SlackbotClient(slackbotUrl, timeout, proxyServerInfo);
    }

    public static SlackRealTimeMessagingClient createSlackRealTimeMessagingClient(String token) {
        return SlackClientFactory.createSlackRealTimeMessagingClient(token, null, null);
    }

    public static SlackRealTimeMessagingClient createSlackRealTimeMessagingClient(String token, ProxyServerInfo proxyServerInfo) {
        return SlackClientFactory.createSlackRealTimeMessagingClient(token, null, proxyServerInfo);
    }

    public static SlackRealTimeMessagingClient createSlackRealTimeMessagingClient(String token, ObjectMapper mapper) {
        return SlackClientFactory.createSlackRealTimeMessagingClient(token, mapper, null);
    }

    public static SlackRealTimeMessagingClient createSlackRealTimeMessagingClient(String token, ObjectMapper mapper, ProxyServerInfo proxyServerInfo) {
        SlackWebApiClient webApiClient = SlackClientFactory.createWebApiClient(token, proxyServerInfo);
        String webSocketUrl = webApiClient.startRealTimeMessagingApi().findPath("url").asText();
        return new SlackRealTimeMessagingClient(webSocketUrl, mapper, proxyServerInfo);
    }
}

