/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack;

import allbegray.slack.StringResponseHandler;
import allbegray.slack.exception.SlackException;
import allbegray.slack.rtm.ProxyServerInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public abstract class RestUtils {
    private static Log logger = LogFactory.getLog(RestUtils.class);

    public static HttpEntity createUrlEncodedFormEntity(Map<String, String> parameters) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>(parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return new UrlEncodedFormEntity(nvps, Charset.forName("UTF-8"));
    }

    public static HttpEntity createMultipartFormEntity(Map<String, String> parameters, InputStream is) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
        multipartEntityBuilder.addBinaryBody("file", is, ContentType.create((String)"application/octet-stream"), "file");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue());
        }
        return multipartEntityBuilder.build();
    }

    public static CloseableHttpClient createHttpClient(int timeout) {
        return RestUtils.createHttpClient(timeout, null);
    }

    public static CloseableHttpClient createHttpClient(int timeout, ProxyServerInfo proxyServerInfo) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
        if (proxyServerInfo != null) {
            HttpHost proxy = new HttpHost(proxyServerInfo.getHost(), proxyServerInfo.getPort(), proxyServerInfo.getProtocol());
            httpClientBuilder = httpClientBuilder.setProxy(proxy);
            if (proxyServerInfo.getPrincipal() != null && proxyServerInfo.getPassword() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyServerInfo.getPrincipal(), proxyServerInfo.getPassword());
                AuthScope authScope = new AuthScope(proxyServerInfo.getHost(), proxyServerInfo.getPort());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return httpClientBuilder.build();
    }

    public static String execute(CloseableHttpClient httpClient, String url, HttpEntity httpEntity) {
        logger.debug((Object)("url : " + url));
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(httpEntity);
            String retStr = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new StringResponseHandler());
            logger.debug((Object)("return : " + retStr));
            return retStr;
        }
        catch (IOException e) {
            throw new SlackException(e);
        }
    }
}

