/*
 * Decompiled with CFR 0.152.
 */
package com.yang.flowlayoutlibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yang.flowlayoutlibrary.R;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends RelativeLayout {
    private int horizontalSpacing = this.dp2px(15.0f);
    private int verticalSpacing = this.dp2px(15.0f);
    private List<Line> lines = new ArrayList<Line>();
    private Line line;
    private int lineSize = 0;
    private int textSize = this.sp2px(15.0f);
    private int textColor = -16777216;
    private int backgroundResource = R.drawable.bg_frame;
    private int textPaddingH = this.dp2px(15.0f);
    private int textPaddingV = this.dp2px(8.0f);

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlowLayoutAttrs, defStyleAttr, 0);
        int count = typedArray.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.FlowLayoutAttrs_horizontalSpacing) {
                this.horizontalSpacing = typedArray.getDimensionPixelSize(attr, this.dp2px(10.0f));
                continue;
            }
            if (attr == R.styleable.FlowLayoutAttrs_verticalSpacing) {
                this.verticalSpacing = typedArray.getDimensionPixelSize(attr, this.dp2px(10.0f));
                continue;
            }
            if (attr == R.styleable.FlowLayoutAttrs_itemSize) {
                this.textSize = typedArray.getDimensionPixelSize(attr, this.sp2px(15.0f));
                continue;
            }
            if (attr == R.styleable.FlowLayoutAttrs_itemColor) {
                this.textColor = typedArray.getColor(attr, -16777216);
                continue;
            }
            if (attr == R.styleable.FlowLayoutAttrs_backgroundResource) {
                this.backgroundResource = typedArray.getResourceId(attr, R.drawable.bg_frame);
                continue;
            }
            if (attr == R.styleable.FlowLayoutAttrs_textPaddingH) {
                this.textPaddingH = typedArray.getDimensionPixelSize(attr, this.dp2px(7.0f));
                continue;
            }
            if (attr != R.styleable.FlowLayoutAttrs_textPaddingV) continue;
            this.textPaddingV = typedArray.getDimensionPixelSize(attr, this.dp2px(4.0f));
        }
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingBottom() - this.getPaddingTop();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.restoreLine();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)(widthMode == 0x40000000 ? Integer.MIN_VALUE : widthMode));
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)(heightMode == 0x40000000 ? Integer.MIN_VALUE : heightMode));
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            if (this.line == null) {
                this.line = new Line();
            }
            int measuredWidth = child.getMeasuredWidth();
            this.lineSize += measuredWidth;
            if (this.lineSize <= width) {
                this.line.addChild(child);
                this.lineSize += this.horizontalSpacing;
                continue;
            }
            this.newLine();
            this.line.addChild(child);
            this.lineSize += child.getMeasuredWidth();
            this.lineSize += this.horizontalSpacing;
        }
        if (this.line != null && !this.lines.contains(this.line)) {
            this.lines.add(this.line);
        }
        int totalHeight = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            totalHeight += this.lines.get(i).getHeight();
        }
        totalHeight += this.verticalSpacing * (this.lines.size() - 1);
        totalHeight += this.getPaddingBottom();
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), FlowLayout.resolveSize((int)(totalHeight += this.getPaddingTop()), (int)heightMeasureSpec));
    }

    private void restoreLine() {
        this.lines.clear();
        this.line = new Line();
        this.lineSize = 0;
    }

    private void newLine() {
        if (this.line != null) {
            this.lines.add(this.line);
        }
        this.line = new Line();
        this.lineSize = 0;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            line.layout(left, top);
            top = top + line.getHeight() + this.verticalSpacing;
        }
    }

    @Deprecated
    public void setFlowLayout(List<String> list, OnItemClickListener onItemClickListener) {
        this.removeAllViews();
        this.addViews(list, onItemClickListener);
    }

    public void setView(String str, OnItemClickListener onItemClickListener) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(str);
        this.setViews(list, onItemClickListener);
    }

    public void setViews(List<String> list, OnItemClickListener onItemClickListener) {
        this.removeAllViews();
        this.addViews(list, onItemClickListener);
    }

    public void addView(String str, OnItemClickListener onItemClickListener) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(str);
        this.addViews(list, onItemClickListener);
    }

    public void addViews(List<String> list, final OnItemClickListener onItemClickListener) {
        for (int i = 0; i < list.size(); ++i) {
            final TextView tv = new TextView(this.getContext());
            tv.setText((CharSequence)list.get(i));
            tv.setTextSize(0, (float)this.textSize);
            tv.setTextColor(this.textColor);
            tv.setGravity(17);
            tv.setPadding(this.textPaddingH, this.textPaddingV, this.textPaddingH, this.textPaddingV);
            tv.setClickable(true);
            tv.setBackgroundResource(this.backgroundResource);
            this.addView((View)tv, new ViewGroup.LayoutParams(-2, -2));
            if (onItemClickListener == null) continue;
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    onItemClickListener.onItemClick(tv.getText().toString());
                }
            });
        }
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = this.dp2px(horizontalSpacing);
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = this.dp2px(verticalSpacing);
    }

    public void setTextSize(int textSize) {
        this.textSize = this.sp2px(textSize);
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setBackgroundResource(int backgroundResource) {
        this.backgroundResource = backgroundResource;
    }

    public void setTextPaddingH(int textPaddingH) {
        this.textPaddingH = this.dp2px(textPaddingH);
    }

    public void setTextPaddingV(int textPaddingV) {
        this.textPaddingV = this.dp2px(textPaddingV);
    }

    private int dp2px(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int sp2px(float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1);
    }

    class Line {
        private List<View> children = new ArrayList<View>();
        int height;

        Line() {
        }

        public void addChild(View childView) {
            this.children.add(childView);
            if (this.height < childView.getMeasuredHeight()) {
                this.height = childView.getMeasuredHeight();
            }
        }

        public void layout(int left, int top) {
            int totalWidth = FlowLayout.this.getMeasuredWidth() - FlowLayout.this.getPaddingLeft() - FlowLayout.this.getPaddingRight();
            int currentLeft = left;
            for (int i = 0; i < this.children.size(); ++i) {
                View view = this.children.get(i);
                view.layout(currentLeft, top, currentLeft + view.getMeasuredWidth(), top + view.getMeasuredHeight());
                currentLeft = currentLeft + view.getMeasuredWidth() + FlowLayout.this.horizontalSpacing;
            }
        }

        public int getHeight() {
            return this.height;
        }

        public int getChildCount() {
            return this.children.size();
        }
    }
}

